/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeTimeBasedAutoScaling</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTimeBasedAutoScalingResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeTimeBasedAutoScalingResponse.Builder, DescribeTimeBasedAutoScalingResponse> {
    private static final SdkField<List<TimeBasedAutoScalingConfiguration>> TIME_BASED_AUTO_SCALING_CONFIGURATIONS_FIELD = SdkField
            .<List<TimeBasedAutoScalingConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTimeBasedAutoScalingResponse::timeBasedAutoScalingConfigurations))
            .setter(setter(Builder::timeBasedAutoScalingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeBasedAutoScalingConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeBasedAutoScalingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeBasedAutoScalingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TIME_BASED_AUTO_SCALING_CONFIGURATIONS_FIELD));

    private final List<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations;

    private DescribeTimeBasedAutoScalingResponse(BuilderImpl builder) {
        super(builder);
        this.timeBasedAutoScalingConfigurations = builder.timeBasedAutoScalingConfigurations;
    }

    /**
     * <p>
     * An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for the
     * specified instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for
     *         the specified instances.
     */
    public List<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations() {
        return timeBasedAutoScalingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timeBasedAutoScalingConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTimeBasedAutoScalingResponse)) {
            return false;
        }
        DescribeTimeBasedAutoScalingResponse other = (DescribeTimeBasedAutoScalingResponse) obj;
        return Objects.equals(timeBasedAutoScalingConfigurations(), other.timeBasedAutoScalingConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTimeBasedAutoScalingResponse")
                .add("TimeBasedAutoScalingConfigurations", timeBasedAutoScalingConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeBasedAutoScalingConfigurations":
            return Optional.ofNullable(clazz.cast(timeBasedAutoScalingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTimeBasedAutoScalingResponse, T> g) {
        return obj -> g.apply((DescribeTimeBasedAutoScalingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTimeBasedAutoScalingResponse> {
        /**
         * <p>
         * An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for the
         * specified instances.
         * </p>
         * 
         * @param timeBasedAutoScalingConfigurations
         *        An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for
         *        the specified instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeBasedAutoScalingConfigurations(
                Collection<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations);

        /**
         * <p>
         * An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for the
         * specified instances.
         * </p>
         * 
         * @param timeBasedAutoScalingConfigurations
         *        An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for
         *        the specified instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeBasedAutoScalingConfigurations(TimeBasedAutoScalingConfiguration... timeBasedAutoScalingConfigurations);

        /**
         * <p>
         * An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for the
         * specified instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TimeBasedAutoScalingConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<TimeBasedAutoScalingConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TimeBasedAutoScalingConfiguration>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #timeBasedAutoScalingConfigurations(List<TimeBasedAutoScalingConfiguration>)}.
         * 
         * @param timeBasedAutoScalingConfigurations
         *        a consumer that will call methods on {@link List<TimeBasedAutoScalingConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeBasedAutoScalingConfigurations(List<TimeBasedAutoScalingConfiguration>)
         */
        Builder timeBasedAutoScalingConfigurations(
                Consumer<TimeBasedAutoScalingConfiguration.Builder>... timeBasedAutoScalingConfigurations);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTimeBasedAutoScalingResponse model) {
            super(model);
            timeBasedAutoScalingConfigurations(model.timeBasedAutoScalingConfigurations);
        }

        public final Collection<TimeBasedAutoScalingConfiguration.Builder> getTimeBasedAutoScalingConfigurations() {
            return timeBasedAutoScalingConfigurations != null ? timeBasedAutoScalingConfigurations.stream()
                    .map(TimeBasedAutoScalingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder timeBasedAutoScalingConfigurations(
                Collection<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations) {
            this.timeBasedAutoScalingConfigurations = TimeBasedAutoScalingConfigurationsCopier
                    .copy(timeBasedAutoScalingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeBasedAutoScalingConfigurations(
                TimeBasedAutoScalingConfiguration... timeBasedAutoScalingConfigurations) {
            timeBasedAutoScalingConfigurations(Arrays.asList(timeBasedAutoScalingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeBasedAutoScalingConfigurations(
                Consumer<TimeBasedAutoScalingConfiguration.Builder>... timeBasedAutoScalingConfigurations) {
            timeBasedAutoScalingConfigurations(Stream.of(timeBasedAutoScalingConfigurations)
                    .map(c -> TimeBasedAutoScalingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTimeBasedAutoScalingConfigurations(
                Collection<TimeBasedAutoScalingConfiguration.BuilderImpl> timeBasedAutoScalingConfigurations) {
            this.timeBasedAutoScalingConfigurations = TimeBasedAutoScalingConfigurationsCopier
                    .copyFromBuilder(timeBasedAutoScalingConfigurations);
        }

        @Override
        public DescribeTimeBasedAutoScalingResponse build() {
            return new DescribeTimeBasedAutoScalingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
