/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>RegisterEcsCluster</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterEcsClusterResponse extends OpsWorksResponse implements
        ToCopyableBuilder<RegisterEcsClusterResponse.Builder, RegisterEcsClusterResponse> {
    private static final SdkField<String> ECS_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterEcsClusterResponse::ecsClusterArn)).setter(setter(Builder::ecsClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsClusterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECS_CLUSTER_ARN_FIELD));

    private final String ecsClusterArn;

    private RegisterEcsClusterResponse(BuilderImpl builder) {
        super(builder);
        this.ecsClusterArn = builder.ecsClusterArn;
    }

    /**
     * <p>
     * The cluster's ARN.
     * </p>
     * 
     * @return The cluster's ARN.
     */
    public String ecsClusterArn() {
        return ecsClusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusterArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterEcsClusterResponse)) {
            return false;
        }
        RegisterEcsClusterResponse other = (RegisterEcsClusterResponse) obj;
        return Objects.equals(ecsClusterArn(), other.ecsClusterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterEcsClusterResponse").add("EcsClusterArn", ecsClusterArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EcsClusterArn":
            return Optional.ofNullable(clazz.cast(ecsClusterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterEcsClusterResponse, T> g) {
        return obj -> g.apply((RegisterEcsClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterEcsClusterResponse> {
        /**
         * <p>
         * The cluster's ARN.
         * </p>
         * 
         * @param ecsClusterArn
         *        The cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArn(String ecsClusterArn);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private String ecsClusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterEcsClusterResponse model) {
            super(model);
            ecsClusterArn(model.ecsClusterArn);
        }

        public final String getEcsClusterArn() {
            return ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        @Override
        public RegisterEcsClusterResponse build() {
            return new RegisterEcsClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
