/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserProfileRequest extends OpsWorksRequest implements
        ToCopyableBuilder<UpdateUserProfileRequest.Builder, UpdateUserProfileRequest> {
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserProfileRequest::iamUserArn)).setter(setter(Builder::iamUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()).build();

    private static final SdkField<String> SSH_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserProfileRequest::sshUsername)).setter(setter(Builder::sshUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshUsername").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserProfileRequest::sshPublicKey)).setter(setter(Builder::sshPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKey").build()).build();

    private static final SdkField<Boolean> ALLOW_SELF_MANAGEMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateUserProfileRequest::allowSelfManagement)).setter(setter(Builder::allowSelfManagement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSelfManagement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_USER_ARN_FIELD,
            SSH_USERNAME_FIELD, SSH_PUBLIC_KEY_FIELD, ALLOW_SELF_MANAGEMENT_FIELD));

    private final String iamUserArn;

    private final String sshUsername;

    private final String sshPublicKey;

    private final Boolean allowSelfManagement;

    private UpdateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArn = builder.iamUserArn;
        this.sshUsername = builder.sshUsername;
        this.sshPublicKey = builder.sshPublicKey;
        this.allowSelfManagement = builder.allowSelfManagement;
    }

    /**
     * <p>
     * The user IAM ARN. This can also be a federated user's ARN.
     * </p>
     * 
     * @return The user IAM ARN. This can also be a federated user's ARN.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name
     * includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be
     * changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from
     * the IAM user name.
     * </p>
     * 
     * @return The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the
     *         specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example,
     *         <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS
     *         OpsWorks Stacks generates one from the IAM user name.
     */
    public String sshUsername() {
        return sshUsername;
    }

    /**
     * <p>
     * The user's new SSH public key.
     * </p>
     * 
     * @return The user's new SSH public key.
     */
    public String sshPublicKey() {
        return sshPublicKey;
    }

    /**
     * <p>
     * Whether users can specify their own SSH public key through the My Settings page. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
     * Permissions</a>.
     * </p>
     * 
     * @return Whether users can specify their own SSH public key through the My Settings page. For more information,
     *         see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing
     *         User Permissions</a>.
     */
    public Boolean allowSelfManagement() {
        return allowSelfManagement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(sshUsername());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(allowSelfManagement());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserProfileRequest)) {
            return false;
        }
        UpdateUserProfileRequest other = (UpdateUserProfileRequest) obj;
        return Objects.equals(iamUserArn(), other.iamUserArn()) && Objects.equals(sshUsername(), other.sshUsername())
                && Objects.equals(sshPublicKey(), other.sshPublicKey())
                && Objects.equals(allowSelfManagement(), other.allowSelfManagement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateUserProfileRequest").add("IamUserArn", iamUserArn()).add("SshUsername", sshUsername())
                .add("SshPublicKey", sshPublicKey()).add("AllowSelfManagement", allowSelfManagement()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamUserArn":
            return Optional.ofNullable(clazz.cast(iamUserArn()));
        case "SshUsername":
            return Optional.ofNullable(clazz.cast(sshUsername()));
        case "SshPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        case "AllowSelfManagement":
            return Optional.ofNullable(clazz.cast(allowSelfManagement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserProfileRequest, T> g) {
        return obj -> g.apply((UpdateUserProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserProfileRequest> {
        /**
         * <p>
         * The user IAM ARN. This can also be a federated user's ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user IAM ARN. This can also be a federated user's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified
         * name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code>
         * will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates
         * one from the IAM user name.
         * </p>
         * 
         * @param sshUsername
         *        The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the
         *        specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example,
         *        <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name,
         *        AWS OpsWorks Stacks generates one from the IAM user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshUsername(String sshUsername);

        /**
         * <p>
         * The user's new SSH public key.
         * </p>
         * 
         * @param sshPublicKey
         *        The user's new SSH public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);

        /**
         * <p>
         * Whether users can specify their own SSH public key through the My Settings page. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
         * Permissions</a>.
         * </p>
         * 
         * @param allowSelfManagement
         *        Whether users can specify their own SSH public key through the My Settings page. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
         *        Permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowSelfManagement(Boolean allowSelfManagement);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String iamUserArn;

        private String sshUsername;

        private String sshPublicKey;

        private Boolean allowSelfManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserProfileRequest model) {
            super(model);
            iamUserArn(model.iamUserArn);
            sshUsername(model.sshUsername);
            sshPublicKey(model.sshPublicKey);
            allowSelfManagement(model.allowSelfManagement);
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getSshUsername() {
            return sshUsername;
        }

        @Override
        public final Builder sshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        public final void setSshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Boolean getAllowSelfManagement() {
            return allowSelfManagement;
        }

        @Override
        public final Builder allowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
            return this;
        }

        public final void setAllowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserProfileRequest build() {
            return new UpdateUserProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
