/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterInstanceRequest extends OpsWorksRequest implements
        ToCopyableBuilder<RegisterInstanceRequest.Builder, RegisterInstanceRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterInstanceRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterInstanceRequest::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterInstanceRequest::publicIp)).setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").build()).build();

    private static final SdkField<String> PRIVATE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterInstanceRequest::privateIp)).setter(setter(Builder::privateIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIp").build()).build();

    private static final SdkField<String> RSA_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterInstanceRequest::rsaPublicKey)).setter(setter(Builder::rsaPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RsaPublicKey").build()).build();

    private static final SdkField<String> RSA_PUBLIC_KEY_FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterInstanceRequest::rsaPublicKeyFingerprint)).setter(setter(Builder::rsaPublicKeyFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RsaPublicKeyFingerprint").build())
            .build();

    private static final SdkField<InstanceIdentity> INSTANCE_IDENTITY_FIELD = SdkField
            .<InstanceIdentity> builder(MarshallingType.SDK_POJO).getter(getter(RegisterInstanceRequest::instanceIdentity))
            .setter(setter(Builder::instanceIdentity)).constructor(InstanceIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            HOSTNAME_FIELD, PUBLIC_IP_FIELD, PRIVATE_IP_FIELD, RSA_PUBLIC_KEY_FIELD, RSA_PUBLIC_KEY_FINGERPRINT_FIELD,
            INSTANCE_IDENTITY_FIELD));

    private final String stackId;

    private final String hostname;

    private final String publicIp;

    private final String privateIp;

    private final String rsaPublicKey;

    private final String rsaPublicKeyFingerprint;

    private final InstanceIdentity instanceIdentity;

    private RegisterInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.hostname = builder.hostname;
        this.publicIp = builder.publicIp;
        this.privateIp = builder.privateIp;
        this.rsaPublicKey = builder.rsaPublicKey;
        this.rsaPublicKeyFingerprint = builder.rsaPublicKeyFingerprint;
        this.instanceIdentity = builder.instanceIdentity;
    }

    /**
     * <p>
     * The ID of the stack that the instance is to be registered with.
     * </p>
     * 
     * @return The ID of the stack that the instance is to be registered with.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The instance's hostname.
     * </p>
     * 
     * @return The instance's hostname.
     */
    public String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The instance's public IP address.
     * </p>
     * 
     * @return The instance's public IP address.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The instance's private IP address.
     * </p>
     * 
     * @return The instance's private IP address.
     */
    public String privateIp() {
        return privateIp;
    }

    /**
     * <p>
     * The instances public RSA key. This key is used to encrypt communication between the instance and the service.
     * </p>
     * 
     * @return The instances public RSA key. This key is used to encrypt communication between the instance and the
     *         service.
     */
    public String rsaPublicKey() {
        return rsaPublicKey;
    }

    /**
     * <p>
     * The instances public RSA key fingerprint.
     * </p>
     * 
     * @return The instances public RSA key fingerprint.
     */
    public String rsaPublicKeyFingerprint() {
        return rsaPublicKeyFingerprint;
    }

    /**
     * <p>
     * An InstanceIdentity object that contains the instance's identity.
     * </p>
     * 
     * @return An InstanceIdentity object that contains the instance's identity.
     */
    public InstanceIdentity instanceIdentity() {
        return instanceIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(privateIp());
        hashCode = 31 * hashCode + Objects.hashCode(rsaPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(rsaPublicKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIdentity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceRequest)) {
            return false;
        }
        RegisterInstanceRequest other = (RegisterInstanceRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(hostname(), other.hostname())
                && Objects.equals(publicIp(), other.publicIp()) && Objects.equals(privateIp(), other.privateIp())
                && Objects.equals(rsaPublicKey(), other.rsaPublicKey())
                && Objects.equals(rsaPublicKeyFingerprint(), other.rsaPublicKeyFingerprint())
                && Objects.equals(instanceIdentity(), other.instanceIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterInstanceRequest").add("StackId", stackId()).add("Hostname", hostname())
                .add("PublicIp", publicIp()).add("PrivateIp", privateIp()).add("RsaPublicKey", rsaPublicKey())
                .add("RsaPublicKeyFingerprint", rsaPublicKeyFingerprint()).add("InstanceIdentity", instanceIdentity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "PrivateIp":
            return Optional.ofNullable(clazz.cast(privateIp()));
        case "RsaPublicKey":
            return Optional.ofNullable(clazz.cast(rsaPublicKey()));
        case "RsaPublicKeyFingerprint":
            return Optional.ofNullable(clazz.cast(rsaPublicKeyFingerprint()));
        case "InstanceIdentity":
            return Optional.ofNullable(clazz.cast(instanceIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterInstanceRequest, T> g) {
        return obj -> g.apply((RegisterInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterInstanceRequest> {
        /**
         * <p>
         * The ID of the stack that the instance is to be registered with.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack that the instance is to be registered with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The instance's hostname.
         * </p>
         * 
         * @param hostname
         *        The instance's hostname.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The instance's public IP address.
         * </p>
         * 
         * @param publicIp
         *        The instance's public IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The instance's private IP address.
         * </p>
         * 
         * @param privateIp
         *        The instance's private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIp(String privateIp);

        /**
         * <p>
         * The instances public RSA key. This key is used to encrypt communication between the instance and the service.
         * </p>
         * 
         * @param rsaPublicKey
         *        The instances public RSA key. This key is used to encrypt communication between the instance and the
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsaPublicKey(String rsaPublicKey);

        /**
         * <p>
         * The instances public RSA key fingerprint.
         * </p>
         * 
         * @param rsaPublicKeyFingerprint
         *        The instances public RSA key fingerprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsaPublicKeyFingerprint(String rsaPublicKeyFingerprint);

        /**
         * <p>
         * An InstanceIdentity object that contains the instance's identity.
         * </p>
         * 
         * @param instanceIdentity
         *        An InstanceIdentity object that contains the instance's identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdentity(InstanceIdentity instanceIdentity);

        /**
         * <p>
         * An InstanceIdentity object that contains the instance's identity.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceIdentity.Builder} avoiding the need to
         * create one manually via {@link InstanceIdentity#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceIdentity(InstanceIdentity)}.
         * 
         * @param instanceIdentity
         *        a consumer that will call methods on {@link InstanceIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceIdentity(InstanceIdentity)
         */
        default Builder instanceIdentity(Consumer<InstanceIdentity.Builder> instanceIdentity) {
            return instanceIdentity(InstanceIdentity.builder().applyMutation(instanceIdentity).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private String hostname;

        private String publicIp;

        private String privateIp;

        private String rsaPublicKey;

        private String rsaPublicKeyFingerprint;

        private InstanceIdentity instanceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceRequest model) {
            super(model);
            stackId(model.stackId);
            hostname(model.hostname);
            publicIp(model.publicIp);
            privateIp(model.privateIp);
            rsaPublicKey(model.rsaPublicKey);
            rsaPublicKeyFingerprint(model.rsaPublicKeyFingerprint);
            instanceIdentity(model.instanceIdentity);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getPrivateIp() {
            return privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getRsaPublicKey() {
            return rsaPublicKey;
        }

        @Override
        public final Builder rsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
            return this;
        }

        public final void setRsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
        }

        public final String getRsaPublicKeyFingerprint() {
            return rsaPublicKeyFingerprint;
        }

        @Override
        public final Builder rsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
            return this;
        }

        public final void setRsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
        }

        public final InstanceIdentity.Builder getInstanceIdentity() {
            return instanceIdentity != null ? instanceIdentity.toBuilder() : null;
        }

        @Override
        public final Builder instanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
            return this;
        }

        public final void setInstanceIdentity(InstanceIdentity.BuilderImpl instanceIdentity) {
            this.instanceIdentity = instanceIdentity != null ? instanceIdentity.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterInstanceRequest build() {
            return new RegisterInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
