/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRdsDbInstancesRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeRdsDbInstancesRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRdsDbInstancesRequest.getter(DescribeRdsDbInstancesRequest::stackId)).setter(DescribeRdsDbInstancesRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<List<String>> RDS_DB_INSTANCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeRdsDbInstancesRequest.getter(DescribeRdsDbInstancesRequest::rdsDbInstanceArns)).setter(DescribeRdsDbInstancesRequest.setter(Builder::rdsDbInstanceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstanceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, RDS_DB_INSTANCE_ARNS_FIELD));
    private final String stackId;
    private final List<String> rdsDbInstanceArns;

    private DescribeRdsDbInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.rdsDbInstanceArns = builder.rdsDbInstanceArns;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> rdsDbInstanceArns() {
        return this.rdsDbInstanceArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstanceArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRdsDbInstancesRequest)) {
            return false;
        }
        DescribeRdsDbInstancesRequest other = (DescribeRdsDbInstancesRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.rdsDbInstanceArns(), other.rdsDbInstanceArns());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRdsDbInstancesRequest").add("StackId", (Object)this.stackId()).add("RdsDbInstanceArns", this.rdsDbInstanceArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "RdsDbInstanceArns": {
                return Optional.ofNullable(clazz.cast(this.rdsDbInstanceArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRdsDbInstancesRequest, T> g) {
        return obj -> g.apply((DescribeRdsDbInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private List<String> rdsDbInstanceArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRdsDbInstancesRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.rdsDbInstanceArns(model.rdsDbInstanceArns);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getRdsDbInstanceArns() {
            return this.rdsDbInstanceArns;
        }

        @Override
        public final Builder rdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstanceArns(String ... rdsDbInstanceArns) {
            this.rdsDbInstanceArns(Arrays.asList(rdsDbInstanceArns));
            return this;
        }

        public final void setRdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRdsDbInstancesRequest build() {
            return new DescribeRdsDbInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRdsDbInstancesRequest> {
        public Builder stackId(String var1);

        public Builder rdsDbInstanceArns(Collection<String> var1);

        public Builder rdsDbInstanceArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

