/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInstanceRequest extends OpsWorksRequest implements
        ToCopyableBuilder<UpdateInstanceRequest.Builder, UpdateInstanceRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateInstanceRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<List<String>> LAYER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateInstanceRequest::layerIds))
            .setter(setter(Builder::layerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateInstanceRequest::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> AUTO_SCALING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateInstanceRequest::autoScalingTypeAsString)).setter(setter(Builder::autoScalingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingType").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateInstanceRequest::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<String> OS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateInstanceRequest::os)).setter(setter(Builder::os))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Os").build()).build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateInstanceRequest::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()).build();

    private static final SdkField<String> SSH_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateInstanceRequest::sshKeyName)).setter(setter(Builder::sshKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKeyName").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateInstanceRequest::architectureAsString)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()).build();

    private static final SdkField<Boolean> INSTALL_UPDATES_ON_BOOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateInstanceRequest::installUpdatesOnBoot)).setter(setter(Builder::installUpdatesOnBoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallUpdatesOnBoot").build())
            .build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateInstanceRequest::ebsOptimized)).setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateInstanceRequest::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            LAYER_IDS_FIELD, INSTANCE_TYPE_FIELD, AUTO_SCALING_TYPE_FIELD, HOSTNAME_FIELD, OS_FIELD, AMI_ID_FIELD,
            SSH_KEY_NAME_FIELD, ARCHITECTURE_FIELD, INSTALL_UPDATES_ON_BOOT_FIELD, EBS_OPTIMIZED_FIELD, AGENT_VERSION_FIELD));

    private final String instanceId;

    private final List<String> layerIds;

    private final String instanceType;

    private final String autoScalingType;

    private final String hostname;

    private final String os;

    private final String amiId;

    private final String sshKeyName;

    private final String architecture;

    private final Boolean installUpdatesOnBoot;

    private final Boolean ebsOptimized;

    private final String agentVersion;

    private UpdateInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.layerIds = builder.layerIds;
        this.instanceType = builder.instanceType;
        this.autoScalingType = builder.autoScalingType;
        this.hostname = builder.hostname;
        this.os = builder.os;
        this.amiId = builder.amiId;
        this.sshKeyName = builder.sshKeyName;
        this.architecture = builder.architecture;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.ebsOptimized = builder.ebsOptimized;
        this.agentVersion = builder.agentVersion;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance's layer IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The instance's layer IDs.
     */
    public List<String> layerIds() {
        return layerIds;
    }

    /**
     * <p>
     * The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the
     * console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently
     * supported types. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.
     * The parameter values that you use to specify the various types are in the <b>API Name</b> column of the
     * <b>Available Instance Types</b> table.
     * </p>
     * 
     * @return The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack
     *         in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the
     *         currently supported types. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
     *         Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b>
     *         column of the <b>Available Instance Types</b> table.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingType}
     * will return {@link AutoScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingTypeAsString}.
     * </p>
     * 
     * @return For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * @see AutoScalingType
     */
    public AutoScalingType autoScalingType() {
        return AutoScalingType.fromValue(autoScalingType);
    }

    /**
     * <p>
     * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingType}
     * will return {@link AutoScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingTypeAsString}.
     * </p>
     * 
     * @return For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * @see AutoScalingType
     */
    public String autoScalingTypeAsString() {
        return autoScalingType;
    }

    /**
     * <p>
     * The instance host name.
     * </p>
     * 
     * @return The instance host name.
     */
    public String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The instance's operating system, which must be set to one of the following. You cannot update an instance that is
     * using a custom AMI.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>,
     * <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>,
     * <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
     * <code>Ubuntu 12.04 LTS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CentOS Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Red Hat Enterprise Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about supported operating systems, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks
     * Operating Systems</a>.
     * </p>
     * <p>
     * The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you
     * must use the AmiId parameter to specify the custom AMI that you want to use. For more information about supported
     * operating systems, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>. For
     * more information about how to use custom AMIs with OpsWorks, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
     * AMIs</a>.
     * </p>
     * <note>
     * <p>
     * You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to
     * Windows or Windows to Linux.
     * </p>
     * </note>
     * 
     * @return The instance's operating system, which must be set to one of the following. You cannot update an instance
     *         that is using a custom AMI.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>,
     *         <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>,
     *         <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
     *         <code>Amazon Linux 2015.03</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>
     *         , or <code>Ubuntu 12.04 LTS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CentOS Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Red Hat Enterprise Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about supported operating systems, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks
     *         Operating Systems</a>.
     *         </p>
     *         <p>
     *         The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>,
     *         you must use the AmiId parameter to specify the custom AMI that you want to use. For more information
     *         about supported operating systems, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating
     *         Systems</a>. For more information about how to use custom AMIs with OpsWorks, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using
     *         Custom AMIs</a>.
     *         </p>
     *         <note>
     *         <p>
     *         You can specify a different Linux operating system for the updated stack, but you cannot change from
     *         Linux to Windows or Windows to Linux.
     *         </p>
     */
    public String os() {
        return os;
    }

    /**
     * <p>
     * The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that
     * the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance.
     * UpdateInstance does not work on instances that are using custom AMIs.
     * </p>
     * 
     * @return The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI
     *         ID that the instance is already using. You cannot apply a new AMI to an instance by running
     *         UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs.
     */
    public String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The instance's Amazon EC2 key name.
     * </p>
     * 
     * @return The instance's Amazon EC2 key name.
     */
    public String sshKeyName() {
        return sshKeyName;
    }

    /**
     * <p>
     * The instance architecture. Instance types do not necessarily support both architectures. For a list of the
     * architectures that are supported by the different instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The instance architecture. Instance types do not necessarily support both architectures. For a list of
     *         the architectures that are supported by the different instance types, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
     *         Types</a>.
     * @see Architecture
     */
    public Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The instance architecture. Instance types do not necessarily support both architectures. For a list of the
     * architectures that are supported by the different instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The instance architecture. Instance types do not necessarily support both architectures. For a list of
     *         the architectures that are supported by the different instance types, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
     *         Types</a>.
     * @see Architecture
     */
    public String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
     * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack
     * command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest
     * security updates.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must
     *         then update your instances manually by using <a>CreateDeployment</a> to run the
     *         <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or
     *         <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
     *         <p>
     *         We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
     *         the latest security updates.
     *         </p>
     */
    public Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * This property cannot be updated.
     * </p>
     * 
     * @return This property cannot be updated.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The default AWS OpsWorks Stacks agent version. You have the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INHERIT</code> - Use the stack's default agent version setting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To
     * update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks Stacks
     * then automatically installs that version on the instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version
     * number, not the abbreviated number shown on the console. For a list of available agent version numbers, call
     * <a>DescribeAgentVersions</a>.
     * </p>
     * <p>
     * AgentVersion cannot be set to Chef 12.2.
     * </p>
     * 
     * @return The default AWS OpsWorks Stacks agent version. You have the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INHERIT</code> - Use the stack's default agent version setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>version_number</i> - Use the specified agent version. This value overrides the stack's default
     *         setting. To update the agent version, you must edit the instance configuration and specify a new version.
     *         AWS OpsWorks Stacks then automatically installs that version on the instance.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete
     *         version number, not the abbreviated number shown on the console. For a list of available agent version
     *         numbers, call <a>DescribeAgentVersions</a>.
     *         </p>
     *         <p>
     *         AgentVersion cannot be set to Chef 12.2.
     */
    public String agentVersion() {
        return agentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(layerIds());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(os());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(sshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceRequest)) {
            return false;
        }
        UpdateInstanceRequest other = (UpdateInstanceRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(layerIds(), other.layerIds())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(autoScalingTypeAsString(), other.autoScalingTypeAsString())
                && Objects.equals(hostname(), other.hostname()) && Objects.equals(os(), other.os())
                && Objects.equals(amiId(), other.amiId()) && Objects.equals(sshKeyName(), other.sshKeyName())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(installUpdatesOnBoot(), other.installUpdatesOnBoot())
                && Objects.equals(ebsOptimized(), other.ebsOptimized()) && Objects.equals(agentVersion(), other.agentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateInstanceRequest").add("InstanceId", instanceId()).add("LayerIds", layerIds())
                .add("InstanceType", instanceType()).add("AutoScalingType", autoScalingTypeAsString())
                .add("Hostname", hostname()).add("Os", os()).add("AmiId", amiId()).add("SshKeyName", sshKeyName())
                .add("Architecture", architectureAsString()).add("InstallUpdatesOnBoot", installUpdatesOnBoot())
                .add("EbsOptimized", ebsOptimized()).add("AgentVersion", agentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "LayerIds":
            return Optional.ofNullable(clazz.cast(layerIds()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "AutoScalingType":
            return Optional.ofNullable(clazz.cast(autoScalingTypeAsString()));
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "Os":
            return Optional.ofNullable(clazz.cast(os()));
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "SshKeyName":
            return Optional.ofNullable(clazz.cast(sshKeyName()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "InstallUpdatesOnBoot":
            return Optional.ofNullable(clazz.cast(installUpdatesOnBoot()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstanceRequest, T> g) {
        return obj -> g.apply((UpdateInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateInstanceRequest> {
        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance's layer IDs.
         * </p>
         * 
         * @param layerIds
         *        The instance's layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(Collection<String> layerIds);

        /**
         * <p>
         * The instance's layer IDs.
         * </p>
         * 
         * @param layerIds
         *        The instance's layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(String... layerIds);

        /**
         * <p>
         * The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in
         * the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the
         * currently supported types. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         * Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column
         * of the <b>Available Instance Types</b> table.
         * </p>
         * 
         * @param instanceType
         *        The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the
         *        stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list
         *        contains the currently supported types. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         *        Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b>
         *        column of the <b>Available Instance Types</b> table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * @see AutoScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(String autoScalingType);

        /**
         * <p>
         * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * @see AutoScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(AutoScalingType autoScalingType);

        /**
         * <p>
         * The instance host name.
         * </p>
         * 
         * @param hostname
         *        The instance host name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The instance's operating system, which must be set to one of the following. You cannot update an instance
         * that is using a custom AMI.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>,
         * <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>,
         * <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
         * <code>Ubuntu 12.04 LTS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CentOS Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Red Hat Enterprise Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about supported operating systems, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks
         * Operating Systems</a>.
         * </p>
         * <p>
         * The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you
         * must use the AmiId parameter to specify the custom AMI that you want to use. For more information about
         * supported operating systems, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>.
         * For more information about how to use custom AMIs with OpsWorks, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
         * AMIs</a>.
         * </p>
         * <note>
         * <p>
         * You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to
         * Windows or Windows to Linux.
         * </p>
         * </note>
         * 
         * @param os
         *        The instance's operating system, which must be set to one of the following. You cannot update an
         *        instance that is using a custom AMI.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>,
         *        <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>,
         *        <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>,
         *        <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CentOS Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Red Hat Enterprise Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about supported operating systems, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks
         *        Stacks Operating Systems</a>.
         *        </p>
         *        <p>
         *        The default option is the current Amazon Linux version. If you set this parameter to
         *        <code>Custom</code>, you must use the AmiId parameter to specify the custom AMI that you want to use.
         *        For more information about supported operating systems, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating
         *        Systems</a>. For more information about how to use custom AMIs with OpsWorks, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using
         *        Custom AMIs</a>.
         *        </p>
         *        <note>
         *        <p>
         *        You can specify a different Linux operating system for the updated stack, but you cannot change from
         *        Linux to Windows or Windows to Linux.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder os(String os);

        /**
         * <p>
         * The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID
         * that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance.
         * UpdateInstance does not work on instances that are using custom AMIs.
         * </p>
         * 
         * @param amiId
         *        The ID of the AMI that was used to create the instance. The value of this parameter must be the same
         *        AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running
         *        UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The instance's Amazon EC2 key name.
         * </p>
         * 
         * @param sshKeyName
         *        The instance's Amazon EC2 key name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKeyName(String sshKeyName);

        /**
         * <p>
         * The instance architecture. Instance types do not necessarily support both architectures. For a list of the
         * architectures that are supported by the different instance types, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         * Types</a>.
         * </p>
         * 
         * @param architecture
         *        The instance architecture. Instance types do not necessarily support both architectures. For a list of
         *        the architectures that are supported by the different instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         *        Types</a>.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The instance architecture. Instance types do not necessarily support both architectures. For a list of the
         * architectures that are supported by the different instance types, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         * Types</a>.
         * </p>
         * 
         * @param architecture
         *        The instance architecture. Instance types do not necessarily support both architectures. For a list of
         *        the architectures that are supported by the different instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         *        Types</a>.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
         * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code>
         * stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the
         * instances.
         * </p>
         * <note>
         * <p>
         * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the
         * latest security updates.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You
         *        must then update your instances manually by using <a>CreateDeployment</a> to run the
         *        <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux)
         *        or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
         *        <p>
         *        We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
         *        the latest security updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * This property cannot be updated.
         * </p>
         * 
         * @param ebsOptimized
         *        This property cannot be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The default AWS OpsWorks Stacks agent version. You have the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INHERIT</code> - Use the stack's default agent version setting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To
         * update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks
         * Stacks then automatically installs that version on the instance.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version
         * number, not the abbreviated number shown on the console. For a list of available agent version numbers, call
         * <a>DescribeAgentVersions</a>.
         * </p>
         * <p>
         * AgentVersion cannot be set to Chef 12.2.
         * </p>
         * 
         * @param agentVersion
         *        The default AWS OpsWorks Stacks agent version. You have the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INHERIT</code> - Use the stack's default agent version setting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>version_number</i> - Use the specified agent version. This value overrides the stack's default
         *        setting. To update the agent version, you must edit the instance configuration and specify a new
         *        version. AWS OpsWorks Stacks then automatically installs that version on the instance.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete
         *        version number, not the abbreviated number shown on the console. For a list of available agent version
         *        numbers, call <a>DescribeAgentVersions</a>.
         *        </p>
         *        <p>
         *        AgentVersion cannot be set to Chef 12.2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<String> layerIds = DefaultSdkAutoConstructList.getInstance();

        private String instanceType;

        private String autoScalingType;

        private String hostname;

        private String os;

        private String amiId;

        private String sshKeyName;

        private String architecture;

        private Boolean installUpdatesOnBoot;

        private Boolean ebsOptimized;

        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceRequest model) {
            super(model);
            instanceId(model.instanceId);
            layerIds(model.layerIds);
            instanceType(model.instanceType);
            autoScalingType(model.autoScalingType);
            hostname(model.hostname);
            os(model.os);
            amiId(model.amiId);
            sshKeyName(model.sshKeyName);
            architecture(model.architecture);
            installUpdatesOnBoot(model.installUpdatesOnBoot);
            ebsOptimized(model.ebsOptimized);
            agentVersion(model.agentVersion);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getLayerIds() {
            return layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String... layerIds) {
            layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getAutoScalingTypeAsString() {
            return autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType == null ? null : autoScalingType.toString());
            return this;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getOs() {
            return os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final String getAmiId() {
            return amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getSshKeyName() {
            return sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public final String getArchitectureAsString() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInstanceRequest build() {
            return new UpdateInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
