/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportServerEngineAttributeRequest
extends OpsWorksCmRequest
implements ToCopyableBuilder<Builder, ExportServerEngineAttributeRequest> {
    private static final SdkField<String> EXPORT_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportServerEngineAttributeRequest.getter(ExportServerEngineAttributeRequest::exportAttributeName)).setter(ExportServerEngineAttributeRequest.setter(Builder::exportAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAttributeName").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportServerEngineAttributeRequest.getter(ExportServerEngineAttributeRequest::serverName)).setter(ExportServerEngineAttributeRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<List<EngineAttribute>> INPUT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ExportServerEngineAttributeRequest.getter(ExportServerEngineAttributeRequest::inputAttributes)).setter(ExportServerEngineAttributeRequest.setter(Builder::inputAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngineAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ATTRIBUTE_NAME_FIELD, SERVER_NAME_FIELD, INPUT_ATTRIBUTES_FIELD));
    private final String exportAttributeName;
    private final String serverName;
    private final List<EngineAttribute> inputAttributes;

    private ExportServerEngineAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.exportAttributeName = builder.exportAttributeName;
        this.serverName = builder.serverName;
        this.inputAttributes = builder.inputAttributes;
    }

    public String exportAttributeName() {
        return this.exportAttributeName;
    }

    public String serverName() {
        return this.serverName;
    }

    public boolean hasInputAttributes() {
        return this.inputAttributes != null && !(this.inputAttributes instanceof SdkAutoConstructList);
    }

    public List<EngineAttribute> inputAttributes() {
        return this.inputAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportServerEngineAttributeRequest)) {
            return false;
        }
        ExportServerEngineAttributeRequest other = (ExportServerEngineAttributeRequest)((Object)obj);
        return Objects.equals(this.exportAttributeName(), other.exportAttributeName()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.inputAttributes(), other.inputAttributes());
    }

    public String toString() {
        return ToString.builder((String)"ExportServerEngineAttributeRequest").add("ExportAttributeName", (Object)this.exportAttributeName()).add("ServerName", (Object)this.serverName()).add("InputAttributes", this.inputAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportAttributeName": {
                return Optional.ofNullable(clazz.cast(this.exportAttributeName()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "InputAttributes": {
                return Optional.ofNullable(clazz.cast(this.inputAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportServerEngineAttributeRequest, T> g) {
        return obj -> g.apply((ExportServerEngineAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksCmRequest.BuilderImpl
    implements Builder {
        private String exportAttributeName;
        private String serverName;
        private List<EngineAttribute> inputAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportServerEngineAttributeRequest model) {
            super(model);
            this.exportAttributeName(model.exportAttributeName);
            this.serverName(model.serverName);
            this.inputAttributes(model.inputAttributes);
        }

        public final String getExportAttributeName() {
            return this.exportAttributeName;
        }

        @Override
        public final Builder exportAttributeName(String exportAttributeName) {
            this.exportAttributeName = exportAttributeName;
            return this;
        }

        public final void setExportAttributeName(String exportAttributeName) {
            this.exportAttributeName = exportAttributeName;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Collection<EngineAttribute.Builder> getInputAttributes() {
            return this.inputAttributes != null ? (Collection)this.inputAttributes.stream().map(EngineAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputAttributes(Collection<EngineAttribute> inputAttributes) {
            this.inputAttributes = EngineAttributesCopier.copy(inputAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttributes(EngineAttribute ... inputAttributes) {
            this.inputAttributes(Arrays.asList(inputAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttributes(Consumer<EngineAttribute.Builder> ... inputAttributes) {
            this.inputAttributes(Stream.of(inputAttributes).map(c -> (EngineAttribute)((EngineAttribute.Builder)EngineAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputAttributes(Collection<EngineAttribute.BuilderImpl> inputAttributes) {
            this.inputAttributes = EngineAttributesCopier.copyFromBuilder(inputAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportServerEngineAttributeRequest build() {
            return new ExportServerEngineAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksCmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportServerEngineAttributeRequest> {
        public Builder exportAttributeName(String var1);

        public Builder serverName(String var1);

        public Builder inputAttributes(Collection<EngineAttribute> var1);

        public Builder inputAttributes(EngineAttribute ... var1);

        public Builder inputAttributes(Consumer<EngineAttribute.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

