/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServersResponse extends OpsWorksCmResponse implements
        ToCopyableBuilder<DescribeServersResponse.Builder, DescribeServersResponse> {
    private static final SdkField<List<Server>> SERVERS_FIELD = SdkField
            .<List<Server>> builder(MarshallingType.LIST)
            .memberName("Servers")
            .getter(getter(DescribeServersResponse::servers))
            .setter(setter(Builder::servers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Servers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Server> builder(MarshallingType.SDK_POJO)
                                            .constructor(Server::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeServersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Server> servers;

    private final String nextToken;

    private DescribeServersResponse(BuilderImpl builder) {
        super(builder);
        this.servers = builder.servers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Servers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasServers() {
        return servers != null && !(servers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the response to a <code>DescribeServers</code> request.
     * </p>
     * <p>
     * <i>For Chef Automate servers:</i> If <code>DescribeServersResponse$Servers$EngineAttributes</code> includes
     * CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To be eligible for
     * upgrade, a server running Chef Automate 1 must have had at least one successful maintenance run after November 1,
     * 2019.
     * </p>
     * <p>
     * <i>For Puppet Server:</i> <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
     * PUPPET_API_CA_CERT. This is the PEM-encoded CA certificate that is used by the Puppet API over TCP port number
     * 8140. The CA certificate is also used to sign node certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains the response to a <code>DescribeServers</code> request.</p>
     *         <p>
     *         <i>For Chef Automate servers:</i> If <code>DescribeServersResponse$Servers$EngineAttributes</code>
     *         includes CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To be
     *         eligible for upgrade, a server running Chef Automate 1 must have had at least one successful maintenance
     *         run after November 1, 2019.
     *         </p>
     *         <p>
     *         <i>For Puppet Server:</i> <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
     *         PUPPET_API_CA_CERT. This is the PEM-encoded CA certificate that is used by the Puppet API over TCP port
     *         number 8140. The CA certificate is also used to sign node certificates.
     */
    public final List<Server> servers() {
        return servers;
    }

    /**
     * <p>
     * This is not currently implemented for <code>DescribeServers</code> requests.
     * </p>
     * 
     * @return This is not currently implemented for <code>DescribeServers</code> requests.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServers() ? servers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServersResponse)) {
            return false;
        }
        DescribeServersResponse other = (DescribeServersResponse) obj;
        return hasServers() == other.hasServers() && Objects.equals(servers(), other.servers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServersResponse").add("Servers", hasServers() ? servers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Servers":
            return Optional.ofNullable(clazz.cast(servers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServersResponse, T> g) {
        return obj -> g.apply((DescribeServersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServersResponse> {
        /**
         * <p>
         * Contains the response to a <code>DescribeServers</code> request.
         * </p>
         * <p>
         * <i>For Chef Automate servers:</i> If <code>DescribeServersResponse$Servers$EngineAttributes</code> includes
         * CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To be eligible for
         * upgrade, a server running Chef Automate 1 must have had at least one successful maintenance run after
         * November 1, 2019.
         * </p>
         * <p>
         * <i>For Puppet Server:</i> <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
         * PUPPET_API_CA_CERT. This is the PEM-encoded CA certificate that is used by the Puppet API over TCP port
         * number 8140. The CA certificate is also used to sign node certificates.
         * </p>
         * 
         * @param servers
         *        Contains the response to a <code>DescribeServers</code> request.</p>
         *        <p>
         *        <i>For Chef Automate servers:</i> If <code>DescribeServersResponse$Servers$EngineAttributes</code>
         *        includes CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To
         *        be eligible for upgrade, a server running Chef Automate 1 must have had at least one successful
         *        maintenance run after November 1, 2019.
         *        </p>
         *        <p>
         *        <i>For Puppet Server:</i> <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
         *        PUPPET_API_CA_CERT. This is the PEM-encoded CA certificate that is used by the Puppet API over TCP
         *        port number 8140. The CA certificate is also used to sign node certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servers(Collection<Server> servers);

        /**
         * <p>
         * Contains the response to a <code>DescribeServers</code> request.
         * </p>
         * <p>
         * <i>For Chef Automate servers:</i> If <code>DescribeServersResponse$Servers$EngineAttributes</code> includes
         * CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To be eligible for
         * upgrade, a server running Chef Automate 1 must have had at least one successful maintenance run after
         * November 1, 2019.
         * </p>
         * <p>
         * <i>For Puppet Server:</i> <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
         * PUPPET_API_CA_CERT. This is the PEM-encoded CA certificate that is used by the Puppet API over TCP port
         * number 8140. The CA certificate is also used to sign node certificates.
         * </p>
         * 
         * @param servers
         *        Contains the response to a <code>DescribeServers</code> request.</p>
         *        <p>
         *        <i>For Chef Automate servers:</i> If <code>DescribeServersResponse$Servers$EngineAttributes</code>
         *        includes CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To
         *        be eligible for upgrade, a server running Chef Automate 1 must have had at least one successful
         *        maintenance run after November 1, 2019.
         *        </p>
         *        <p>
         *        <i>For Puppet Server:</i> <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
         *        PUPPET_API_CA_CERT. This is the PEM-encoded CA certificate that is used by the Puppet API over TCP
         *        port number 8140. The CA certificate is also used to sign node certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servers(Server... servers);

        /**
         * <p>
         * Contains the response to a <code>DescribeServers</code> request.
         * </p>
         * <p>
         * <i>For Chef Automate servers:</i> If <code>DescribeServersResponse$Servers$EngineAttributes</code> includes
         * CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To be eligible for
         * upgrade, a server running Chef Automate 1 must have had at least one successful maintenance run after
         * November 1, 2019.
         * </p>
         * <p>
         * <i>For Puppet Server:</i> <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
         * PUPPET_API_CA_CERT. This is the PEM-encoded CA certificate that is used by the Puppet API over TCP port
         * number 8140. The CA certificate is also used to sign node certificates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Server>.Builder} avoiding the need to
         * create one manually via {@link List<Server>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Server>.Builder#build()} is called immediately and its
         * result is passed to {@link #servers(List<Server>)}.
         * 
         * @param servers
         *        a consumer that will call methods on {@link List<Server>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #servers(List<Server>)
         */
        Builder servers(Consumer<Server.Builder>... servers);

        /**
         * <p>
         * This is not currently implemented for <code>DescribeServers</code> requests.
         * </p>
         * 
         * @param nextToken
         *        This is not currently implemented for <code>DescribeServers</code> requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OpsWorksCmResponse.BuilderImpl implements Builder {
        private List<Server> servers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServersResponse model) {
            super(model);
            servers(model.servers);
            nextToken(model.nextToken);
        }

        public final List<Server.Builder> getServers() {
            List<Server.Builder> result = ServersCopier.copyToBuilder(this.servers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder servers(Collection<Server> servers) {
            this.servers = ServersCopier.copy(servers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(Server... servers) {
            servers(Arrays.asList(servers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(Consumer<Server.Builder>... servers) {
            servers(Stream.of(servers).map(c -> Server.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServers(Collection<Server.BuilderImpl> servers) {
            this.servers = ServersCopier.copyFromBuilder(servers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeServersResponse build() {
            return new DescribeServersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
