/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportServerEngineAttributeRequest extends OpsWorksCmRequest implements
        ToCopyableBuilder<ExportServerEngineAttributeRequest.Builder, ExportServerEngineAttributeRequest> {
    private static final SdkField<String> EXPORT_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportAttributeName").getter(getter(ExportServerEngineAttributeRequest::exportAttributeName))
            .setter(setter(Builder::exportAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAttributeName").build())
            .build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(ExportServerEngineAttributeRequest::serverName))
            .setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<List<EngineAttribute>> INPUT_ATTRIBUTES_FIELD = SdkField
            .<List<EngineAttribute>> builder(MarshallingType.LIST)
            .memberName("InputAttributes")
            .getter(getter(ExportServerEngineAttributeRequest::inputAttributes))
            .setter(setter(Builder::inputAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ATTRIBUTE_NAME_FIELD,
            SERVER_NAME_FIELD, INPUT_ATTRIBUTES_FIELD));

    private final String exportAttributeName;

    private final String serverName;

    private final List<EngineAttribute> inputAttributes;

    private ExportServerEngineAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.exportAttributeName = builder.exportAttributeName;
        this.serverName = builder.serverName;
        this.inputAttributes = builder.inputAttributes;
    }

    /**
     * <p>
     * The name of the export attribute. Currently, the supported export attribute is <code>Userdata</code>. This
     * exports a user data script that includes parameters and values provided in the <code>InputAttributes</code> list.
     * </p>
     * 
     * @return The name of the export attribute. Currently, the supported export attribute is <code>Userdata</code>.
     *         This exports a user data script that includes parameters and values provided in the
     *         <code>InputAttributes</code> list.
     */
    public final String exportAttributeName() {
        return exportAttributeName;
    }

    /**
     * <p>
     * The name of the server from which you are exporting the attribute.
     * </p>
     * 
     * @return The name of the server from which you are exporting the attribute.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * Returns true if the InputAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInputAttributes() {
        return inputAttributes != null && !(inputAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of engine attributes. The list type is <code>EngineAttribute</code>. An <code>EngineAttribute</code>
     * list item is a pair that includes an attribute name and its value. For the <code>Userdata</code>
     * ExportAttributeName, the following are supported engine attribute names.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>RunList</b> In Chef, a list of roles or recipes that are run in the specified order. In Puppet, this parameter
     * is ignored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OrganizationName</b> In Chef, an organization name. AWS OpsWorks for Chef Automate always creates the
     * organization <code>default</code>. In Puppet, this parameter is ignored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NodeEnvironment</b> In Chef, a node environment (for example, development, staging, or one-box). In Puppet,
     * this parameter is ignored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NodeClientVersion</b> In Chef, the version of the Chef engine (three numbers separated by dots, such as
     * 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version. In Puppet, this
     * parameter is ignored.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of engine attributes. The list type is <code>EngineAttribute</code>. An
     *         <code>EngineAttribute</code> list item is a pair that includes an attribute name and its value. For the
     *         <code>Userdata</code> ExportAttributeName, the following are supported engine attribute names.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>RunList</b> In Chef, a list of roles or recipes that are run in the specified order. In Puppet, this
     *         parameter is ignored.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>OrganizationName</b> In Chef, an organization name. AWS OpsWorks for Chef Automate always creates the
     *         organization <code>default</code>. In Puppet, this parameter is ignored.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NodeEnvironment</b> In Chef, a node environment (for example, development, staging, or one-box). In
     *         Puppet, this parameter is ignored.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NodeClientVersion</b> In Chef, the version of the Chef engine (three numbers separated by dots, such
     *         as 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version. In
     *         Puppet, this parameter is ignored.
     *         </p>
     *         </li>
     */
    public final List<EngineAttribute> inputAttributes() {
        return inputAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputAttributes() ? inputAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportServerEngineAttributeRequest)) {
            return false;
        }
        ExportServerEngineAttributeRequest other = (ExportServerEngineAttributeRequest) obj;
        return Objects.equals(exportAttributeName(), other.exportAttributeName())
                && Objects.equals(serverName(), other.serverName()) && hasInputAttributes() == other.hasInputAttributes()
                && Objects.equals(inputAttributes(), other.inputAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportServerEngineAttributeRequest").add("ExportAttributeName", exportAttributeName())
                .add("ServerName", serverName()).add("InputAttributes", hasInputAttributes() ? inputAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportAttributeName":
            return Optional.ofNullable(clazz.cast(exportAttributeName()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "InputAttributes":
            return Optional.ofNullable(clazz.cast(inputAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportServerEngineAttributeRequest, T> g) {
        return obj -> g.apply((ExportServerEngineAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportServerEngineAttributeRequest> {
        /**
         * <p>
         * The name of the export attribute. Currently, the supported export attribute is <code>Userdata</code>. This
         * exports a user data script that includes parameters and values provided in the <code>InputAttributes</code>
         * list.
         * </p>
         * 
         * @param exportAttributeName
         *        The name of the export attribute. Currently, the supported export attribute is <code>Userdata</code>.
         *        This exports a user data script that includes parameters and values provided in the
         *        <code>InputAttributes</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportAttributeName(String exportAttributeName);

        /**
         * <p>
         * The name of the server from which you are exporting the attribute.
         * </p>
         * 
         * @param serverName
         *        The name of the server from which you are exporting the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The list of engine attributes. The list type is <code>EngineAttribute</code>. An <code>EngineAttribute</code>
         * list item is a pair that includes an attribute name and its value. For the <code>Userdata</code>
         * ExportAttributeName, the following are supported engine attribute names.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>RunList</b> In Chef, a list of roles or recipes that are run in the specified order. In Puppet, this
         * parameter is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>OrganizationName</b> In Chef, an organization name. AWS OpsWorks for Chef Automate always creates the
         * organization <code>default</code>. In Puppet, this parameter is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NodeEnvironment</b> In Chef, a node environment (for example, development, staging, or one-box). In
         * Puppet, this parameter is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NodeClientVersion</b> In Chef, the version of the Chef engine (three numbers separated by dots, such as
         * 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version. In Puppet,
         * this parameter is ignored.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAttributes
         *        The list of engine attributes. The list type is <code>EngineAttribute</code>. An
         *        <code>EngineAttribute</code> list item is a pair that includes an attribute name and its value. For
         *        the <code>Userdata</code> ExportAttributeName, the following are supported engine attribute names.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>RunList</b> In Chef, a list of roles or recipes that are run in the specified order. In Puppet,
         *        this parameter is ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>OrganizationName</b> In Chef, an organization name. AWS OpsWorks for Chef Automate always creates
         *        the organization <code>default</code>. In Puppet, this parameter is ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NodeEnvironment</b> In Chef, a node environment (for example, development, staging, or one-box). In
         *        Puppet, this parameter is ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NodeClientVersion</b> In Chef, the version of the Chef engine (three numbers separated by dots,
         *        such as 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version.
         *        In Puppet, this parameter is ignored.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttributes(Collection<EngineAttribute> inputAttributes);

        /**
         * <p>
         * The list of engine attributes. The list type is <code>EngineAttribute</code>. An <code>EngineAttribute</code>
         * list item is a pair that includes an attribute name and its value. For the <code>Userdata</code>
         * ExportAttributeName, the following are supported engine attribute names.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>RunList</b> In Chef, a list of roles or recipes that are run in the specified order. In Puppet, this
         * parameter is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>OrganizationName</b> In Chef, an organization name. AWS OpsWorks for Chef Automate always creates the
         * organization <code>default</code>. In Puppet, this parameter is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NodeEnvironment</b> In Chef, a node environment (for example, development, staging, or one-box). In
         * Puppet, this parameter is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NodeClientVersion</b> In Chef, the version of the Chef engine (three numbers separated by dots, such as
         * 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version. In Puppet,
         * this parameter is ignored.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAttributes
         *        The list of engine attributes. The list type is <code>EngineAttribute</code>. An
         *        <code>EngineAttribute</code> list item is a pair that includes an attribute name and its value. For
         *        the <code>Userdata</code> ExportAttributeName, the following are supported engine attribute names.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>RunList</b> In Chef, a list of roles or recipes that are run in the specified order. In Puppet,
         *        this parameter is ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>OrganizationName</b> In Chef, an organization name. AWS OpsWorks for Chef Automate always creates
         *        the organization <code>default</code>. In Puppet, this parameter is ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NodeEnvironment</b> In Chef, a node environment (for example, development, staging, or one-box). In
         *        Puppet, this parameter is ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NodeClientVersion</b> In Chef, the version of the Chef engine (three numbers separated by dots,
         *        such as 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version.
         *        In Puppet, this parameter is ignored.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttributes(EngineAttribute... inputAttributes);

        /**
         * <p>
         * The list of engine attributes. The list type is <code>EngineAttribute</code>. An <code>EngineAttribute</code>
         * list item is a pair that includes an attribute name and its value. For the <code>Userdata</code>
         * ExportAttributeName, the following are supported engine attribute names.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>RunList</b> In Chef, a list of roles or recipes that are run in the specified order. In Puppet, this
         * parameter is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>OrganizationName</b> In Chef, an organization name. AWS OpsWorks for Chef Automate always creates the
         * organization <code>default</code>. In Puppet, this parameter is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NodeEnvironment</b> In Chef, a node environment (for example, development, staging, or one-box). In
         * Puppet, this parameter is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NodeClientVersion</b> In Chef, the version of the Chef engine (three numbers separated by dots, such as
         * 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version. In Puppet,
         * this parameter is ignored.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<EngineAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<EngineAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EngineAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #inputAttributes(List<EngineAttribute>)}.
         * 
         * @param inputAttributes
         *        a consumer that will call methods on {@link List<EngineAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputAttributes(List<EngineAttribute>)
         */
        Builder inputAttributes(Consumer<EngineAttribute.Builder>... inputAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksCmRequest.BuilderImpl implements Builder {
        private String exportAttributeName;

        private String serverName;

        private List<EngineAttribute> inputAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportServerEngineAttributeRequest model) {
            super(model);
            exportAttributeName(model.exportAttributeName);
            serverName(model.serverName);
            inputAttributes(model.inputAttributes);
        }

        public final String getExportAttributeName() {
            return exportAttributeName;
        }

        @Override
        public final Builder exportAttributeName(String exportAttributeName) {
            this.exportAttributeName = exportAttributeName;
            return this;
        }

        public final void setExportAttributeName(String exportAttributeName) {
            this.exportAttributeName = exportAttributeName;
        }

        public final String getServerName() {
            return serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final List<EngineAttribute.Builder> getInputAttributes() {
            List<EngineAttribute.Builder> result = EngineAttributesCopier.copyToBuilder(this.inputAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inputAttributes(Collection<EngineAttribute> inputAttributes) {
            this.inputAttributes = EngineAttributesCopier.copy(inputAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttributes(EngineAttribute... inputAttributes) {
            inputAttributes(Arrays.asList(inputAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttributes(Consumer<EngineAttribute.Builder>... inputAttributes) {
            inputAttributes(Stream.of(inputAttributes).map(c -> EngineAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputAttributes(Collection<EngineAttribute.BuilderImpl> inputAttributes) {
            this.inputAttributes = EngineAttributesCopier.copyFromBuilder(inputAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportServerEngineAttributeRequest build() {
            return new ExportServerEngineAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
