/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores account attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountAttribute.Builder, AccountAttribute> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AccountAttribute::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> MAXIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Maximum").getter(getter(AccountAttribute::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final SdkField<Integer> USED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Used")
            .getter(getter(AccountAttribute::used)).setter(setter(Builder::used))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Used").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAXIMUM_FIELD,
            USED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer maximum;

    private final Integer used;

    private AccountAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.maximum = builder.maximum;
        this.used = builder.used;
    }

    /**
     * <p>
     * The attribute name. The following are supported attribute names.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>ServerLimit:</i> The number of current servers/maximum number of servers allowed. By default, you can have a
     * maximum of 10 servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>ManualBackupLimit:</i> The number of current manual backups/maximum number of backups allowed. By default, you
     * can have a maximum of 50 manual backups saved.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The attribute name. The following are supported attribute names. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>ServerLimit:</i> The number of current servers/maximum number of servers allowed. By default, you can
     *         have a maximum of 10 servers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>ManualBackupLimit:</i> The number of current manual backups/maximum number of backups allowed. By
     *         default, you can have a maximum of 50 manual backups saved.
     *         </p>
     *         </li>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The maximum allowed value.
     * </p>
     * 
     * @return The maximum allowed value.
     */
    public final Integer maximum() {
        return maximum;
    }

    /**
     * <p>
     * The current usage, such as the current number of servers that are associated with the account.
     * </p>
     * 
     * @return The current usage, such as the current number of servers that are associated with the account.
     */
    public final Integer used() {
        return used;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(used());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttribute)) {
            return false;
        }
        AccountAttribute other = (AccountAttribute) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(maximum(), other.maximum())
                && Objects.equals(used(), other.used());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountAttribute").add("Name", name()).add("Maximum", maximum()).add("Used", used()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "Used":
            return Optional.ofNullable(clazz.cast(used()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountAttribute, T> g) {
        return obj -> g.apply((AccountAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountAttribute> {
        /**
         * <p>
         * The attribute name. The following are supported attribute names.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>ServerLimit:</i> The number of current servers/maximum number of servers allowed. By default, you can have
         * a maximum of 10 servers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>ManualBackupLimit:</i> The number of current manual backups/maximum number of backups allowed. By default,
         * you can have a maximum of 50 manual backups saved.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The attribute name. The following are supported attribute names. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>ServerLimit:</i> The number of current servers/maximum number of servers allowed. By default, you
         *        can have a maximum of 10 servers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>ManualBackupLimit:</i> The number of current manual backups/maximum number of backups allowed. By
         *        default, you can have a maximum of 50 manual backups saved.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The maximum allowed value.
         * </p>
         * 
         * @param maximum
         *        The maximum allowed value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Integer maximum);

        /**
         * <p>
         * The current usage, such as the current number of servers that are associated with the account.
         * </p>
         * 
         * @param used
         *        The current usage, such as the current number of servers that are associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder used(Integer used);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer maximum;

        private Integer used;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAttribute model) {
            name(model.name);
            maximum(model.maximum);
            used(model.used);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getMaximum() {
            return maximum;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        @Override
        @Transient
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Integer getUsed() {
            return used;
        }

        public final void setUsed(Integer used) {
            this.used = used;
        }

        @Override
        @Transient
        public final Builder used(Integer used) {
            this.used = used;
            return this;
        }

        @Override
        public AccountAttribute build() {
            return new AccountAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
