/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServerResponse extends OpsWorksCmResponse implements
        ToCopyableBuilder<CreateServerResponse.Builder, CreateServerResponse> {
    private static final SdkField<Server> SERVER_FIELD = SdkField.<Server> builder(MarshallingType.SDK_POJO).memberName("Server")
            .getter(getter(CreateServerResponse::server)).setter(setter(Builder::server)).constructor(Server::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Server").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_FIELD));

    private final Server server;

    private CreateServerResponse(BuilderImpl builder) {
        super(builder);
        this.server = builder.server;
    }

    /**
     * <p>
     * The server that is created by the request.
     * </p>
     * 
     * @return The server that is created by the request.
     */
    public final Server server() {
        return server;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(server());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerResponse)) {
            return false;
        }
        CreateServerResponse other = (CreateServerResponse) obj;
        return Objects.equals(server(), other.server());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServerResponse").add("Server", server()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Server":
            return Optional.ofNullable(clazz.cast(server()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServerResponse, T> g) {
        return obj -> g.apply((CreateServerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateServerResponse> {
        /**
         * <p>
         * The server that is created by the request.
         * </p>
         * 
         * @param server
         *        The server that is created by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder server(Server server);

        /**
         * <p>
         * The server that is created by the request.
         * </p>
         * This is a convenience that creates an instance of the {@link Server.Builder} avoiding the need to create one
         * manually via {@link Server#builder()}.
         *
         * When the {@link Consumer} completes, {@link Server.Builder#build()} is called immediately and its result is
         * passed to {@link #server(Server)}.
         * 
         * @param server
         *        a consumer that will call methods on {@link Server.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #server(Server)
         */
        default Builder server(Consumer<Server.Builder> server) {
            return server(Server.builder().applyMutation(server).build());
        }
    }

    static final class BuilderImpl extends OpsWorksCmResponse.BuilderImpl implements Builder {
        private Server server;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerResponse model) {
            super(model);
            server(model.server);
        }

        public final Server.Builder getServer() {
            return server != null ? server.toBuilder() : null;
        }

        public final void setServer(Server.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        @Transient
        public final Builder server(Server server) {
            this.server = server;
            return this;
        }

        @Override
        public CreateServerResponse build() {
            return new CreateServerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
