/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportServerEngineAttributeResponse extends OpsWorksCmResponse implements
        ToCopyableBuilder<ExportServerEngineAttributeResponse.Builder, ExportServerEngineAttributeResponse> {
    private static final SdkField<EngineAttribute> ENGINE_ATTRIBUTE_FIELD = SdkField
            .<EngineAttribute> builder(MarshallingType.SDK_POJO).memberName("EngineAttribute")
            .getter(getter(ExportServerEngineAttributeResponse::engineAttribute)).setter(setter(Builder::engineAttribute))
            .constructor(EngineAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttribute").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(ExportServerEngineAttributeResponse::serverName))
            .setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_ATTRIBUTE_FIELD,
            SERVER_NAME_FIELD));

    private final EngineAttribute engineAttribute;

    private final String serverName;

    private ExportServerEngineAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.engineAttribute = builder.engineAttribute;
        this.serverName = builder.serverName;
    }

    /**
     * <p>
     * The requested engine attribute pair with attribute name and value.
     * </p>
     * 
     * @return The requested engine attribute pair with attribute name and value.
     */
    public final EngineAttribute engineAttribute() {
        return engineAttribute;
    }

    /**
     * <p>
     * The server name used in the request.
     * </p>
     * 
     * @return The server name used in the request.
     */
    public final String serverName() {
        return serverName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engineAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportServerEngineAttributeResponse)) {
            return false;
        }
        ExportServerEngineAttributeResponse other = (ExportServerEngineAttributeResponse) obj;
        return Objects.equals(engineAttribute(), other.engineAttribute()) && Objects.equals(serverName(), other.serverName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportServerEngineAttributeResponse").add("EngineAttribute", engineAttribute())
                .add("ServerName", serverName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineAttribute":
            return Optional.ofNullable(clazz.cast(engineAttribute()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportServerEngineAttributeResponse, T> g) {
        return obj -> g.apply((ExportServerEngineAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportServerEngineAttributeResponse> {
        /**
         * <p>
         * The requested engine attribute pair with attribute name and value.
         * </p>
         * 
         * @param engineAttribute
         *        The requested engine attribute pair with attribute name and value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttribute(EngineAttribute engineAttribute);

        /**
         * <p>
         * The requested engine attribute pair with attribute name and value.
         * </p>
         * This is a convenience that creates an instance of the {@link EngineAttribute.Builder} avoiding the need to
         * create one manually via {@link EngineAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link EngineAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #engineAttribute(EngineAttribute)}.
         * 
         * @param engineAttribute
         *        a consumer that will call methods on {@link EngineAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineAttribute(EngineAttribute)
         */
        default Builder engineAttribute(Consumer<EngineAttribute.Builder> engineAttribute) {
            return engineAttribute(EngineAttribute.builder().applyMutation(engineAttribute).build());
        }

        /**
         * <p>
         * The server name used in the request.
         * </p>
         * 
         * @param serverName
         *        The server name used in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);
    }

    static final class BuilderImpl extends OpsWorksCmResponse.BuilderImpl implements Builder {
        private EngineAttribute engineAttribute;

        private String serverName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportServerEngineAttributeResponse model) {
            super(model);
            engineAttribute(model.engineAttribute);
            serverName(model.serverName);
        }

        public final EngineAttribute.Builder getEngineAttribute() {
            return engineAttribute != null ? engineAttribute.toBuilder() : null;
        }

        public final void setEngineAttribute(EngineAttribute.BuilderImpl engineAttribute) {
            this.engineAttribute = engineAttribute != null ? engineAttribute.build() : null;
        }

        @Override
        @Transient
        public final Builder engineAttribute(EngineAttribute engineAttribute) {
            this.engineAttribute = engineAttribute;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        @Transient
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        @Override
        public ExportServerEngineAttributeResponse build() {
            return new ExportServerEngineAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
