/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opsworkscm.DefaultOpsWorksCmAsyncClient;
import software.amazon.awssdk.services.opsworkscm.DefaultOpsWorksCmBaseClientBuilder;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmAsyncClient;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmAsyncClientBuilder;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmServiceClientConfiguration;
import software.amazon.awssdk.services.opsworkscm.endpoints.OpsWorksCmEndpointProvider;

@SdkInternalApi
final class DefaultOpsWorksCmAsyncClientBuilder
extends DefaultOpsWorksCmBaseClientBuilder<OpsWorksCmAsyncClientBuilder, OpsWorksCmAsyncClient>
implements OpsWorksCmAsyncClientBuilder {
    DefaultOpsWorksCmAsyncClientBuilder() {
    }

    @Override
    public DefaultOpsWorksCmAsyncClientBuilder endpointProvider(OpsWorksCmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OpsWorksCmAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultOpsWorksCmAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        OpsWorksCmServiceClientConfiguration serviceClientConfiguration = OpsWorksCmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultOpsWorksCmAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

