/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateNodeResponse extends OpsWorksCmResponse implements
        ToCopyableBuilder<AssociateNodeResponse.Builder, AssociateNodeResponse> {
    private static final SdkField<String> NODE_ASSOCIATION_STATUS_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NodeAssociationStatusToken")
            .getter(getter(AssociateNodeResponse::nodeAssociationStatusToken))
            .setter(setter(Builder::nodeAssociationStatusToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeAssociationStatusToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NODE_ASSOCIATION_STATUS_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nodeAssociationStatusToken;

    private AssociateNodeResponse(BuilderImpl builder) {
        super(builder);
        this.nodeAssociationStatusToken = builder.nodeAssociationStatusToken;
    }

    /**
     * <p>
     * Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get the status
     * of the association request.
     * </p>
     * 
     * @return Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get
     *         the status of the association request.
     */
    public final String nodeAssociationStatusToken() {
        return nodeAssociationStatusToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nodeAssociationStatusToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateNodeResponse)) {
            return false;
        }
        AssociateNodeResponse other = (AssociateNodeResponse) obj;
        return Objects.equals(nodeAssociationStatusToken(), other.nodeAssociationStatusToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateNodeResponse").add("NodeAssociationStatusToken", nodeAssociationStatusToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeAssociationStatusToken":
            return Optional.ofNullable(clazz.cast(nodeAssociationStatusToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NodeAssociationStatusToken", NODE_ASSOCIATION_STATUS_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateNodeResponse, T> g) {
        return obj -> g.apply((AssociateNodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssociateNodeResponse> {
        /**
         * <p>
         * Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get the
         * status of the association request.
         * </p>
         * 
         * @param nodeAssociationStatusToken
         *        Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get
         *        the status of the association request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeAssociationStatusToken(String nodeAssociationStatusToken);
    }

    static final class BuilderImpl extends OpsWorksCmResponse.BuilderImpl implements Builder {
        private String nodeAssociationStatusToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateNodeResponse model) {
            super(model);
            nodeAssociationStatusToken(model.nodeAssociationStatusToken);
        }

        public final String getNodeAssociationStatusToken() {
            return nodeAssociationStatusToken;
        }

        public final void setNodeAssociationStatusToken(String nodeAssociationStatusToken) {
            this.nodeAssociationStatusToken = nodeAssociationStatusToken;
        }

        @Override
        public final Builder nodeAssociationStatusToken(String nodeAssociationStatusToken) {
            this.nodeAssociationStatusToken = nodeAssociationStatusToken;
            return this;
        }

        @Override
        public AssociateNodeResponse build() {
            return new AssociateNodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
