/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateNodeRequest extends OpsWorksCmRequest implements
        ToCopyableBuilder<DisassociateNodeRequest.Builder, DisassociateNodeRequest> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(DisassociateNodeRequest::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeName").getter(getter(DisassociateNodeRequest::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeName").build()).build();

    private static final SdkField<List<EngineAttribute>> ENGINE_ATTRIBUTES_FIELD = SdkField
            .<List<EngineAttribute>> builder(MarshallingType.LIST)
            .memberName("EngineAttributes")
            .getter(getter(DisassociateNodeRequest::engineAttributes))
            .setter(setter(Builder::engineAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD,
            NODE_NAME_FIELD, ENGINE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serverName;

    private final String nodeName;

    private final List<EngineAttribute> engineAttributes;

    private DisassociateNodeRequest(BuilderImpl builder) {
        super(builder);
        this.serverName = builder.serverName;
        this.nodeName = builder.nodeName;
        this.engineAttributes = builder.engineAttributes;
    }

    /**
     * <p>
     * The name of the server from which to disassociate the node.
     * </p>
     * 
     * @return The name of the server from which to disassociate the node.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The name of the client node.
     * </p>
     * 
     * @return The name of the client node.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngineAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngineAttributes() {
        return engineAttributes != null && !(engineAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Engine attributes that are used for disassociating the node. No attributes are required for Puppet.
     * </p>
     * <p class="title">
     * <b>Attributes required in a DisassociateNode request for Chef</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHEF_ORGANIZATION</code>: The Chef organization with which the node was associated. By default only one
     * organization named <code>default</code> can exist.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngineAttributes} method.
     * </p>
     * 
     * @return Engine attributes that are used for disassociating the node. No attributes are required for Puppet. </p>
     *         <p class="title">
     *         <b>Attributes required in a DisassociateNode request for Chef</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CHEF_ORGANIZATION</code>: The Chef organization with which the node was associated. By default only
     *         one organization named <code>default</code> can exist.
     *         </p>
     *         </li>
     */
    public final List<EngineAttribute> engineAttributes() {
        return engineAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEngineAttributes() ? engineAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateNodeRequest)) {
            return false;
        }
        DisassociateNodeRequest other = (DisassociateNodeRequest) obj;
        return Objects.equals(serverName(), other.serverName()) && Objects.equals(nodeName(), other.nodeName())
                && hasEngineAttributes() == other.hasEngineAttributes()
                && Objects.equals(engineAttributes(), other.engineAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateNodeRequest").add("ServerName", serverName()).add("NodeName", nodeName())
                .add("EngineAttributes", hasEngineAttributes() ? engineAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "NodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "EngineAttributes":
            return Optional.ofNullable(clazz.cast(engineAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("NodeName", NODE_NAME_FIELD);
        map.put("EngineAttributes", ENGINE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateNodeRequest, T> g) {
        return obj -> g.apply((DisassociateNodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateNodeRequest> {
        /**
         * <p>
         * The name of the server from which to disassociate the node.
         * </p>
         * 
         * @param serverName
         *        The name of the server from which to disassociate the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The name of the client node.
         * </p>
         * 
         * @param nodeName
         *        The name of the client node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * Engine attributes that are used for disassociating the node. No attributes are required for Puppet.
         * </p>
         * <p class="title">
         * <b>Attributes required in a DisassociateNode request for Chef</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_ORGANIZATION</code>: The Chef organization with which the node was associated. By default only one
         * organization named <code>default</code> can exist.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineAttributes
         *        Engine attributes that are used for disassociating the node. No attributes are required for Puppet.
         *        </p>
         *        <p class="title">
         *        <b>Attributes required in a DisassociateNode request for Chef</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHEF_ORGANIZATION</code>: The Chef organization with which the node was associated. By default
         *        only one organization named <code>default</code> can exist.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(Collection<EngineAttribute> engineAttributes);

        /**
         * <p>
         * Engine attributes that are used for disassociating the node. No attributes are required for Puppet.
         * </p>
         * <p class="title">
         * <b>Attributes required in a DisassociateNode request for Chef</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_ORGANIZATION</code>: The Chef organization with which the node was associated. By default only one
         * organization named <code>default</code> can exist.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineAttributes
         *        Engine attributes that are used for disassociating the node. No attributes are required for Puppet.
         *        </p>
         *        <p class="title">
         *        <b>Attributes required in a DisassociateNode request for Chef</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHEF_ORGANIZATION</code>: The Chef organization with which the node was associated. By default
         *        only one organization named <code>default</code> can exist.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(EngineAttribute... engineAttributes);

        /**
         * <p>
         * Engine attributes that are used for disassociating the node. No attributes are required for Puppet.
         * </p>
         * <p class="title">
         * <b>Attributes required in a DisassociateNode request for Chef</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_ORGANIZATION</code>: The Chef organization with which the node was associated. By default only one
         * organization named <code>default</code> can exist.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #engineAttributes(List<EngineAttribute>)}.
         * 
         * @param engineAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineAttributes(java.util.Collection<EngineAttribute>)
         */
        Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksCmRequest.BuilderImpl implements Builder {
        private String serverName;

        private String nodeName;

        private List<EngineAttribute> engineAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateNodeRequest model) {
            super(model);
            serverName(model.serverName);
            nodeName(model.nodeName);
            engineAttributes(model.engineAttributes);
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final List<EngineAttribute.Builder> getEngineAttributes() {
            List<EngineAttribute.Builder> result = EngineAttributesCopier.copyToBuilder(this.engineAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute... engineAttributes) {
            engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes) {
            engineAttributes(Stream.of(engineAttributes).map(c -> EngineAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateNodeRequest build() {
            return new DisassociateNodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
