/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreServerRequest extends OpsWorksCmRequest implements
        ToCopyableBuilder<RestoreServerRequest.Builder, RestoreServerRequest> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupId").getter(getter(RestoreServerRequest::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(RestoreServerRequest::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(RestoreServerRequest::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyPair").getter(getter(RestoreServerRequest::keyPair)).setter(setter(Builder::keyPair))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPair").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD,
            SERVER_NAME_FIELD, INSTANCE_TYPE_FIELD, KEY_PAIR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupId;

    private final String serverName;

    private final String instanceType;

    private final String keyPair;

    private RestoreServerRequest(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.serverName = builder.serverName;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
    }

    /**
     * <p>
     * The ID of the backup that you want to use to restore a server.
     * </p>
     * 
     * @return The ID of the backup that you want to use to restore a server.
     */
    public final String backupId() {
        return backupId;
    }

    /**
     * <p>
     * The name of the server that you want to restore.
     * </p>
     * 
     * @return The name of the server that you want to restore.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The type of instance to restore. Valid values must be specified in the following format:
     * <code>^([cm][34]|t2).*</code> For example, <code>m5.large</code>. Valid values are <code>m5.large</code>,
     * <code>r5.xlarge</code>, and <code>r5.2xlarge</code>. If you do not specify this parameter, RestoreServer uses the
     * instance type from the specified backup.
     * </p>
     * 
     * @return The type of instance to restore. Valid values must be specified in the following format:
     *         <code>^([cm][34]|t2).*</code> For example, <code>m5.large</code>. Valid values are <code>m5.large</code>,
     *         <code>r5.xlarge</code>, and <code>r5.2xlarge</code>. If you do not specify this parameter, RestoreServer
     *         uses the instance type from the specified backup.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The name of the key pair to set on the new EC2 instance. This can be helpful if the administrator no longer has
     * the SSH key.
     * </p>
     * 
     * @return The name of the key pair to set on the new EC2 instance. This can be helpful if the administrator no
     *         longer has the SSH key.
     */
    public final String keyPair() {
        return keyPair;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreServerRequest)) {
            return false;
        }
        RestoreServerRequest other = (RestoreServerRequest) obj;
        return Objects.equals(backupId(), other.backupId()) && Objects.equals(serverName(), other.serverName())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(keyPair(), other.keyPair());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreServerRequest").add("BackupId", backupId()).add("ServerName", serverName())
                .add("InstanceType", instanceType()).add("KeyPair", keyPair()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KeyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupId", BACKUP_ID_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("KeyPair", KEY_PAIR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreServerRequest, T> g) {
        return obj -> g.apply((RestoreServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreServerRequest> {
        /**
         * <p>
         * The ID of the backup that you want to use to restore a server.
         * </p>
         * 
         * @param backupId
         *        The ID of the backup that you want to use to restore a server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        /**
         * <p>
         * The name of the server that you want to restore.
         * </p>
         * 
         * @param serverName
         *        The name of the server that you want to restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The type of instance to restore. Valid values must be specified in the following format:
         * <code>^([cm][34]|t2).*</code> For example, <code>m5.large</code>. Valid values are <code>m5.large</code>,
         * <code>r5.xlarge</code>, and <code>r5.2xlarge</code>. If you do not specify this parameter, RestoreServer uses
         * the instance type from the specified backup.
         * </p>
         * 
         * @param instanceType
         *        The type of instance to restore. Valid values must be specified in the following format:
         *        <code>^([cm][34]|t2).*</code> For example, <code>m5.large</code>. Valid values are
         *        <code>m5.large</code>, <code>r5.xlarge</code>, and <code>r5.2xlarge</code>. If you do not specify this
         *        parameter, RestoreServer uses the instance type from the specified backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The name of the key pair to set on the new EC2 instance. This can be helpful if the administrator no longer
         * has the SSH key.
         * </p>
         * 
         * @param keyPair
         *        The name of the key pair to set on the new EC2 instance. This can be helpful if the administrator no
         *        longer has the SSH key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(String keyPair);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksCmRequest.BuilderImpl implements Builder {
        private String backupId;

        private String serverName;

        private String instanceType;

        private String keyPair;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreServerRequest model) {
            super(model);
            backupId(model.backupId);
            serverName(model.serverName);
            instanceType(model.instanceType);
            keyPair(model.keyPair);
        }

        public final String getBackupId() {
            return backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKeyPair() {
            return keyPair;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreServerRequest build() {
            return new RestoreServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
