/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a configuration management server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Server implements SdkPojo, Serializable, ToCopyableBuilder<Server.Builder, Server> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress")
            .getter(getter(Server::associatePublicIpAddress)).setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionCount").getter(getter(Server::backupRetentionCount))
            .setter(setter(Builder::backupRetentionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionCount").build())
            .build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(Server::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Server::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> CLOUD_FORMATION_STACK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudFormationStackArn").getter(getter(Server::cloudFormationStackArn))
            .setter(setter(Builder::cloudFormationStackArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormationStackArn").build())
            .build();

    private static final SdkField<String> CUSTOM_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomDomain").getter(getter(Server::customDomain)).setter(setter(Builder::customDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomain").build()).build();

    private static final SdkField<Boolean> DISABLE_AUTOMATED_BACKUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableAutomatedBackup").getter(getter(Server::disableAutomatedBackup))
            .setter(setter(Builder::disableAutomatedBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableAutomatedBackup").build())
            .build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(Server::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(Server::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineModel").getter(getter(Server::engineModel)).setter(setter(Builder::engineModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineModel").build()).build();

    private static final SdkField<List<EngineAttribute>> ENGINE_ATTRIBUTES_FIELD = SdkField
            .<List<EngineAttribute>> builder(MarshallingType.LIST)
            .memberName("EngineAttributes")
            .getter(getter(Server::engineAttributes))
            .setter(setter(Builder::engineAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(Server::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProfileArn").getter(getter(Server::instanceProfileArn))
            .setter(setter(Builder::instanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileArn").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(Server::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyPair").getter(getter(Server::keyPair)).setter(setter(Builder::keyPair))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPair").build()).build();

    private static final SdkField<String> MAINTENANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceStatus").getter(getter(Server::maintenanceStatusAsString))
            .setter(setter(Builder::maintenanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceStatus").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(Server::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(Server::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(Server::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRoleArn").getter(getter(Server::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Server::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(Server::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(Server::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerArn").getter(getter(Server::serverArn)).setter(setter(Builder::serverArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, BACKUP_RETENTION_COUNT_FIELD, SERVER_NAME_FIELD, CREATED_AT_FIELD,
            CLOUD_FORMATION_STACK_ARN_FIELD, CUSTOM_DOMAIN_FIELD, DISABLE_AUTOMATED_BACKUP_FIELD, ENDPOINT_FIELD, ENGINE_FIELD,
            ENGINE_MODEL_FIELD, ENGINE_ATTRIBUTES_FIELD, ENGINE_VERSION_FIELD, INSTANCE_PROFILE_ARN_FIELD, INSTANCE_TYPE_FIELD,
            KEY_PAIR_FIELD, MAINTENANCE_STATUS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PREFERRED_BACKUP_WINDOW_FIELD,
            SECURITY_GROUP_IDS_FIELD, SERVICE_ROLE_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, SUBNET_IDS_FIELD,
            SERVER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean associatePublicIpAddress;

    private final Integer backupRetentionCount;

    private final String serverName;

    private final Instant createdAt;

    private final String cloudFormationStackArn;

    private final String customDomain;

    private final Boolean disableAutomatedBackup;

    private final String endpoint;

    private final String engine;

    private final String engineModel;

    private final List<EngineAttribute> engineAttributes;

    private final String engineVersion;

    private final String instanceProfileArn;

    private final String instanceType;

    private final String keyPair;

    private final String maintenanceStatus;

    private final String preferredMaintenanceWindow;

    private final String preferredBackupWindow;

    private final List<String> securityGroupIds;

    private final String serviceRoleArn;

    private final String status;

    private final String statusReason;

    private final List<String> subnetIds;

    private final String serverArn;

    private Server(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.createdAt = builder.createdAt;
        this.cloudFormationStackArn = builder.cloudFormationStackArn;
        this.customDomain = builder.customDomain;
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.endpoint = builder.endpoint;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineAttributes = builder.engineAttributes;
        this.engineVersion = builder.engineVersion;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.maintenanceStatus = builder.maintenanceStatus;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.subnetIds = builder.subnetIds;
        this.serverArn = builder.serverArn;
    }

    /**
     * <p>
     * Associate a public IP address with a server that you are launching.
     * </p>
     * 
     * @return Associate a public IP address with a server that you are launching.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * The number of automated backups to keep.
     * </p>
     * 
     * @return The number of automated backups to keep.
     */
    public final Integer backupRetentionCount() {
        return backupRetentionCount;
    }

    /**
     * <p>
     * The name of the server.
     * </p>
     * 
     * @return The name of the server.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
     * </p>
     * 
     * @return Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ARN of the CloudFormation stack that was used to create the server.
     * </p>
     * 
     * @return The ARN of the CloudFormation stack that was used to create the server.
     */
    public final String cloudFormationStackArn() {
        return cloudFormationStackArn;
    }

    /**
     * <p>
     * An optional public endpoint of a server, such as <code>https://aws.my-company.com</code>. You cannot access the
     * server by using the <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.
     * </p>
     * 
     * @return An optional public endpoint of a server, such as <code>https://aws.my-company.com</code>. You cannot
     *         access the server by using the <code>Endpoint</code> value if the server has a <code>CustomDomain</code>
     *         specified.
     */
    public final String customDomain() {
        return customDomain;
    }

    /**
     * <p>
     * Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
     * </p>
     * 
     * @return Disables automated backups. The number of stored backups is dependent on the value of
     *         PreferredBackupCount.
     */
    public final Boolean disableAutomatedBackup() {
        return disableAutomatedBackup;
    }

    /**
     * <p>
     * A DNS name that can be used to access the engine. Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>.
     * You cannot access the server by using the <code>Endpoint</code> value if the server has a
     * <code>CustomDomain</code> specified.
     * </p>
     * 
     * @return A DNS name that can be used to access the engine. Example:
     *         <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>. You cannot access the server by using the
     *         <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
     * <code>Puppet</code>.
     * </p>
     * 
     * @return The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
     *         <code>Puppet</code>.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and
     * <code>Single</code> for Chef.
     * </p>
     * 
     * @return The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet
     *         and <code>Single</code> for Chef.
     */
    public final String engineModel() {
        return engineModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngineAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngineAttributes() {
        return engineAttributes != null && !(engineAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The response of a createServer() request returns the master credential to access the server in EngineAttributes.
     * These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of
     * createServer().
     * </p>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Chef</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks for
     * Chef Automate. This private key is required to access the Chef API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     * includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then
     * change to the directory where you've unzipped the file contents. From this directory, you can run Knife commands.
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Puppet</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit, including
     * a README and a required private key. Save this file, unzip it, and then change to the directory where you've
     * unzipped the file contents.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     * Enterprise console after the server is online.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngineAttributes} method.
     * </p>
     * 
     * @return The response of a createServer() request returns the master credential to access the server in
     *         EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of
     *         the result of createServer(). </p>
     *         <p class="title">
     *         <b>Attributes returned in a createServer response for Chef</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS
     *         OpsWorks for Chef Automate. This private key is required to access the Chef API.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     *         includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and
     *         then change to the directory where you've unzipped the file contents. From this directory, you can run
     *         Knife commands.
     *         </p>
     *         </li>
     *         </ul>
     *         <p class="title">
     *         <b>Attributes returned in a createServer response for Puppet</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit,
     *         including a README and a required private key. Save this file, unzip it, and then change to the directory
     *         where you've unzipped the file contents.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     *         Enterprise console after the server is online.
     *         </p>
     *         </li>
     */
    public final List<EngineAttribute> engineAttributes() {
        return engineAttributes;
    }

    /**
     * <p>
     * The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
     * <code>2</code>. For a Puppet server, specify either <code>2019</code> or <code>2017</code>.
     * </p>
     * 
     * @return The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
     *         <code>2</code>. For a Puppet server, specify either <code>2019</code> or <code>2017</code>.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The instance profile ARN of the server.
     * </p>
     * 
     * @return The instance profile ARN of the server.
     */
    public final String instanceProfileArn() {
        return instanceProfileArn;
    }

    /**
     * <p>
     * The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance
     * type that is shown in the EC2 console.
     * </p>
     * 
     * @return The instance type for the server, as specified in the CloudFormation stack. This might not be the same
     *         instance type that is shown in the EC2 console.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The key pair associated with the server.
     * </p>
     * 
     * @return The key pair associated with the server.
     */
    public final String keyPair() {
        return keyPair;
    }

    /**
     * <p>
     * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceStatus}
     * will return {@link MaintenanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceStatusAsString}.
     * </p>
     * 
     * @return The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * @see MaintenanceStatus
     */
    public final MaintenanceStatus maintenanceStatus() {
        return MaintenanceStatus.fromValue(maintenanceStatus);
    }

    /**
     * <p>
     * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceStatus}
     * will return {@link MaintenanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceStatusAsString}.
     * </p>
     * 
     * @return The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * @see MaintenanceStatus
     */
    public final String maintenanceStatusAsString() {
        return maintenanceStatus;
    }

    /**
     * <p>
     * The preferred maintenance period specified for the server.
     * </p>
     * 
     * @return The preferred maintenance period specified for the server.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The preferred backup period specified for the server.
     * </p>
     * 
     * @return The preferred backup period specified for the server.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same
     * security groups that are shown in the EC2 console.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The security group IDs for the server, as specified in the CloudFormation stack. These might not be the
     *         same security groups that are shown in the EC2 console.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The service role ARN used to create the server.
     * </p>
     * 
     * @return The service role ARN used to create the server.
     */
    public final String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The server's status. This field displays the states of actions in progress, such as creating, running, or backing
     * up the server, as well as the server's health state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The server's status. This field displays the states of actions in progress, such as creating, running, or
     *         backing up the server, as well as the server's health state.
     * @see ServerStatus
     */
    public final ServerStatus status() {
        return ServerStatus.fromValue(status);
    }

    /**
     * <p>
     * The server's status. This field displays the states of actions in progress, such as creating, running, or backing
     * up the server, as well as the server's health state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The server's status. This field displays the states of actions in progress, such as creating, running, or
     *         backing up the server, as well as the server's health state.
     * @see ServerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Depending on the server status, this field has either a human-readable message (such as a create or backup
     * error), or an escaped block of JSON (used for health check results).
     * </p>
     * 
     * @return Depending on the server status, this field has either a human-readable message (such as a create or
     *         backup error), or an escaped block of JSON (used for health check results).
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnet IDs specified in a CreateServer request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The subnet IDs specified in a CreateServer request.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The ARN of the server.
     * </p>
     * 
     * @return The ARN of the server.
     */
    public final String serverArn() {
        return serverArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionCount());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormationStackArn());
        hashCode = 31 * hashCode + Objects.hashCode(customDomain());
        hashCode = 31 * hashCode + Objects.hashCode(disableAutomatedBackup());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineModel());
        hashCode = 31 * hashCode + Objects.hashCode(hasEngineAttributes() ? engineAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serverArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Server)) {
            return false;
        }
        Server other = (Server) obj;
        return Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(backupRetentionCount(), other.backupRetentionCount())
                && Objects.equals(serverName(), other.serverName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(cloudFormationStackArn(), other.cloudFormationStackArn())
                && Objects.equals(customDomain(), other.customDomain())
                && Objects.equals(disableAutomatedBackup(), other.disableAutomatedBackup())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineModel(), other.engineModel()) && hasEngineAttributes() == other.hasEngineAttributes()
                && Objects.equals(engineAttributes(), other.engineAttributes())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(instanceProfileArn(), other.instanceProfileArn())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(keyPair(), other.keyPair())
                && Objects.equals(maintenanceStatusAsString(), other.maintenanceStatusAsString())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(serverArn(), other.serverArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Server").add("AssociatePublicIpAddress", associatePublicIpAddress())
                .add("BackupRetentionCount", backupRetentionCount()).add("ServerName", serverName())
                .add("CreatedAt", createdAt()).add("CloudFormationStackArn", cloudFormationStackArn())
                .add("CustomDomain", customDomain()).add("DisableAutomatedBackup", disableAutomatedBackup())
                .add("Endpoint", endpoint()).add("Engine", engine()).add("EngineModel", engineModel())
                .add("EngineAttributes", hasEngineAttributes() ? engineAttributes() : null).add("EngineVersion", engineVersion())
                .add("InstanceProfileArn", instanceProfileArn()).add("InstanceType", instanceType()).add("KeyPair", keyPair())
                .add("MaintenanceStatus", maintenanceStatusAsString())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("ServiceRoleArn", serviceRoleArn()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("ServerArn", serverArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "BackupRetentionCount":
            return Optional.ofNullable(clazz.cast(backupRetentionCount()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "CloudFormationStackArn":
            return Optional.ofNullable(clazz.cast(cloudFormationStackArn()));
        case "CustomDomain":
            return Optional.ofNullable(clazz.cast(customDomain()));
        case "DisableAutomatedBackup":
            return Optional.ofNullable(clazz.cast(disableAutomatedBackup()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineModel":
            return Optional.ofNullable(clazz.cast(engineModel()));
        case "EngineAttributes":
            return Optional.ofNullable(clazz.cast(engineAttributes()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "InstanceProfileArn":
            return Optional.ofNullable(clazz.cast(instanceProfileArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KeyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        case "MaintenanceStatus":
            return Optional.ofNullable(clazz.cast(maintenanceStatusAsString()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "ServerArn":
            return Optional.ofNullable(clazz.cast(serverArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
        map.put("BackupRetentionCount", BACKUP_RETENTION_COUNT_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CloudFormationStackArn", CLOUD_FORMATION_STACK_ARN_FIELD);
        map.put("CustomDomain", CUSTOM_DOMAIN_FIELD);
        map.put("DisableAutomatedBackup", DISABLE_AUTOMATED_BACKUP_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineModel", ENGINE_MODEL_FIELD);
        map.put("EngineAttributes", ENGINE_ATTRIBUTES_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("InstanceProfileArn", INSTANCE_PROFILE_ARN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("KeyPair", KEY_PAIR_FIELD);
        map.put("MaintenanceStatus", MAINTENANCE_STATUS_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("PreferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("ServiceRoleArn", SERVICE_ROLE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("ServerArn", SERVER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Server, T> g) {
        return obj -> g.apply((Server) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Server> {
        /**
         * <p>
         * Associate a public IP address with a server that you are launching.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Associate a public IP address with a server that you are launching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * The number of automated backups to keep.
         * </p>
         * 
         * @param backupRetentionCount
         *        The number of automated backups to keep.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionCount(Integer backupRetentionCount);

        /**
         * <p>
         * The name of the server.
         * </p>
         * 
         * @param serverName
         *        The name of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
         * </p>
         * 
         * @param createdAt
         *        Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ARN of the CloudFormation stack that was used to create the server.
         * </p>
         * 
         * @param cloudFormationStackArn
         *        The ARN of the CloudFormation stack that was used to create the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationStackArn(String cloudFormationStackArn);

        /**
         * <p>
         * An optional public endpoint of a server, such as <code>https://aws.my-company.com</code>. You cannot access
         * the server by using the <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.
         * </p>
         * 
         * @param customDomain
         *        An optional public endpoint of a server, such as <code>https://aws.my-company.com</code>. You cannot
         *        access the server by using the <code>Endpoint</code> value if the server has a
         *        <code>CustomDomain</code> specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomain(String customDomain);

        /**
         * <p>
         * Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
         * </p>
         * 
         * @param disableAutomatedBackup
         *        Disables automated backups. The number of stored backups is dependent on the value of
         *        PreferredBackupCount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableAutomatedBackup(Boolean disableAutomatedBackup);

        /**
         * <p>
         * A DNS name that can be used to access the engine. Example:
         * <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>. You cannot access the server by using the
         * <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.
         * </p>
         * 
         * @param endpoint
         *        A DNS name that can be used to access the engine. Example:
         *        <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>. You cannot access the server by using the
         *        <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
         * <code>Puppet</code>.
         * </p>
         * 
         * @param engine
         *        The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
         *        <code>Puppet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and
         * <code>Single</code> for Chef.
         * </p>
         * 
         * @param engineModel
         *        The engine model of the server. Valid values in this release include <code>Monolithic</code> for
         *        Puppet and <code>Single</code> for Chef.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineModel(String engineModel);

        /**
         * <p>
         * The response of a createServer() request returns the master credential to access the server in
         * EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the
         * result of createServer().
         * </p>
         * <p class="title">
         * <b>Attributes returned in a createServer response for Chef</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks
         * for Chef Automate. This private key is required to access the Chef API.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
         * includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then
         * change to the directory where you've unzipped the file contents. From this directory, you can run Knife
         * commands.
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>Attributes returned in a createServer response for Puppet</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit,
         * including a README and a required private key. Save this file, unzip it, and then change to the directory
         * where you've unzipped the file contents.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
         * Enterprise console after the server is online.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineAttributes
         *        The response of a createServer() request returns the master credential to access the server in
         *        EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part
         *        of the result of createServer(). </p>
         *        <p class="title">
         *        <b>Attributes returned in a createServer response for Chef</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS
         *        OpsWorks for Chef Automate. This private key is required to access the Chef API.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit,
         *        which includes a README, a configuration file, and the required RSA private key. Save this file, unzip
         *        it, and then change to the directory where you've unzipped the file contents. From this directory, you
         *        can run Knife commands.
         *        </p>
         *        </li>
         *        </ul>
         *        <p class="title">
         *        <b>Attributes returned in a createServer response for Puppet</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter
         *        kit, including a README and a required private key. Save this file, unzip it, and then change to the
         *        directory where you've unzipped the file contents.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the
         *        Puppet Enterprise console after the server is online.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(Collection<EngineAttribute> engineAttributes);

        /**
         * <p>
         * The response of a createServer() request returns the master credential to access the server in
         * EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the
         * result of createServer().
         * </p>
         * <p class="title">
         * <b>Attributes returned in a createServer response for Chef</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks
         * for Chef Automate. This private key is required to access the Chef API.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
         * includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then
         * change to the directory where you've unzipped the file contents. From this directory, you can run Knife
         * commands.
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>Attributes returned in a createServer response for Puppet</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit,
         * including a README and a required private key. Save this file, unzip it, and then change to the directory
         * where you've unzipped the file contents.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
         * Enterprise console after the server is online.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineAttributes
         *        The response of a createServer() request returns the master credential to access the server in
         *        EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part
         *        of the result of createServer(). </p>
         *        <p class="title">
         *        <b>Attributes returned in a createServer response for Chef</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS
         *        OpsWorks for Chef Automate. This private key is required to access the Chef API.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit,
         *        which includes a README, a configuration file, and the required RSA private key. Save this file, unzip
         *        it, and then change to the directory where you've unzipped the file contents. From this directory, you
         *        can run Knife commands.
         *        </p>
         *        </li>
         *        </ul>
         *        <p class="title">
         *        <b>Attributes returned in a createServer response for Puppet</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter
         *        kit, including a README and a required private key. Save this file, unzip it, and then change to the
         *        directory where you've unzipped the file contents.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the
         *        Puppet Enterprise console after the server is online.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(EngineAttribute... engineAttributes);

        /**
         * <p>
         * The response of a createServer() request returns the master credential to access the server in
         * EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the
         * result of createServer().
         * </p>
         * <p class="title">
         * <b>Attributes returned in a createServer response for Chef</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks
         * for Chef Automate. This private key is required to access the Chef API.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
         * includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then
         * change to the directory where you've unzipped the file contents. From this directory, you can run Knife
         * commands.
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>Attributes returned in a createServer response for Puppet</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit,
         * including a README and a required private key. Save this file, unzip it, and then change to the directory
         * where you've unzipped the file contents.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
         * Enterprise console after the server is online.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #engineAttributes(List<EngineAttribute>)}.
         * 
         * @param engineAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineAttributes(java.util.Collection<EngineAttribute>)
         */
        Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes);

        /**
         * <p>
         * The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
         * <code>2</code>. For a Puppet server, specify either <code>2019</code> or <code>2017</code>.
         * </p>
         * 
         * @param engineVersion
         *        The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
         *        <code>2</code>. For a Puppet server, specify either <code>2019</code> or <code>2017</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The instance profile ARN of the server.
         * </p>
         * 
         * @param instanceProfileArn
         *        The instance profile ARN of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileArn(String instanceProfileArn);

        /**
         * <p>
         * The instance type for the server, as specified in the CloudFormation stack. This might not be the same
         * instance type that is shown in the EC2 console.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the server, as specified in the CloudFormation stack. This might not be the same
         *        instance type that is shown in the EC2 console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The key pair associated with the server.
         * </p>
         * 
         * @param keyPair
         *        The key pair associated with the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(String keyPair);

        /**
         * <p>
         * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
         * </p>
         * 
         * @param maintenanceStatus
         *        The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or
         *        <code>FAILED</code>.
         * @see MaintenanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceStatus
         */
        Builder maintenanceStatus(String maintenanceStatus);

        /**
         * <p>
         * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
         * </p>
         * 
         * @param maintenanceStatus
         *        The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or
         *        <code>FAILED</code>.
         * @see MaintenanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceStatus
         */
        Builder maintenanceStatus(MaintenanceStatus maintenanceStatus);

        /**
         * <p>
         * The preferred maintenance period specified for the server.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The preferred maintenance period specified for the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The preferred backup period specified for the server.
         * </p>
         * 
         * @param preferredBackupWindow
         *        The preferred backup period specified for the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same
         * security groups that are shown in the EC2 console.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs for the server, as specified in the CloudFormation stack. These might not be
         *        the same security groups that are shown in the EC2 console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same
         * security groups that are shown in the EC2 console.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs for the server, as specified in the CloudFormation stack. These might not be
         *        the same security groups that are shown in the EC2 console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The service role ARN used to create the server.
         * </p>
         * 
         * @param serviceRoleArn
         *        The service role ARN used to create the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The server's status. This field displays the states of actions in progress, such as creating, running, or
         * backing up the server, as well as the server's health state.
         * </p>
         * 
         * @param status
         *        The server's status. This field displays the states of actions in progress, such as creating, running,
         *        or backing up the server, as well as the server's health state.
         * @see ServerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The server's status. This field displays the states of actions in progress, such as creating, running, or
         * backing up the server, as well as the server's health state.
         * </p>
         * 
         * @param status
         *        The server's status. This field displays the states of actions in progress, such as creating, running,
         *        or backing up the server, as well as the server's health state.
         * @see ServerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerStatus
         */
        Builder status(ServerStatus status);

        /**
         * <p>
         * Depending on the server status, this field has either a human-readable message (such as a create or backup
         * error), or an escaped block of JSON (used for health check results).
         * </p>
         * 
         * @param statusReason
         *        Depending on the server status, this field has either a human-readable message (such as a create or
         *        backup error), or an escaped block of JSON (used for health check results).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The subnet IDs specified in a CreateServer request.
         * </p>
         * 
         * @param subnetIds
         *        The subnet IDs specified in a CreateServer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The subnet IDs specified in a CreateServer request.
         * </p>
         * 
         * @param subnetIds
         *        The subnet IDs specified in a CreateServer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The ARN of the server.
         * </p>
         * 
         * @param serverArn
         *        The ARN of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverArn(String serverArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean associatePublicIpAddress;

        private Integer backupRetentionCount;

        private String serverName;

        private Instant createdAt;

        private String cloudFormationStackArn;

        private String customDomain;

        private Boolean disableAutomatedBackup;

        private String endpoint;

        private String engine;

        private String engineModel;

        private List<EngineAttribute> engineAttributes = DefaultSdkAutoConstructList.getInstance();

        private String engineVersion;

        private String instanceProfileArn;

        private String instanceType;

        private String keyPair;

        private String maintenanceStatus;

        private String preferredMaintenanceWindow;

        private String preferredBackupWindow;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String serviceRoleArn;

        private String status;

        private String statusReason;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String serverArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Server model) {
            associatePublicIpAddress(model.associatePublicIpAddress);
            backupRetentionCount(model.backupRetentionCount);
            serverName(model.serverName);
            createdAt(model.createdAt);
            cloudFormationStackArn(model.cloudFormationStackArn);
            customDomain(model.customDomain);
            disableAutomatedBackup(model.disableAutomatedBackup);
            endpoint(model.endpoint);
            engine(model.engine);
            engineModel(model.engineModel);
            engineAttributes(model.engineAttributes);
            engineVersion(model.engineVersion);
            instanceProfileArn(model.instanceProfileArn);
            instanceType(model.instanceType);
            keyPair(model.keyPair);
            maintenanceStatus(model.maintenanceStatus);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            preferredBackupWindow(model.preferredBackupWindow);
            securityGroupIds(model.securityGroupIds);
            serviceRoleArn(model.serviceRoleArn);
            status(model.status);
            statusReason(model.statusReason);
            subnetIds(model.subnetIds);
            serverArn(model.serverArn);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final Integer getBackupRetentionCount() {
            return backupRetentionCount;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCloudFormationStackArn() {
            return cloudFormationStackArn;
        }

        public final void setCloudFormationStackArn(String cloudFormationStackArn) {
            this.cloudFormationStackArn = cloudFormationStackArn;
        }

        @Override
        public final Builder cloudFormationStackArn(String cloudFormationStackArn) {
            this.cloudFormationStackArn = cloudFormationStackArn;
            return this;
        }

        public final String getCustomDomain() {
            return customDomain;
        }

        public final void setCustomDomain(String customDomain) {
            this.customDomain = customDomain;
        }

        @Override
        public final Builder customDomain(String customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        public final Boolean getDisableAutomatedBackup() {
            return disableAutomatedBackup;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineModel() {
            return engineModel;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final List<EngineAttribute.Builder> getEngineAttributes() {
            List<EngineAttribute.Builder> result = EngineAttributesCopier.copyToBuilder(this.engineAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute... engineAttributes) {
            engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes) {
            engineAttributes(Stream.of(engineAttributes).map(c -> EngineAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getInstanceProfileArn() {
            return instanceProfileArn;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKeyPair() {
            return keyPair;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final String getMaintenanceStatus() {
            return maintenanceStatus;
        }

        public final void setMaintenanceStatus(String maintenanceStatus) {
            this.maintenanceStatus = maintenanceStatus;
        }

        @Override
        public final Builder maintenanceStatus(String maintenanceStatus) {
            this.maintenanceStatus = maintenanceStatus;
            return this;
        }

        @Override
        public final Builder maintenanceStatus(MaintenanceStatus maintenanceStatus) {
            this.maintenanceStatus(maintenanceStatus == null ? null : maintenanceStatus.toString());
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getServerArn() {
            return serverArn;
        }

        public final void setServerArn(String serverArn) {
            this.serverArn = serverArn;
        }

        @Override
        public final Builder serverArn(String serverArn) {
            this.serverArn = serverArn;
            return this;
        }

        @Override
        public Server build() {
            return new Server(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
