/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMaintenanceRequest extends OpsWorksCmRequest implements
        ToCopyableBuilder<StartMaintenanceRequest.Builder, StartMaintenanceRequest> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(StartMaintenanceRequest::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<List<EngineAttribute>> ENGINE_ATTRIBUTES_FIELD = SdkField
            .<List<EngineAttribute>> builder(MarshallingType.LIST)
            .memberName("EngineAttributes")
            .getter(getter(StartMaintenanceRequest::engineAttributes))
            .setter(setter(Builder::engineAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD,
            ENGINE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serverName;

    private final List<EngineAttribute> engineAttributes;

    private StartMaintenanceRequest(BuilderImpl builder) {
        super(builder);
        this.serverName = builder.serverName;
        this.engineAttributes = builder.engineAttributes;
    }

    /**
     * <p>
     * The name of the server on which to run maintenance.
     * </p>
     * 
     * @return The name of the server on which to run maintenance.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngineAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngineAttributes() {
        return engineAttributes != null && !(engineAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Engine attributes that are specific to the server on which you want to run maintenance.
     * </p>
     * <p class="title">
     * <b>Attributes accepted in a StartMaintenance request for Chef</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHEF_MAJOR_UPGRADE</code>: If a Chef Automate server is eligible for upgrade to Chef Automate 2, add this
     * engine attribute to a <code>StartMaintenance</code> request and set the value to <code>true</code> to upgrade the
     * server to Chef Automate 2. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-a2upgrade.html">Upgrade an AWS OpsWorks for
     * Chef Automate Server to Chef Automate 2</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngineAttributes} method.
     * </p>
     * 
     * @return Engine attributes that are specific to the server on which you want to run maintenance.</p>
     *         <p class="title">
     *         <b>Attributes accepted in a StartMaintenance request for Chef</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CHEF_MAJOR_UPGRADE</code>: If a Chef Automate server is eligible for upgrade to Chef Automate 2,
     *         add this engine attribute to a <code>StartMaintenance</code> request and set the value to
     *         <code>true</code> to upgrade the server to Chef Automate 2. For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-a2upgrade.html">Upgrade an AWS OpsWorks
     *         for Chef Automate Server to Chef Automate 2</a>.
     *         </p>
     *         </li>
     */
    public final List<EngineAttribute> engineAttributes() {
        return engineAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEngineAttributes() ? engineAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMaintenanceRequest)) {
            return false;
        }
        StartMaintenanceRequest other = (StartMaintenanceRequest) obj;
        return Objects.equals(serverName(), other.serverName()) && hasEngineAttributes() == other.hasEngineAttributes()
                && Objects.equals(engineAttributes(), other.engineAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMaintenanceRequest").add("ServerName", serverName())
                .add("EngineAttributes", hasEngineAttributes() ? engineAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "EngineAttributes":
            return Optional.ofNullable(clazz.cast(engineAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("EngineAttributes", ENGINE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMaintenanceRequest, T> g) {
        return obj -> g.apply((StartMaintenanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartMaintenanceRequest> {
        /**
         * <p>
         * The name of the server on which to run maintenance.
         * </p>
         * 
         * @param serverName
         *        The name of the server on which to run maintenance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * Engine attributes that are specific to the server on which you want to run maintenance.
         * </p>
         * <p class="title">
         * <b>Attributes accepted in a StartMaintenance request for Chef</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_MAJOR_UPGRADE</code>: If a Chef Automate server is eligible for upgrade to Chef Automate 2, add
         * this engine attribute to a <code>StartMaintenance</code> request and set the value to <code>true</code> to
         * upgrade the server to Chef Automate 2. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-a2upgrade.html">Upgrade an AWS OpsWorks for
         * Chef Automate Server to Chef Automate 2</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineAttributes
         *        Engine attributes that are specific to the server on which you want to run maintenance.</p>
         *        <p class="title">
         *        <b>Attributes accepted in a StartMaintenance request for Chef</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHEF_MAJOR_UPGRADE</code>: If a Chef Automate server is eligible for upgrade to Chef Automate 2,
         *        add this engine attribute to a <code>StartMaintenance</code> request and set the value to
         *        <code>true</code> to upgrade the server to Chef Automate 2. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-a2upgrade.html">Upgrade an AWS
         *        OpsWorks for Chef Automate Server to Chef Automate 2</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(Collection<EngineAttribute> engineAttributes);

        /**
         * <p>
         * Engine attributes that are specific to the server on which you want to run maintenance.
         * </p>
         * <p class="title">
         * <b>Attributes accepted in a StartMaintenance request for Chef</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_MAJOR_UPGRADE</code>: If a Chef Automate server is eligible for upgrade to Chef Automate 2, add
         * this engine attribute to a <code>StartMaintenance</code> request and set the value to <code>true</code> to
         * upgrade the server to Chef Automate 2. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-a2upgrade.html">Upgrade an AWS OpsWorks for
         * Chef Automate Server to Chef Automate 2</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineAttributes
         *        Engine attributes that are specific to the server on which you want to run maintenance.</p>
         *        <p class="title">
         *        <b>Attributes accepted in a StartMaintenance request for Chef</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHEF_MAJOR_UPGRADE</code>: If a Chef Automate server is eligible for upgrade to Chef Automate 2,
         *        add this engine attribute to a <code>StartMaintenance</code> request and set the value to
         *        <code>true</code> to upgrade the server to Chef Automate 2. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-a2upgrade.html">Upgrade an AWS
         *        OpsWorks for Chef Automate Server to Chef Automate 2</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(EngineAttribute... engineAttributes);

        /**
         * <p>
         * Engine attributes that are specific to the server on which you want to run maintenance.
         * </p>
         * <p class="title">
         * <b>Attributes accepted in a StartMaintenance request for Chef</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_MAJOR_UPGRADE</code>: If a Chef Automate server is eligible for upgrade to Chef Automate 2, add
         * this engine attribute to a <code>StartMaintenance</code> request and set the value to <code>true</code> to
         * upgrade the server to Chef Automate 2. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-a2upgrade.html">Upgrade an AWS OpsWorks for
         * Chef Automate Server to Chef Automate 2</a>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #engineAttributes(List<EngineAttribute>)}.
         * 
         * @param engineAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opsworkscm.model.EngineAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineAttributes(java.util.Collection<EngineAttribute>)
         */
        Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksCmRequest.BuilderImpl implements Builder {
        private String serverName;

        private List<EngineAttribute> engineAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMaintenanceRequest model) {
            super(model);
            serverName(model.serverName);
            engineAttributes(model.engineAttributes);
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final List<EngineAttribute.Builder> getEngineAttributes() {
            List<EngineAttribute.Builder> result = EngineAttributesCopier.copyToBuilder(this.engineAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute... engineAttributes) {
            engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes) {
            engineAttributes(Stream.of(engineAttributes).map(c -> EngineAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMaintenanceRequest build() {
            return new StartMaintenanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
