/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmRequest;
import software.amazon.awssdk.services.opsworkscm.model.StringsCopier;
import software.amazon.awssdk.services.opsworkscm.model.Tag;
import software.amazon.awssdk.services.opsworkscm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServerRequest
extends OpsWorksCmRequest
implements ToCopyableBuilder<Builder, CreateServerRequest> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress").getter(CreateServerRequest.getter(CreateServerRequest::associatePublicIpAddress)).setter(CreateServerRequest.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomDomain").getter(CreateServerRequest.getter(CreateServerRequest::customDomain)).setter(CreateServerRequest.setter(Builder::customDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomain").build()}).build();
    private static final SdkField<String> CUSTOM_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomCertificate").getter(CreateServerRequest.getter(CreateServerRequest::customCertificate)).setter(CreateServerRequest.setter(Builder::customCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomCertificate").build()}).build();
    private static final SdkField<String> CUSTOM_PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomPrivateKey").getter(CreateServerRequest.getter(CreateServerRequest::customPrivateKey)).setter(CreateServerRequest.setter(Builder::customPrivateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPrivateKey").build()}).build();
    private static final SdkField<Boolean> DISABLE_AUTOMATED_BACKUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableAutomatedBackup").getter(CreateServerRequest.getter(CreateServerRequest::disableAutomatedBackup)).setter(CreateServerRequest.setter(Builder::disableAutomatedBackup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableAutomatedBackup").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CreateServerRequest.getter(CreateServerRequest::engine)).setter(CreateServerRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineModel").getter(CreateServerRequest.getter(CreateServerRequest::engineModel)).setter(CreateServerRequest.setter(Builder::engineModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineModel").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreateServerRequest.getter(CreateServerRequest::engineVersion)).setter(CreateServerRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<List<EngineAttribute>> ENGINE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngineAttributes").getter(CreateServerRequest.getter(CreateServerRequest::engineAttributes)).setter(CreateServerRequest.setter(Builder::engineAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngineAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionCount").getter(CreateServerRequest.getter(CreateServerRequest::backupRetentionCount)).setter(CreateServerRequest.setter(Builder::backupRetentionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionCount").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(CreateServerRequest.getter(CreateServerRequest::serverName)).setter(CreateServerRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileArn").getter(CreateServerRequest.getter(CreateServerRequest::instanceProfileArn)).setter(CreateServerRequest.setter(Builder::instanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileArn").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CreateServerRequest.getter(CreateServerRequest::instanceType)).setter(CreateServerRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPair").getter(CreateServerRequest.getter(CreateServerRequest::keyPair)).setter(CreateServerRequest.setter(Builder::keyPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPair").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(CreateServerRequest.getter(CreateServerRequest::preferredMaintenanceWindow)).setter(CreateServerRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(CreateServerRequest.getter(CreateServerRequest::preferredBackupWindow)).setter(CreateServerRequest.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateServerRequest.getter(CreateServerRequest::securityGroupIds)).setter(CreateServerRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRoleArn").getter(CreateServerRequest.getter(CreateServerRequest::serviceRoleArn)).setter(CreateServerRequest.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateServerRequest.getter(CreateServerRequest::subnetIds)).setter(CreateServerRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateServerRequest.getter(CreateServerRequest::tags)).setter(CreateServerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupId").getter(CreateServerRequest.getter(CreateServerRequest::backupId)).setter(CreateServerRequest.setter(Builder::backupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, CUSTOM_DOMAIN_FIELD, CUSTOM_CERTIFICATE_FIELD, CUSTOM_PRIVATE_KEY_FIELD, DISABLE_AUTOMATED_BACKUP_FIELD, ENGINE_FIELD, ENGINE_MODEL_FIELD, ENGINE_VERSION_FIELD, ENGINE_ATTRIBUTES_FIELD, BACKUP_RETENTION_COUNT_FIELD, SERVER_NAME_FIELD, INSTANCE_PROFILE_ARN_FIELD, INSTANCE_TYPE_FIELD, KEY_PAIR_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, SECURITY_GROUP_IDS_FIELD, SERVICE_ROLE_ARN_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, BACKUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateServerRequest.memberNameToFieldInitializer();
    private final Boolean associatePublicIpAddress;
    private final String customDomain;
    private final String customCertificate;
    private final String customPrivateKey;
    private final Boolean disableAutomatedBackup;
    private final String engine;
    private final String engineModel;
    private final String engineVersion;
    private final List<EngineAttribute> engineAttributes;
    private final Integer backupRetentionCount;
    private final String serverName;
    private final String instanceProfileArn;
    private final String instanceType;
    private final String keyPair;
    private final String preferredMaintenanceWindow;
    private final String preferredBackupWindow;
    private final List<String> securityGroupIds;
    private final String serviceRoleArn;
    private final List<String> subnetIds;
    private final List<Tag> tags;
    private final String backupId;

    private CreateServerRequest(BuilderImpl builder) {
        super(builder);
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.customDomain = builder.customDomain;
        this.customCertificate = builder.customCertificate;
        this.customPrivateKey = builder.customPrivateKey;
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineVersion = builder.engineVersion;
        this.engineAttributes = builder.engineAttributes;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.backupId = builder.backupId;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public final String customDomain() {
        return this.customDomain;
    }

    public final String customCertificate() {
        return this.customCertificate;
    }

    public final String customPrivateKey() {
        return this.customPrivateKey;
    }

    public final Boolean disableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineModel() {
        return this.engineModel;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final boolean hasEngineAttributes() {
        return this.engineAttributes != null && !(this.engineAttributes instanceof SdkAutoConstructList);
    }

    public final List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    public final Integer backupRetentionCount() {
        return this.backupRetentionCount;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String keyPair() {
        return this.keyPair;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String backupId() {
        return this.backupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.customCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPrivateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableAutomatedBackup());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngineAttributes() ? this.engineAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerRequest)) {
            return false;
        }
        CreateServerRequest other = (CreateServerRequest)((Object)obj);
        return Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.customDomain(), other.customDomain()) && Objects.equals(this.customCertificate(), other.customCertificate()) && Objects.equals(this.customPrivateKey(), other.customPrivateKey()) && Objects.equals(this.disableAutomatedBackup(), other.disableAutomatedBackup()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineModel(), other.engineModel()) && Objects.equals(this.engineVersion(), other.engineVersion()) && this.hasEngineAttributes() == other.hasEngineAttributes() && Objects.equals(this.engineAttributes(), other.engineAttributes()) && Objects.equals(this.backupRetentionCount(), other.backupRetentionCount()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.instanceProfileArn(), other.instanceProfileArn()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.keyPair(), other.keyPair()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.backupId(), other.backupId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServerRequest").add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("CustomDomain", (Object)this.customDomain()).add("CustomCertificate", (Object)this.customCertificate()).add("CustomPrivateKey", (Object)(this.customPrivateKey() == null ? null : "*** Sensitive Data Redacted ***")).add("DisableAutomatedBackup", (Object)this.disableAutomatedBackup()).add("Engine", (Object)this.engine()).add("EngineModel", (Object)this.engineModel()).add("EngineVersion", (Object)this.engineVersion()).add("EngineAttributes", this.hasEngineAttributes() ? this.engineAttributes() : null).add("BackupRetentionCount", (Object)this.backupRetentionCount()).add("ServerName", (Object)this.serverName()).add("InstanceProfileArn", (Object)this.instanceProfileArn()).add("InstanceType", (Object)this.instanceType()).add("KeyPair", (Object)this.keyPair()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("BackupId", (Object)this.backupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "CustomDomain": {
                return Optional.ofNullable(clazz.cast(this.customDomain()));
            }
            case "CustomCertificate": {
                return Optional.ofNullable(clazz.cast(this.customCertificate()));
            }
            case "CustomPrivateKey": {
                return Optional.ofNullable(clazz.cast(this.customPrivateKey()));
            }
            case "DisableAutomatedBackup": {
                return Optional.ofNullable(clazz.cast(this.disableAutomatedBackup()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineModel": {
                return Optional.ofNullable(clazz.cast(this.engineModel()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "EngineAttributes": {
                return Optional.ofNullable(clazz.cast(this.engineAttributes()));
            }
            case "BackupRetentionCount": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionCount()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "InstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileArn()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KeyPair": {
                return Optional.ofNullable(clazz.cast(this.keyPair()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
        map.put("CustomDomain", CUSTOM_DOMAIN_FIELD);
        map.put("CustomCertificate", CUSTOM_CERTIFICATE_FIELD);
        map.put("CustomPrivateKey", CUSTOM_PRIVATE_KEY_FIELD);
        map.put("DisableAutomatedBackup", DISABLE_AUTOMATED_BACKUP_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineModel", ENGINE_MODEL_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("EngineAttributes", ENGINE_ATTRIBUTES_FIELD);
        map.put("BackupRetentionCount", BACKUP_RETENTION_COUNT_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("InstanceProfileArn", INSTANCE_PROFILE_ARN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("KeyPair", KEY_PAIR_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("PreferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("ServiceRoleArn", SERVICE_ROLE_ARN_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("BackupId", BACKUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServerRequest, T> g) {
        return obj -> g.apply((CreateServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksCmRequest.BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private String customDomain;
        private String customCertificate;
        private String customPrivateKey;
        private Boolean disableAutomatedBackup;
        private String engine;
        private String engineModel;
        private String engineVersion;
        private List<EngineAttribute> engineAttributes = DefaultSdkAutoConstructList.getInstance();
        private Integer backupRetentionCount;
        private String serverName;
        private String instanceProfileArn;
        private String instanceType;
        private String keyPair;
        private String preferredMaintenanceWindow;
        private String preferredBackupWindow;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String serviceRoleArn;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String backupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerRequest model) {
            super(model);
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.customDomain(model.customDomain);
            this.customCertificate(model.customCertificate);
            this.customPrivateKey(model.customPrivateKey);
            this.disableAutomatedBackup(model.disableAutomatedBackup);
            this.engine(model.engine);
            this.engineModel(model.engineModel);
            this.engineVersion(model.engineVersion);
            this.engineAttributes(model.engineAttributes);
            this.backupRetentionCount(model.backupRetentionCount);
            this.serverName(model.serverName);
            this.instanceProfileArn(model.instanceProfileArn);
            this.instanceType(model.instanceType);
            this.keyPair(model.keyPair);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.securityGroupIds(model.securityGroupIds);
            this.serviceRoleArn(model.serviceRoleArn);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
            this.backupId(model.backupId);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final String getCustomDomain() {
            return this.customDomain;
        }

        public final void setCustomDomain(String customDomain) {
            this.customDomain = customDomain;
        }

        @Override
        public final Builder customDomain(String customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        public final String getCustomCertificate() {
            return this.customCertificate;
        }

        public final void setCustomCertificate(String customCertificate) {
            this.customCertificate = customCertificate;
        }

        @Override
        public final Builder customCertificate(String customCertificate) {
            this.customCertificate = customCertificate;
            return this;
        }

        public final String getCustomPrivateKey() {
            return this.customPrivateKey;
        }

        public final void setCustomPrivateKey(String customPrivateKey) {
            this.customPrivateKey = customPrivateKey;
        }

        @Override
        public final Builder customPrivateKey(String customPrivateKey) {
            this.customPrivateKey = customPrivateKey;
            return this;
        }

        public final Boolean getDisableAutomatedBackup() {
            return this.disableAutomatedBackup;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineModel() {
            return this.engineModel;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final List<EngineAttribute.Builder> getEngineAttributes() {
            List<EngineAttribute.Builder> result = EngineAttributesCopier.copyToBuilder(this.engineAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            this.engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder> ... engineAttributes) {
            this.engineAttributes(Stream.of(engineAttributes).map(c -> (EngineAttribute)((EngineAttribute.Builder)EngineAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getBackupRetentionCount() {
            return this.backupRetentionCount;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBackupId() {
            return this.backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServerRequest build() {
            return new CreateServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpsWorksCmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServerRequest> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder customDomain(String var1);

        public Builder customCertificate(String var1);

        public Builder customPrivateKey(String var1);

        public Builder disableAutomatedBackup(Boolean var1);

        public Builder engine(String var1);

        public Builder engineModel(String var1);

        public Builder engineVersion(String var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);

        public Builder engineAttributes(Consumer<EngineAttribute.Builder> ... var1);

        public Builder backupRetentionCount(Integer var1);

        public Builder serverName(String var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder backupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

