/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.ActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HandshakeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HandshakeFilter> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HandshakeFilter.getter(HandshakeFilter::actionTypeAsString)).setter(HandshakeFilter.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> PARENT_HANDSHAKE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HandshakeFilter.getter(HandshakeFilter::parentHandshakeId)).setter(HandshakeFilter.setter(Builder::parentHandshakeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentHandshakeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, PARENT_HANDSHAKE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionType;
    private final String parentHandshakeId;

    private HandshakeFilter(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.parentHandshakeId = builder.parentHandshakeId;
    }

    public ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public String actionTypeAsString() {
        return this.actionType;
    }

    public String parentHandshakeId() {
        return this.parentHandshakeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentHandshakeId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeFilter)) {
            return false;
        }
        HandshakeFilter other = (HandshakeFilter)obj;
        return Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.parentHandshakeId(), other.parentHandshakeId());
    }

    public String toString() {
        return ToString.builder((String)"HandshakeFilter").add("ActionType", (Object)this.actionTypeAsString()).add("ParentHandshakeId", (Object)this.parentHandshakeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "ParentHandshakeId": {
                return Optional.ofNullable(clazz.cast(this.parentHandshakeId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HandshakeFilter, T> g) {
        return obj -> g.apply((HandshakeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionType;
        private String parentHandshakeId;

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeFilter model) {
            this.actionType(model.actionType);
            this.parentHandshakeId(model.parentHandshakeId);
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getParentHandshakeId() {
            return this.parentHandshakeId;
        }

        @Override
        public final Builder parentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
            return this;
        }

        public final void setParentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
        }

        public HandshakeFilter build() {
            return new HandshakeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HandshakeFilter> {
        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder parentHandshakeId(String var1);
    }
}

