/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HandshakeState {
    REQUESTED("REQUESTED"),
    OPEN("OPEN"),
    CANCELED("CANCELED"),
    ACCEPTED("ACCEPTED"),
    DECLINED("DECLINED"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HandshakeState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandshakeState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HandshakeState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandshakeState> knownValues() {
        return Stream.of(HandshakeState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

