/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGovCloudAccountRequest extends OrganizationsRequest implements
        ToCopyableBuilder<CreateGovCloudAccountRequest.Builder, CreateGovCloudAccountRequest> {
    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(CreateGovCloudAccountRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountName").getter(getter(CreateGovCloudAccountRequest::accountName))
            .setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(CreateGovCloudAccountRequest::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<String> IAM_USER_ACCESS_TO_BILLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamUserAccessToBilling").getter(getter(CreateGovCloudAccountRequest::iamUserAccessToBillingAsString))
            .setter(setter(Builder::iamUserAccessToBilling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserAccessToBilling").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateGovCloudAccountRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD,
            ACCOUNT_NAME_FIELD, ROLE_NAME_FIELD, IAM_USER_ACCESS_TO_BILLING_FIELD, TAGS_FIELD));

    private final String email;

    private final String accountName;

    private final String roleName;

    private final String iamUserAccessToBilling;

    private final List<Tag> tags;

    private CreateGovCloudAccountRequest(BuilderImpl builder) {
        super(builder);
        this.email = builder.email;
        this.accountName = builder.accountName;
        this.roleName = builder.roleName;
        this.iamUserAccessToBilling = builder.iamUserAccessToBilling;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The email address of the owner to assign to the new member account in the commercial Region. This email address
     * must not already be associated with another AWS account. You must use a valid email address to complete account
     * creation. You can't access the root user of the account or remove an account that was created with an invalid
     * email address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email
     * address for the AWS GovCloud (US) account originates from the commercial Region, not from the AWS GovCloud (US)
     * Region.
     * </p>
     * 
     * @return The email address of the owner to assign to the new member account in the commercial Region. This email
     *         address must not already be associated with another AWS account. You must use a valid email address to
     *         complete account creation. You can't access the root user of the account or remove an account that was
     *         created with an invalid email address. Like all request parameters for <code>CreateGovCloudAccount</code>
     *         , the request for the email address for the AWS GovCloud (US) account originates from the commercial
     *         Region, not from the AWS GovCloud (US) Region.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The friendly name of the member account.
     * </p>
     * 
     * @return The friendly name of the member account.
     */
    public final String accountName() {
        return accountName;
    }

    /**
     * <p>
     * (Optional)
     * </p>
     * <p>
     * The name of an IAM role that AWS Organizations automatically preconfigures in the new member accounts in both the
     * AWS GovCloud (US) Region and in the commercial Region. This role trusts the management account, allowing users in
     * the management account to assume the role, as permitted by the management account administrator. The role has
     * administrator permissions in the new member account.
     * </p>
     * <p>
     * If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.
     * </p>
     * <p>
     * For more information about how to use this role to access the member account, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
     * >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>AWS Organizations User
     * Guide</i> and steps 2 and 3 in <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate
     * Access Across AWS Accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The
     * pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following
     * characters: =,.@-
     * </p>
     * 
     * @return (Optional)</p>
     *         <p>
     *         The name of an IAM role that AWS Organizations automatically preconfigures in the new member accounts in
     *         both the AWS GovCloud (US) Region and in the commercial Region. This role trusts the management account,
     *         allowing users in the management account to assume the role, as permitted by the management account
     *         administrator. The role has administrator permissions in the new member account.
     *         </p>
     *         <p>
     *         If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>
     *         .
     *         </p>
     *         <p>
     *         For more information about how to use this role to access the member account, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
     *         >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>AWS Organizations
     *         User Guide</i> and steps 2 and 3 in <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
     *         Delegate Access Across AWS Accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
     *         </p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter.
     *         The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the
     *         following characters: =,.@-
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account
     * billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user
     * of the new account can access account billing information. For more information, see <a href=
     * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     * >Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost Management User
     * Guide.</i>
     * </p>
     * <p>
     * If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the
     * required permissions can access billing information for the new account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #iamUserAccessToBilling} will return {@link IAMUserAccessToBilling#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #iamUserAccessToBillingAsString}.
     * </p>
     * 
     * @return If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access
     *         account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>,
     *         only the root user of the new account can access account billing information. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     *         >Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost
     *         Management User Guide.</i> </p>
     *         <p>
     *         If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles
     *         with the required permissions can access billing information for the new account.
     * @see IAMUserAccessToBilling
     */
    public final IAMUserAccessToBilling iamUserAccessToBilling() {
        return IAMUserAccessToBilling.fromValue(iamUserAccessToBilling);
    }

    /**
     * <p>
     * If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account
     * billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user
     * of the new account can access account billing information. For more information, see <a href=
     * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     * >Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost Management User
     * Guide.</i>
     * </p>
     * <p>
     * If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the
     * required permissions can access billing information for the new account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #iamUserAccessToBilling} will return {@link IAMUserAccessToBilling#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #iamUserAccessToBillingAsString}.
     * </p>
     * 
     * @return If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access
     *         account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>,
     *         only the root user of the new account can access account billing information. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     *         >Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost
     *         Management User Guide.</i> </p>
     *         <p>
     *         If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles
     *         with the required permissions can access billing information for the new account.
     * @see IAMUserAccessToBilling
     */
    public final String iamUserAccessToBillingAsString() {
        return iamUserAccessToBilling;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that you want to attach to the newly created account. These tags are attached to the commercial
     * account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual
     * GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud account
     * exists.
     * </p>
     * <p>
     * For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string,
     * but you can't set it to <code>null</code>. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
     * resources</a> in the AWS Organizations User Guide.
     * </p>
     * <note>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire
     * request fails and the account is not created.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that you want to attach to the newly created account. These tags are attached to the
     *         commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add
     *         tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after
     *         the new GovCloud account exists.</p>
     *         <p>
     *         For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty
     *         string, but you can't set it to <code>null</code>. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS
     *         Organizations resources</a> in the AWS Organizations User Guide.
     *         </p>
     *         <note>
     *         <p>
     *         If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the
     *         entire request fails and the account is not created.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(iamUserAccessToBillingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGovCloudAccountRequest)) {
            return false;
        }
        CreateGovCloudAccountRequest other = (CreateGovCloudAccountRequest) obj;
        return Objects.equals(email(), other.email()) && Objects.equals(accountName(), other.accountName())
                && Objects.equals(roleName(), other.roleName())
                && Objects.equals(iamUserAccessToBillingAsString(), other.iamUserAccessToBillingAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGovCloudAccountRequest")
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccountName", accountName() == null ? null : "*** Sensitive Data Redacted ***").add("RoleName", roleName())
                .add("IamUserAccessToBilling", iamUserAccessToBillingAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "AccountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "IamUserAccessToBilling":
            return Optional.ofNullable(clazz.cast(iamUserAccessToBillingAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGovCloudAccountRequest, T> g) {
        return obj -> g.apply((CreateGovCloudAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGovCloudAccountRequest> {
        /**
         * <p>
         * The email address of the owner to assign to the new member account in the commercial Region. This email
         * address must not already be associated with another AWS account. You must use a valid email address to
         * complete account creation. You can't access the root user of the account or remove an account that was
         * created with an invalid email address. Like all request parameters for <code>CreateGovCloudAccount</code>,
         * the request for the email address for the AWS GovCloud (US) account originates from the commercial Region,
         * not from the AWS GovCloud (US) Region.
         * </p>
         * 
         * @param email
         *        The email address of the owner to assign to the new member account in the commercial Region. This
         *        email address must not already be associated with another AWS account. You must use a valid email
         *        address to complete account creation. You can't access the root user of the account or remove an
         *        account that was created with an invalid email address. Like all request parameters for
         *        <code>CreateGovCloudAccount</code>, the request for the email address for the AWS GovCloud (US)
         *        account originates from the commercial Region, not from the AWS GovCloud (US) Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The friendly name of the member account.
         * </p>
         * 
         * @param accountName
         *        The friendly name of the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * (Optional)
         * </p>
         * <p>
         * The name of an IAM role that AWS Organizations automatically preconfigures in the new member accounts in both
         * the AWS GovCloud (US) Region and in the commercial Region. This role trusts the management account, allowing
         * users in the management account to assume the role, as permitted by the management account administrator. The
         * role has administrator permissions in the new member account.
         * </p>
         * <p>
         * If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.
         * </p>
         * <p>
         * For more information about how to use this role to access the member account, see <a href=
         * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
         * >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>AWS Organizations User
         * Guide</i> and steps 2 and 3 in <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
         * Delegate Access Across AWS Accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The
         * pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following
         * characters: =,.@-
         * </p>
         * 
         * @param roleName
         *        (Optional)</p>
         *        <p>
         *        The name of an IAM role that AWS Organizations automatically preconfigures in the new member accounts
         *        in both the AWS GovCloud (US) Region and in the commercial Region. This role trusts the management
         *        account, allowing users in the management account to assume the role, as permitted by the management
         *        account administrator. The role has administrator permissions in the new member account.
         *        </p>
         *        <p>
         *        If you don't specify this parameter, the role name defaults to
         *        <code>OrganizationAccountAccessRole</code>.
         *        </p>
         *        <p>
         *        For more information about how to use this role to access the member account, see <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
         *        >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>AWS Organizations
         *        User Guide</i> and steps 2 and 3 in <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html"
         *        >Tutorial: Delegate Access Across AWS Accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
         *        </p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this
         *        parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and
         *        any of the following characters: =,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access
         * account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only
         * the root user of the new account can access account billing information. For more information, see <a href=
         * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
         * >Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost Management
         * User Guide.</i>
         * </p>
         * <p>
         * If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with
         * the required permissions can access billing information for the new account.
         * </p>
         * 
         * @param iamUserAccessToBilling
         *        If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to
         *        access account billing information <i>if</i> they have the required permissions. If set to
         *        <code>DENY</code>, only the root user of the new account can access account billing information. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
         *        >Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost
         *        Management User Guide.</i> </p>
         *        <p>
         *        If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles
         *        with the required permissions can access billing information for the new account.
         * @see IAMUserAccessToBilling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IAMUserAccessToBilling
         */
        Builder iamUserAccessToBilling(String iamUserAccessToBilling);

        /**
         * <p>
         * If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access
         * account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only
         * the root user of the new account can access account billing information. For more information, see <a href=
         * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
         * >Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost Management
         * User Guide.</i>
         * </p>
         * <p>
         * If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with
         * the required permissions can access billing information for the new account.
         * </p>
         * 
         * @param iamUserAccessToBilling
         *        If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to
         *        access account billing information <i>if</i> they have the required permissions. If set to
         *        <code>DENY</code>, only the root user of the new account can access account billing information. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
         *        >Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost
         *        Management User Guide.</i> </p>
         *        <p>
         *        If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles
         *        with the required permissions can access billing information for the new account.
         * @see IAMUserAccessToBilling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IAMUserAccessToBilling
         */
        Builder iamUserAccessToBilling(IAMUserAccessToBilling iamUserAccessToBilling);

        /**
         * <p>
         * A list of tags that you want to attach to the newly created account. These tags are attached to the
         * commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add tags
         * to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new
         * GovCloud account exists.
         * </p>
         * <p>
         * For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty
         * string, but you can't set it to <code>null</code>. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
         * resources</a> in the AWS Organizations User Guide.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire
         * request fails and the account is not created.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the newly created account. These tags are attached to the
         *        commercial account associated with the GovCloud account, and not to the GovCloud account itself. To
         *        add tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region
         *        after the new GovCloud account exists.</p>
         *        <p>
         *        For each tag in the list, you must specify both a tag key and a value. You can set the value to an
         *        empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS
         *        Organizations resources</a> in the AWS Organizations User Guide.
         *        </p>
         *        <note>
         *        <p>
         *        If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the
         *        entire request fails and the account is not created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that you want to attach to the newly created account. These tags are attached to the
         * commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add tags
         * to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new
         * GovCloud account exists.
         * </p>
         * <p>
         * For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty
         * string, but you can't set it to <code>null</code>. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
         * resources</a> in the AWS Organizations User Guide.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire
         * request fails and the account is not created.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the newly created account. These tags are attached to the
         *        commercial account associated with the GovCloud account, and not to the GovCloud account itself. To
         *        add tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region
         *        after the new GovCloud account exists.</p>
         *        <p>
         *        For each tag in the list, you must specify both a tag key and a value. You can set the value to an
         *        empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS
         *        Organizations resources</a> in the AWS Organizations User Guide.
         *        </p>
         *        <note>
         *        <p>
         *        If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the
         *        entire request fails and the account is not created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that you want to attach to the newly created account. These tags are attached to the
         * commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add tags
         * to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new
         * GovCloud account exists.
         * </p>
         * <p>
         * For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty
         * string, but you can't set it to <code>null</code>. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
         * resources</a> in the AWS Organizations User Guide.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire
         * request fails and the account is not created.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String email;

        private String accountName;

        private String roleName;

        private String iamUserAccessToBilling;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGovCloudAccountRequest model) {
            super(model);
            email(model.email);
            accountName(model.accountName);
            roleName(model.roleName);
            iamUserAccessToBilling(model.iamUserAccessToBilling);
            tags(model.tags);
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        @Transient
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        @Transient
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        @Transient
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getIamUserAccessToBilling() {
            return iamUserAccessToBilling;
        }

        public final void setIamUserAccessToBilling(String iamUserAccessToBilling) {
            this.iamUserAccessToBilling = iamUserAccessToBilling;
        }

        @Override
        @Transient
        public final Builder iamUserAccessToBilling(String iamUserAccessToBilling) {
            this.iamUserAccessToBilling = iamUserAccessToBilling;
            return this;
        }

        @Override
        @Transient
        public final Builder iamUserAccessToBilling(IAMUserAccessToBilling iamUserAccessToBilling) {
            this.iamUserAccessToBilling(iamUserAccessToBilling == null ? null : iamUserAccessToBilling.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGovCloudAccountRequest build() {
            return new CreateGovCloudAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
