/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains rules to be applied to the affected accounts. The effective policy is the aggregation of any policies the
 * account inherits, plus any policy directly attached to the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EffectivePolicy implements SdkPojo, Serializable, ToCopyableBuilder<EffectivePolicy.Builder, EffectivePolicy> {
    private static final SdkField<String> POLICY_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyContent").getter(getter(EffectivePolicy::policyContent)).setter(setter(Builder::policyContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyContent").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(EffectivePolicy::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(EffectivePolicy::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(EffectivePolicy::policyTypeAsString)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_CONTENT_FIELD,
            LAST_UPDATED_TIMESTAMP_FIELD, TARGET_ID_FIELD, POLICY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyContent;

    private final Instant lastUpdatedTimestamp;

    private final String targetId;

    private final String policyType;

    private EffectivePolicy(BuilderImpl builder) {
        this.policyContent = builder.policyContent;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.targetId = builder.targetId;
        this.policyType = builder.policyType;
    }

    /**
     * <p>
     * The text content of the policy.
     * </p>
     * 
     * @return The text content of the policy.
     */
    public final String policyContent() {
        return policyContent;
    }

    /**
     * <p>
     * The time of the last update to this policy.
     * </p>
     * 
     * @return The time of the last update to this policy.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The account ID of the policy target.
     * </p>
     * 
     * @return The account ID of the policy target.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The policy type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link EffectivePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The policy type.
     * @see EffectivePolicyType
     */
    public final EffectivePolicyType policyType() {
        return EffectivePolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The policy type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link EffectivePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The policy type.
     * @see EffectivePolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyContent());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectivePolicy)) {
            return false;
        }
        EffectivePolicy other = (EffectivePolicy) obj;
        return Objects.equals(policyContent(), other.policyContent())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(targetId(), other.targetId())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EffectivePolicy").add("PolicyContent", policyContent())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("TargetId", targetId())
                .add("PolicyType", policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyContent":
            return Optional.ofNullable(clazz.cast(policyContent()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EffectivePolicy, T> g) {
        return obj -> g.apply((EffectivePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EffectivePolicy> {
        /**
         * <p>
         * The text content of the policy.
         * </p>
         * 
         * @param policyContent
         *        The text content of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyContent(String policyContent);

        /**
         * <p>
         * The time of the last update to this policy.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The time of the last update to this policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The account ID of the policy target.
         * </p>
         * 
         * @param targetId
         *        The account ID of the policy target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The policy type.
         * </p>
         * 
         * @param policyType
         *        The policy type.
         * @see EffectivePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The policy type.
         * </p>
         * 
         * @param policyType
         *        The policy type.
         * @see EffectivePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePolicyType
         */
        Builder policyType(EffectivePolicyType policyType);
    }

    static final class BuilderImpl implements Builder {
        private String policyContent;

        private Instant lastUpdatedTimestamp;

        private String targetId;

        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectivePolicy model) {
            policyContent(model.policyContent);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            targetId(model.targetId);
            policyType(model.policyType);
        }

        public final String getPolicyContent() {
            return policyContent;
        }

        public final void setPolicyContent(String policyContent) {
            this.policyContent = policyContent;
        }

        @Override
        @Transient
        public final Builder policyContent(String policyContent) {
            this.policyContent = policyContent;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        @Transient
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        @Transient
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        @Transient
        public final Builder policyType(EffectivePolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        @Override
        public EffectivePolicy build() {
            return new EffectivePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
