/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains details of a service principal that represents an AWS service that is enabled to integrate
 * with AWS Organizations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledServicePrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledServicePrincipal.Builder, EnabledServicePrincipal> {
    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServicePrincipal").getter(getter(EnabledServicePrincipal::servicePrincipal))
            .setter(setter(Builder::servicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal").build()).build();

    private static final SdkField<Instant> DATE_ENABLED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateEnabled").getter(getter(EnabledServicePrincipal::dateEnabled)).setter(setter(Builder::dateEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_PRINCIPAL_FIELD,
            DATE_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String servicePrincipal;

    private final Instant dateEnabled;

    private EnabledServicePrincipal(BuilderImpl builder) {
        this.servicePrincipal = builder.servicePrincipal;
        this.dateEnabled = builder.dateEnabled;
    }

    /**
     * <p>
     * The name of the service principal. This is typically in the form of a URL, such as:
     * <code> <i>servicename</i>.amazonaws.com</code>.
     * </p>
     * 
     * @return The name of the service principal. This is typically in the form of a URL, such as:
     *         <code> <i>servicename</i>.amazonaws.com</code>.
     */
    public final String servicePrincipal() {
        return servicePrincipal;
    }

    /**
     * <p>
     * The date that the service principal was enabled for integration with AWS Organizations.
     * </p>
     * 
     * @return The date that the service principal was enabled for integration with AWS Organizations.
     */
    public final Instant dateEnabled() {
        return dateEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(dateEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledServicePrincipal)) {
            return false;
        }
        EnabledServicePrincipal other = (EnabledServicePrincipal) obj;
        return Objects.equals(servicePrincipal(), other.servicePrincipal()) && Objects.equals(dateEnabled(), other.dateEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledServicePrincipal").add("ServicePrincipal", servicePrincipal())
                .add("DateEnabled", dateEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServicePrincipal":
            return Optional.ofNullable(clazz.cast(servicePrincipal()));
        case "DateEnabled":
            return Optional.ofNullable(clazz.cast(dateEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnabledServicePrincipal, T> g) {
        return obj -> g.apply((EnabledServicePrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledServicePrincipal> {
        /**
         * <p>
         * The name of the service principal. This is typically in the form of a URL, such as:
         * <code> <i>servicename</i>.amazonaws.com</code>.
         * </p>
         * 
         * @param servicePrincipal
         *        The name of the service principal. This is typically in the form of a URL, such as:
         *        <code> <i>servicename</i>.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(String servicePrincipal);

        /**
         * <p>
         * The date that the service principal was enabled for integration with AWS Organizations.
         * </p>
         * 
         * @param dateEnabled
         *        The date that the service principal was enabled for integration with AWS Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateEnabled(Instant dateEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String servicePrincipal;

        private Instant dateEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledServicePrincipal model) {
            servicePrincipal(model.servicePrincipal);
            dateEnabled(model.dateEnabled);
        }

        public final String getServicePrincipal() {
            return servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        @Transient
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final Instant getDateEnabled() {
            return dateEnabled;
        }

        public final void setDateEnabled(Instant dateEnabled) {
            this.dateEnabled = dateEnabled;
        }

        @Override
        @Transient
        public final Builder dateEnabled(Instant dateEnabled) {
            this.dateEnabled = dateEnabled;
            return this;
        }

        @Override
        public EnabledServicePrincipal build() {
            return new EnabledServicePrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
