/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum HandshakeConstraintViolationExceptionReason {
    ACCOUNT_NUMBER_LIMIT_EXCEEDED("ACCOUNT_NUMBER_LIMIT_EXCEEDED"),

    HANDSHAKE_RATE_LIMIT_EXCEEDED("HANDSHAKE_RATE_LIMIT_EXCEEDED"),

    ALREADY_IN_AN_ORGANIZATION("ALREADY_IN_AN_ORGANIZATION"),

    ORGANIZATION_ALREADY_HAS_ALL_FEATURES("ORGANIZATION_ALREADY_HAS_ALL_FEATURES"),

    ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION("ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION"),

    INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES("INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES"),

    PAYMENT_INSTRUMENT_REQUIRED("PAYMENT_INSTRUMENT_REQUIRED"),

    ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD("ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD"),

    ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED("ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HandshakeConstraintViolationExceptionReason> VALUE_MAP = EnumUtils.uniqueIndex(
            HandshakeConstraintViolationExceptionReason.class, HandshakeConstraintViolationExceptionReason::toString);

    private final String value;

    private HandshakeConstraintViolationExceptionReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HandshakeConstraintViolationExceptionReason corresponding to the value
     */
    public static HandshakeConstraintViolationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HandshakeConstraintViolationExceptionReason}s
     */
    public static Set<HandshakeConstraintViolationExceptionReason> knownValues() {
        Set<HandshakeConstraintViolationExceptionReason> knownValues = EnumSet
                .allOf(HandshakeConstraintViolationExceptionReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
