/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains additional data that is needed to process a handshake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HandshakeResource implements SdkPojo, Serializable,
        ToCopyableBuilder<HandshakeResource.Builder, HandshakeResource> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(HandshakeResource::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(HandshakeResource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<HandshakeResource>> RESOURCES_FIELD = SdkField
            .<List<HandshakeResource>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(HandshakeResource::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HandshakeResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(HandshakeResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD,
            RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String type;

    private final List<HandshakeResource> resources;

    private HandshakeResource(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.resources = builder.resources;
    }

    /**
     * <p>
     * The information that is passed to the other party in the handshake. The format of the value string must match the
     * requirements of the specified type.
     * </p>
     * 
     * @return The information that is passed to the other party in the handshake. The format of the value string must
     *         match the requirements of the specified type.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The type of information being passed, specifying how the value is to be interpreted by the other party:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACCOUNT</code> - Specifies an AWS account ID number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORGANIZATION</code> - Specifies an organization ID number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the handshake.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included as
     * information about an organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as information
     * about an organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to read.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HandshakeResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of information being passed, specifying how the value is to be interpreted by the other
     *         party:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCOUNT</code> - Specifies an AWS account ID number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORGANIZATION</code> - Specifies an organization ID number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the
     *         handshake.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included
     *         as information about an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as
     *         information about an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient
     *         to read.
     *         </p>
     *         </li>
     * @see HandshakeResourceType
     */
    public final HandshakeResourceType type() {
        return HandshakeResourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of information being passed, specifying how the value is to be interpreted by the other party:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACCOUNT</code> - Specifies an AWS account ID number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORGANIZATION</code> - Specifies an organization ID number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the handshake.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included as
     * information about an organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as information
     * about an organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to read.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HandshakeResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of information being passed, specifying how the value is to be interpreted by the other
     *         party:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCOUNT</code> - Specifies an AWS account ID number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORGANIZATION</code> - Specifies an organization ID number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the
     *         handshake.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included
     *         as information about an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as
     *         information about an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient
     *         to read.
     *         </p>
     *         </li>
     * @see HandshakeResourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When needed, contains an additional array of <code>HandshakeResource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return When needed, contains an additional array of <code>HandshakeResource</code> objects.
     */
    public final List<HandshakeResource> resources() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeResource)) {
            return false;
        }
        HandshakeResource other = (HandshakeResource) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HandshakeResource").add("Value", value() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString()).add("Resources", hasResources() ? resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HandshakeResource, T> g) {
        return obj -> g.apply((HandshakeResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HandshakeResource> {
        /**
         * <p>
         * The information that is passed to the other party in the handshake. The format of the value string must match
         * the requirements of the specified type.
         * </p>
         * 
         * @param value
         *        The information that is passed to the other party in the handshake. The format of the value string
         *        must match the requirements of the specified type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The type of information being passed, specifying how the value is to be interpreted by the other party:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACCOUNT</code> - Specifies an AWS account ID number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORGANIZATION</code> - Specifies an organization ID number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the
         * handshake.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included as
         * information about an organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as information
         * about an organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to
         * read.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of information being passed, specifying how the value is to be interpreted by the other
         *        party:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCOUNT</code> - Specifies an AWS account ID number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORGANIZATION</code> - Specifies an organization ID number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the
         *        handshake.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account.
         *        Included as information about an organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as
         *        information about an organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the
         *        recipient to read.
         *        </p>
         *        </li>
         * @see HandshakeResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of information being passed, specifying how the value is to be interpreted by the other party:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACCOUNT</code> - Specifies an AWS account ID number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORGANIZATION</code> - Specifies an organization ID number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the
         * handshake.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included as
         * information about an organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as information
         * about an organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to
         * read.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of information being passed, specifying how the value is to be interpreted by the other
         *        party:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCOUNT</code> - Specifies an AWS account ID number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORGANIZATION</code> - Specifies an organization ID number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the
         *        handshake.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account.
         *        Included as information about an organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as
         *        information about an organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the
         *        recipient to read.
         *        </p>
         *        </li>
         * @see HandshakeResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeResourceType
         */
        Builder type(HandshakeResourceType type);

        /**
         * <p>
         * When needed, contains an additional array of <code>HandshakeResource</code> objects.
         * </p>
         * 
         * @param resources
         *        When needed, contains an additional array of <code>HandshakeResource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<HandshakeResource> resources);

        /**
         * <p>
         * When needed, contains an additional array of <code>HandshakeResource</code> objects.
         * </p>
         * 
         * @param resources
         *        When needed, contains an additional array of <code>HandshakeResource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(HandshakeResource... resources);

        /**
         * <p>
         * When needed, contains an additional array of <code>HandshakeResource</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HandshakeResource>.Builder} avoiding the
         * need to create one manually via {@link List<HandshakeResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HandshakeResource>.Builder#build()} is called immediately
         * and its result is passed to {@link #resources(List<HandshakeResource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link List<HandshakeResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(List<HandshakeResource>)
         */
        Builder resources(Consumer<Builder>... resources);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String type;

        private List<HandshakeResource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeResource model) {
            value(model.value);
            type(model.type);
            resources(model.resources);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(HandshakeResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Builder> getResources() {
            List<Builder> result = HandshakeResourcesCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<BuilderImpl> resources) {
            this.resources = HandshakeResourcesCopier.copyFromBuilder(resources);
        }

        @Override
        @Transient
        public final Builder resources(Collection<HandshakeResource> resources) {
            this.resources = HandshakeResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(HandshakeResource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(Consumer<Builder>... resources) {
            resources(Stream.of(resources).map(c -> HandshakeResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public HandshakeResource build() {
            return new HandshakeResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
