/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountResponse extends OrganizationsResponse implements
        ToCopyableBuilder<DescribeAccountResponse.Builder, DescribeAccountResponse> {
    private static final SdkField<Account> ACCOUNT_FIELD = SdkField.<Account> builder(MarshallingType.SDK_POJO)
            .memberName("Account").getter(getter(DescribeAccountResponse::account)).setter(setter(Builder::account))
            .constructor(Account::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD));

    private final Account account;

    private DescribeAccountResponse(BuilderImpl builder) {
        super(builder);
        this.account = builder.account;
    }

    /**
     * <p>
     * A structure that contains information about the requested account.
     * </p>
     * 
     * @return A structure that contains information about the requested account.
     */
    public final Account account() {
        return account;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(account());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountResponse)) {
            return false;
        }
        DescribeAccountResponse other = (DescribeAccountResponse) obj;
        return Objects.equals(account(), other.account());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountResponse").add("Account", account()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountResponse, T> g) {
        return obj -> g.apply((DescribeAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccountResponse> {
        /**
         * <p>
         * A structure that contains information about the requested account.
         * </p>
         * 
         * @param account
         *        A structure that contains information about the requested account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(Account account);

        /**
         * <p>
         * A structure that contains information about the requested account.
         * </p>
         * This is a convenience method that creates an instance of the {@link Account.Builder} avoiding the need to
         * create one manually via {@link Account#builder()}.
         *
         * When the {@link Consumer} completes, {@link Account.Builder#build()} is called immediately and its result is
         * passed to {@link #account(Account)}.
         * 
         * @param account
         *        a consumer that will call methods on {@link Account.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #account(Account)
         */
        default Builder account(Consumer<Account.Builder> account) {
            return account(Account.builder().applyMutation(account).build());
        }
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private Account account;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountResponse model) {
            super(model);
            account(model.account);
        }

        public final Account.Builder getAccount() {
            return account != null ? account.toBuilder() : null;
        }

        public final void setAccount(Account.BuilderImpl account) {
            this.account = account != null ? account.build() : null;
        }

        @Override
        public final Builder account(Account account) {
            this.account = account;
            return this;
        }

        @Override
        public DescribeAccountResponse build() {
            return new DescribeAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
