/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEffectivePolicyResponse extends OrganizationsResponse implements
        ToCopyableBuilder<DescribeEffectivePolicyResponse.Builder, DescribeEffectivePolicyResponse> {
    private static final SdkField<EffectivePolicy> EFFECTIVE_POLICY_FIELD = SdkField
            .<EffectivePolicy> builder(MarshallingType.SDK_POJO).memberName("EffectivePolicy")
            .getter(getter(DescribeEffectivePolicyResponse::effectivePolicy)).setter(setter(Builder::effectivePolicy))
            .constructor(EffectivePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectivePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_POLICY_FIELD));

    private final EffectivePolicy effectivePolicy;

    private DescribeEffectivePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.effectivePolicy = builder.effectivePolicy;
    }

    /**
     * <p>
     * The contents of the effective policy.
     * </p>
     * 
     * @return The contents of the effective policy.
     */
    public final EffectivePolicy effectivePolicy() {
        return effectivePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(effectivePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEffectivePolicyResponse)) {
            return false;
        }
        DescribeEffectivePolicyResponse other = (DescribeEffectivePolicyResponse) obj;
        return Objects.equals(effectivePolicy(), other.effectivePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEffectivePolicyResponse").add("EffectivePolicy", effectivePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EffectivePolicy":
            return Optional.ofNullable(clazz.cast(effectivePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEffectivePolicyResponse, T> g) {
        return obj -> g.apply((DescribeEffectivePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEffectivePolicyResponse> {
        /**
         * <p>
         * The contents of the effective policy.
         * </p>
         * 
         * @param effectivePolicy
         *        The contents of the effective policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectivePolicy(EffectivePolicy effectivePolicy);

        /**
         * <p>
         * The contents of the effective policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link EffectivePolicy.Builder} avoiding the
         * need to create one manually via {@link EffectivePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link EffectivePolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #effectivePolicy(EffectivePolicy)}.
         * 
         * @param effectivePolicy
         *        a consumer that will call methods on {@link EffectivePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #effectivePolicy(EffectivePolicy)
         */
        default Builder effectivePolicy(Consumer<EffectivePolicy.Builder> effectivePolicy) {
            return effectivePolicy(EffectivePolicy.builder().applyMutation(effectivePolicy).build());
        }
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private EffectivePolicy effectivePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEffectivePolicyResponse model) {
            super(model);
            effectivePolicy(model.effectivePolicy);
        }

        public final EffectivePolicy.Builder getEffectivePolicy() {
            return effectivePolicy != null ? effectivePolicy.toBuilder() : null;
        }

        public final void setEffectivePolicy(EffectivePolicy.BuilderImpl effectivePolicy) {
            this.effectivePolicy = effectivePolicy != null ? effectivePolicy.build() : null;
        }

        @Override
        public final Builder effectivePolicy(EffectivePolicy effectivePolicy) {
            this.effectivePolicy = effectivePolicy;
            return this;
        }

        @Override
        public DescribeEffectivePolicyResponse build() {
            return new DescribeEffectivePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
