/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InviteAccountToOrganizationRequest extends OrganizationsRequest implements
        ToCopyableBuilder<InviteAccountToOrganizationRequest.Builder, InviteAccountToOrganizationRequest> {
    private static final SdkField<HandshakeParty> TARGET_FIELD = SdkField.<HandshakeParty> builder(MarshallingType.SDK_POJO)
            .memberName("Target").getter(getter(InviteAccountToOrganizationRequest::target)).setter(setter(Builder::target))
            .constructor(HandshakeParty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(InviteAccountToOrganizationRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(InviteAccountToOrganizationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, NOTES_FIELD,
            TAGS_FIELD));

    private final HandshakeParty target;

    private final String notes;

    private final List<Tag> tags;

    private InviteAccountToOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.target = builder.target;
        this.notes = builder.notes;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization. This is
     * a JSON object that contains the following elements:
     * </p>
     * <p>
     * <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
     * </p>
     * <p>
     * If you use the CLI, you can submit this as a single string, similar to the following example:
     * </p>
     * <p>
     * <code>--target Id=123456789012,Type=ACCOUNT</code>
     * </p>
     * <p>
     * If you specify <code>"Type": "ACCOUNT"</code>, you must provide the Amazon Web Services account ID number as the
     * <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is
     * associated with the account.
     * </p>
     * <p>
     * <code>--target Id=diego@example.com,Type=EMAIL</code>
     * </p>
     * 
     * @return The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization.
     *         This is a JSON object that contains the following elements:</p>
     *         <p>
     *         <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
     *         </p>
     *         <p>
     *         If you use the CLI, you can submit this as a single string, similar to the following example:
     *         </p>
     *         <p>
     *         <code>--target Id=123456789012,Type=ACCOUNT</code>
     *         </p>
     *         <p>
     *         If you specify <code>"Type": "ACCOUNT"</code>, you must provide the Amazon Web Services account ID number
     *         as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address
     *         that is associated with the account.
     *         </p>
     *         <p>
     *         <code>--target Id=diego@example.com,Type=EMAIL</code>
     */
    public final HandshakeParty target() {
        return target;
    }

    /**
     * <p>
     * Additional information that you want to include in the generated email to the recipient account owner.
     * </p>
     * 
     * @return Additional information that you want to include in the generated email to the recipient account owner.
     */
    public final String notes() {
        return notes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that you want to attach to the account when it becomes a member of the organization. For each tag
     * in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't
     * set it to <code>null</code>. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     * resources</a> in the Organizations User Guide.
     * </p>
     * <important>
     * <p>
     * Any tags in the request are checked for compliance with any applicable tag policies when the request is made. The
     * request is rejected if the tags in the request don't match the requirements of the policy at that time. Tag
     * policy compliance is <i> <b>not</b> </i> checked again when the invitation is accepted and the tags are actually
     * attached to the account. That means that if the tag policy changes between the invitation and the acceptance,
     * then that tags could potentially be non-compliant.
     * </p>
     * </important> <note>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire
     * request fails and invitations are not sent.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that you want to attach to the account when it becomes a member of the organization. For
     *         each tag in the list, you must specify both a tag key and a value. You can set the value to an empty
     *         string, but you can't set it to <code>null</code>. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     *         resources</a> in the Organizations User Guide.</p> <important>
     *         <p>
     *         Any tags in the request are checked for compliance with any applicable tag policies when the request is
     *         made. The request is rejected if the tags in the request don't match the requirements of the policy at
     *         that time. Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is accepted and
     *         the tags are actually attached to the account. That means that if the tag policy changes between the
     *         invitation and the acceptance, then that tags could potentially be non-compliant.
     *         </p>
     *         </important> <note>
     *         <p>
     *         If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the
     *         entire request fails and invitations are not sent.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InviteAccountToOrganizationRequest)) {
            return false;
        }
        InviteAccountToOrganizationRequest other = (InviteAccountToOrganizationRequest) obj;
        return Objects.equals(target(), other.target()) && Objects.equals(notes(), other.notes()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InviteAccountToOrganizationRequest").add("Target", target())
                .add("Notes", notes() == null ? null : "*** Sensitive Data Redacted ***").add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InviteAccountToOrganizationRequest, T> g) {
        return obj -> g.apply((InviteAccountToOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InviteAccountToOrganizationRequest> {
        /**
         * <p>
         * The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization.
         * This is a JSON object that contains the following elements:
         * </p>
         * <p>
         * <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
         * </p>
         * <p>
         * If you use the CLI, you can submit this as a single string, similar to the following example:
         * </p>
         * <p>
         * <code>--target Id=123456789012,Type=ACCOUNT</code>
         * </p>
         * <p>
         * If you specify <code>"Type": "ACCOUNT"</code>, you must provide the Amazon Web Services account ID number as
         * the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is
         * associated with the account.
         * </p>
         * <p>
         * <code>--target Id=diego@example.com,Type=EMAIL</code>
         * </p>
         * 
         * @param target
         *        The identifier (ID) of the Amazon Web Services account that you want to invite to join your
         *        organization. This is a JSON object that contains the following elements:</p>
         *        <p>
         *        <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
         *        </p>
         *        <p>
         *        If you use the CLI, you can submit this as a single string, similar to the following example:
         *        </p>
         *        <p>
         *        <code>--target Id=123456789012,Type=ACCOUNT</code>
         *        </p>
         *        <p>
         *        If you specify <code>"Type": "ACCOUNT"</code>, you must provide the Amazon Web Services account ID
         *        number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email
         *        address that is associated with the account.
         *        </p>
         *        <p>
         *        <code>--target Id=diego@example.com,Type=EMAIL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(HandshakeParty target);

        /**
         * <p>
         * The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization.
         * This is a JSON object that contains the following elements:
         * </p>
         * <p>
         * <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
         * </p>
         * <p>
         * If you use the CLI, you can submit this as a single string, similar to the following example:
         * </p>
         * <p>
         * <code>--target Id=123456789012,Type=ACCOUNT</code>
         * </p>
         * <p>
         * If you specify <code>"Type": "ACCOUNT"</code>, you must provide the Amazon Web Services account ID number as
         * the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is
         * associated with the account.
         * </p>
         * <p>
         * <code>--target Id=diego@example.com,Type=EMAIL</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link HandshakeParty.Builder} avoiding the need
         * to create one manually via {@link HandshakeParty#builder()}.
         *
         * When the {@link Consumer} completes, {@link HandshakeParty.Builder#build()} is called immediately and its
         * result is passed to {@link #target(HandshakeParty)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link HandshakeParty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(HandshakeParty)
         */
        default Builder target(Consumer<HandshakeParty.Builder> target) {
            return target(HandshakeParty.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * Additional information that you want to include in the generated email to the recipient account owner.
         * </p>
         * 
         * @param notes
         *        Additional information that you want to include in the generated email to the recipient account owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * A list of tags that you want to attach to the account when it becomes a member of the organization. For each
         * tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but
         * you can't set it to <code>null</code>. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
         * resources</a> in the Organizations User Guide.
         * </p>
         * <important>
         * <p>
         * Any tags in the request are checked for compliance with any applicable tag policies when the request is made.
         * The request is rejected if the tags in the request don't match the requirements of the policy at that time.
         * Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is accepted and the tags are
         * actually attached to the account. That means that if the tag policy changes between the invitation and the
         * acceptance, then that tags could potentially be non-compliant.
         * </p>
         * </important> <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire
         * request fails and invitations are not sent.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the account when it becomes a member of the organization.
         *        For each tag in the list, you must specify both a tag key and a value. You can set the value to an
         *        empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging
         *        Organizations resources</a> in the Organizations User Guide.</p> <important>
         *        <p>
         *        Any tags in the request are checked for compliance with any applicable tag policies when the request
         *        is made. The request is rejected if the tags in the request don't match the requirements of the policy
         *        at that time. Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is
         *        accepted and the tags are actually attached to the account. That means that if the tag policy changes
         *        between the invitation and the acceptance, then that tags could potentially be non-compliant.
         *        </p>
         *        </important> <note>
         *        <p>
         *        If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the
         *        entire request fails and invitations are not sent.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that you want to attach to the account when it becomes a member of the organization. For each
         * tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but
         * you can't set it to <code>null</code>. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
         * resources</a> in the Organizations User Guide.
         * </p>
         * <important>
         * <p>
         * Any tags in the request are checked for compliance with any applicable tag policies when the request is made.
         * The request is rejected if the tags in the request don't match the requirements of the policy at that time.
         * Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is accepted and the tags are
         * actually attached to the account. That means that if the tag policy changes between the invitation and the
         * acceptance, then that tags could potentially be non-compliant.
         * </p>
         * </important> <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire
         * request fails and invitations are not sent.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the account when it becomes a member of the organization.
         *        For each tag in the list, you must specify both a tag key and a value. You can set the value to an
         *        empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging
         *        Organizations resources</a> in the Organizations User Guide.</p> <important>
         *        <p>
         *        Any tags in the request are checked for compliance with any applicable tag policies when the request
         *        is made. The request is rejected if the tags in the request don't match the requirements of the policy
         *        at that time. Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is
         *        accepted and the tags are actually attached to the account. That means that if the tag policy changes
         *        between the invitation and the acceptance, then that tags could potentially be non-compliant.
         *        </p>
         *        </important> <note>
         *        <p>
         *        If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the
         *        entire request fails and invitations are not sent.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that you want to attach to the account when it becomes a member of the organization. For each
         * tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but
         * you can't set it to <code>null</code>. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
         * resources</a> in the Organizations User Guide.
         * </p>
         * <important>
         * <p>
         * Any tags in the request are checked for compliance with any applicable tag policies when the request is made.
         * The request is rejected if the tags in the request don't match the requirements of the policy at that time.
         * Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is accepted and the tags are
         * actually attached to the account. That means that if the tag policy changes between the invitation and the
         * acceptance, then that tags could potentially be non-compliant.
         * </p>
         * </important> <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire
         * request fails and invitations are not sent.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the
         * need to create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private HandshakeParty target;

        private String notes;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InviteAccountToOrganizationRequest model) {
            super(model);
            target(model.target);
            notes(model.notes);
            tags(model.tags);
        }

        public final HandshakeParty.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(HandshakeParty.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(HandshakeParty target) {
            this.target = target;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InviteAccountToOrganizationRequest build() {
            return new InviteAccountToOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
