/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.DelegatedService;
import software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse;

public class ListDelegatedServicesForAccountIterable
implements SdkIterable<ListDelegatedServicesForAccountResponse> {
    private final OrganizationsClient client;
    private final ListDelegatedServicesForAccountRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDelegatedServicesForAccountIterable(OrganizationsClient client, ListDelegatedServicesForAccountRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDelegatedServicesForAccountResponseFetcher();
    }

    public Iterator<ListDelegatedServicesForAccountResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DelegatedService> delegatedServices() {
        Function<ListDelegatedServicesForAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.delegatedServices() != null) {
                return response.delegatedServices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDelegatedServicesForAccountResponseFetcher
    implements SyncPageFetcher<ListDelegatedServicesForAccountResponse> {
        private ListDelegatedServicesForAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListDelegatedServicesForAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDelegatedServicesForAccountResponse nextPage(ListDelegatedServicesForAccountResponse previousPage) {
            if (previousPage == null) {
                return ListDelegatedServicesForAccountIterable.this.client.listDelegatedServicesForAccount(ListDelegatedServicesForAccountIterable.this.firstRequest);
            }
            return ListDelegatedServicesForAccountIterable.this.client.listDelegatedServicesForAccount((ListDelegatedServicesForAccountRequest)((Object)ListDelegatedServicesForAccountIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

