/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MoveAccountRequest extends OrganizationsRequest implements
        ToCopyableBuilder<MoveAccountRequest.Builder, MoveAccountRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(MoveAccountRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> SOURCE_PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceParentId").getter(getter(MoveAccountRequest::sourceParentId))
            .setter(setter(Builder::sourceParentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParentId").build()).build();

    private static final SdkField<String> DESTINATION_PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationParentId").getter(getter(MoveAccountRequest::destinationParentId))
            .setter(setter(Builder::destinationParentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationParentId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            SOURCE_PARENT_ID_FIELD, DESTINATION_PARENT_ID_FIELD));

    private final String accountId;

    private final String sourceParentId;

    private final String destinationParentId;

    private MoveAccountRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.sourceParentId = builder.sourceParentId;
        this.destinationParentId = builder.destinationParentId;
    }

    /**
     * <p>
     * The unique identifier (ID) of the account that you want to move.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
     * digits.
     * </p>
     * 
     * @return The unique identifier (ID) of the account that you want to move.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly
     *         12 digits.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The unique identifier (ID) of the root or organizational unit that you want to move the account from.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or
     * digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32
     * additional lowercase letters or digits.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The unique identifier (ID) of the root or organizational unit that you want to move the account from.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of
     *         the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase
     *         letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash
     *         and from 8 to 32 additional lowercase letters or digits.
     *         </p>
     *         </li>
     */
    public final String sourceParentId() {
        return sourceParentId;
    }

    /**
     * <p>
     * The unique identifier (ID) of the root or organizational unit that you want to move the account to.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or
     * digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32
     * additional lowercase letters or digits.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The unique identifier (ID) of the root or organizational unit that you want to move the account to.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of
     *         the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase
     *         letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash
     *         and from 8 to 32 additional lowercase letters or digits.
     *         </p>
     *         </li>
     */
    public final String destinationParentId() {
        return destinationParentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceParentId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationParentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveAccountRequest)) {
            return false;
        }
        MoveAccountRequest other = (MoveAccountRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(sourceParentId(), other.sourceParentId())
                && Objects.equals(destinationParentId(), other.destinationParentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MoveAccountRequest").add("AccountId", accountId()).add("SourceParentId", sourceParentId())
                .add("DestinationParentId", destinationParentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "SourceParentId":
            return Optional.ofNullable(clazz.cast(sourceParentId()));
        case "DestinationParentId":
            return Optional.ofNullable(clazz.cast(destinationParentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MoveAccountRequest, T> g) {
        return obj -> g.apply((MoveAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, MoveAccountRequest> {
        /**
         * <p>
         * The unique identifier (ID) of the account that you want to move.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
         * digits.
         * </p>
         * 
         * @param accountId
         *        The unique identifier (ID) of the account that you want to move.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires
         *        exactly 12 digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The unique identifier (ID) of the root or organizational unit that you want to move the account from.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters
         * or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to
         * 32 additional lowercase letters or digits.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceParentId
         *        The unique identifier (ID) of the root or organizational unit that you want to move the account
         *        from.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of
         *        the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase
         *        letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash
         *        and from 8 to 32 additional lowercase letters or digits.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParentId(String sourceParentId);

        /**
         * <p>
         * The unique identifier (ID) of the root or organizational unit that you want to move the account to.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters
         * or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to
         * 32 additional lowercase letters or digits.
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationParentId
         *        The unique identifier (ID) of the root or organizational unit that you want to move the account
         *        to.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of
         *        the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase
         *        letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash
         *        and from 8 to 32 additional lowercase letters or digits.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationParentId(String destinationParentId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String accountId;

        private String sourceParentId;

        private String destinationParentId;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveAccountRequest model) {
            super(model);
            accountId(model.accountId);
            sourceParentId(model.sourceParentId);
            destinationParentId(model.destinationParentId);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getSourceParentId() {
            return sourceParentId;
        }

        public final void setSourceParentId(String sourceParentId) {
            this.sourceParentId = sourceParentId;
        }

        @Override
        public final Builder sourceParentId(String sourceParentId) {
            this.sourceParentId = sourceParentId;
            return this;
        }

        public final String getDestinationParentId() {
            return destinationParentId;
        }

        public final void setDestinationParentId(String destinationParentId) {
            this.destinationParentId = destinationParentId;
        }

        @Override
        public final Builder destinationParentId(String destinationParentId) {
            this.destinationParentId = destinationParentId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MoveAccountRequest build() {
            return new MoveAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
