/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePolicyRequest extends OrganizationsRequest implements
        ToCopyableBuilder<UpdatePolicyRequest.Builder, UpdatePolicyRequest> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(UpdatePolicyRequest::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdatePolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdatePolicyRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(UpdatePolicyRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CONTENT_FIELD));

    private final String policyId;

    private final String name;

    private final String description;

    private final String content;

    private UpdatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyId = builder.policyId;
        this.name = builder.name;
        this.description = builder.description;
        this.content = builder.content;
    }

    /**
     * <p>
     * The unique identifier (ID) of the policy that you want to update.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by
     * from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
     * </p>
     * 
     * @return The unique identifier (ID) of the policy that you want to update.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-"
     *         followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * If provided, the new name for the policy.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
     * string of any of the characters in the ASCII character range.
     * </p>
     * 
     * @return If provided, the new name for the policy.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter
     *         is a string of any of the characters in the ASCII character range.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * If provided, the new description for the policy.
     * </p>
     * 
     * @return If provided, the new description for the policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the
     * syntax for the policy's type. For more information, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html">SCP
     * syntax</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * The maximum size of a policy document depends on the policy's type. For more information, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values"
     * >Maximum and minimum values</a> in the <i>Organizations User Guide</i>.
     * </p>
     * 
     * @return If provided, the new content for the policy. The text must be correctly formatted JSON that complies with
     *         the syntax for the policy's type. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html"
     *         >SCP syntax</a> in the <i>Organizations User Guide</i>.</p>
     *         <p>
     *         The maximum size of a policy document depends on the policy's type. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values"
     *         >Maximum and minimum values</a> in the <i>Organizations User Guide</i>.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePolicyRequest)) {
            return false;
        }
        UpdatePolicyRequest other = (UpdatePolicyRequest) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePolicyRequest").add("PolicyId", policyId()).add("Name", name())
                .add("Description", description()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePolicyRequest, T> g) {
        return obj -> g.apply((UpdatePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePolicyRequest> {
        /**
         * <p>
         * The unique identifier (ID) of the policy that you want to update.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
         * by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
         * </p>
         * 
         * @param policyId
         *        The unique identifier (ID) of the policy that you want to update.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-"
         *        followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * If provided, the new name for the policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
         * string of any of the characters in the ASCII character range.
         * </p>
         * 
         * @param name
         *        If provided, the new name for the policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this
         *        parameter is a string of any of the characters in the ASCII character range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If provided, the new description for the policy.
         * </p>
         * 
         * @param description
         *        If provided, the new description for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the
         * syntax for the policy's type. For more information, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html">SCP
         * syntax</a> in the <i>Organizations User Guide</i>.
         * </p>
         * <p>
         * The maximum size of a policy document depends on the policy's type. For more information, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values"
         * >Maximum and minimum values</a> in the <i>Organizations User Guide</i>.
         * </p>
         * 
         * @param content
         *        If provided, the new content for the policy. The text must be correctly formatted JSON that complies
         *        with the syntax for the policy's type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html">SCP
         *        syntax</a> in the <i>Organizations User Guide</i>.</p>
         *        <p>
         *        The maximum size of a policy document depends on the policy's type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values"
         *        >Maximum and minimum values</a> in the <i>Organizations User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String policyId;

        private String name;

        private String description;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePolicyRequest model) {
            super(model);
            policyId(model.policyId);
            name(model.name);
            description(model.description);
            content(model.content);
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePolicyRequest build() {
            return new UpdatePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
