/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOrganizationRequest extends OrganizationsRequest implements
        ToCopyableBuilder<CreateOrganizationRequest.Builder, CreateOrganizationRequest> {
    private static final SdkField<String> FEATURE_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureSet").getter(getter(CreateOrganizationRequest::featureSetAsString))
            .setter(setter(Builder::featureSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String featureSet;

    private CreateOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.featureSet = builder.featureSet;
    }

    /**
     * <p>
     * Specifies the feature set supported by the new organization. Each feature set supports different levels of
     * functionality.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the
     * management account. For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only"
     * >Consolidated billing</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * The consolidated billing feature subset isn't available for organizations in the Amazon Web Services GovCloud
     * (US) Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the
     * management account can also apply any policy type to any member account in the organization. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all"
     * >All features</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link OrganizationFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Specifies the feature set supported by the new organization. Each feature set supports different levels
     *         of functionality.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the
     *         management account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only"
     *         >Consolidated billing</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         <p>
     *         The consolidated billing feature subset isn't available for organizations in the Amazon Web Services
     *         GovCloud (US) Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the
     *         management account can also apply any policy type to any member account in the organization. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all"
     *         >All features</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     * @see OrganizationFeatureSet
     */
    public final OrganizationFeatureSet featureSet() {
        return OrganizationFeatureSet.fromValue(featureSet);
    }

    /**
     * <p>
     * Specifies the feature set supported by the new organization. Each feature set supports different levels of
     * functionality.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the
     * management account. For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only"
     * >Consolidated billing</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * The consolidated billing feature subset isn't available for organizations in the Amazon Web Services GovCloud
     * (US) Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the
     * management account can also apply any policy type to any member account in the organization. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all"
     * >All features</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link OrganizationFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Specifies the feature set supported by the new organization. Each feature set supports different levels
     *         of functionality.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the
     *         management account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only"
     *         >Consolidated billing</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         <p>
     *         The consolidated billing feature subset isn't available for organizations in the Amazon Web Services
     *         GovCloud (US) Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the
     *         management account can also apply any policy type to any member account in the organization. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all"
     *         >All features</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     * @see OrganizationFeatureSet
     */
    public final String featureSetAsString() {
        return featureSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureSetAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOrganizationRequest)) {
            return false;
        }
        CreateOrganizationRequest other = (CreateOrganizationRequest) obj;
        return Objects.equals(featureSetAsString(), other.featureSetAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOrganizationRequest").add("FeatureSet", featureSetAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureSet":
            return Optional.ofNullable(clazz.cast(featureSetAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FeatureSet", FEATURE_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOrganizationRequest, T> g) {
        return obj -> g.apply((CreateOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOrganizationRequest> {
        /**
         * <p>
         * Specifies the feature set supported by the new organization. Each feature set supports different levels of
         * functionality.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the
         * management account. For more information, see <a href=
         * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only"
         * >Consolidated billing</a> in the <i>Organizations User Guide</i>.
         * </p>
         * <p>
         * The consolidated billing feature subset isn't available for organizations in the Amazon Web Services GovCloud
         * (US) Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the
         * management account can also apply any policy type to any member account in the organization. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all"
         * >All features</a> in the <i>Organizations User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param featureSet
         *        Specifies the feature set supported by the new organization. Each feature set supports different
         *        levels of functionality.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by
         *        the management account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only"
         *        >Consolidated billing</a> in the <i>Organizations User Guide</i>.
         *        </p>
         *        <p>
         *        The consolidated billing feature subset isn't available for organizations in the Amazon Web Services
         *        GovCloud (US) Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set,
         *        the management account can also apply any policy type to any member account in the organization. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all"
         *        >All features</a> in the <i>Organizations User Guide</i>.
         *        </p>
         *        </li>
         * @see OrganizationFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationFeatureSet
         */
        Builder featureSet(String featureSet);

        /**
         * <p>
         * Specifies the feature set supported by the new organization. Each feature set supports different levels of
         * functionality.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the
         * management account. For more information, see <a href=
         * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only"
         * >Consolidated billing</a> in the <i>Organizations User Guide</i>.
         * </p>
         * <p>
         * The consolidated billing feature subset isn't available for organizations in the Amazon Web Services GovCloud
         * (US) Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the
         * management account can also apply any policy type to any member account in the organization. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all"
         * >All features</a> in the <i>Organizations User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param featureSet
         *        Specifies the feature set supported by the new organization. Each feature set supports different
         *        levels of functionality.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by
         *        the management account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only"
         *        >Consolidated billing</a> in the <i>Organizations User Guide</i>.
         *        </p>
         *        <p>
         *        The consolidated billing feature subset isn't available for organizations in the Amazon Web Services
         *        GovCloud (US) Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set,
         *        the management account can also apply any policy type to any member account in the organization. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all"
         *        >All features</a> in the <i>Organizations User Guide</i>.
         *        </p>
         *        </li>
         * @see OrganizationFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationFeatureSet
         */
        Builder featureSet(OrganizationFeatureSet featureSet);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String featureSet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOrganizationRequest model) {
            super(model);
            featureSet(model.featureSet);
        }

        public final String getFeatureSet() {
            return featureSet;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(OrganizationFeatureSet featureSet) {
            this.featureSet(featureSet == null ? null : featureSet.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOrganizationRequest build() {
            return new CreateOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
