/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the delegated administrator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DelegatedAdministrator implements SdkPojo, Serializable,
        ToCopyableBuilder<DelegatedAdministrator.Builder, DelegatedAdministrator> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DelegatedAdministrator::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DelegatedAdministrator::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(DelegatedAdministrator::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DelegatedAdministrator::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DelegatedAdministrator::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> JOINED_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JoinedMethod").getter(getter(DelegatedAdministrator::joinedMethodAsString))
            .setter(setter(Builder::joinedMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinedMethod").build()).build();

    private static final SdkField<Instant> JOINED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JoinedTimestamp").getter(getter(DelegatedAdministrator::joinedTimestamp))
            .setter(setter(Builder::joinedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinedTimestamp").build()).build();

    private static final SdkField<Instant> DELEGATION_ENABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DelegationEnabledDate").getter(getter(DelegatedAdministrator::delegationEnabledDate))
            .setter(setter(Builder::delegationEnabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationEnabledDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            EMAIL_FIELD, NAME_FIELD, STATUS_FIELD, JOINED_METHOD_FIELD, JOINED_TIMESTAMP_FIELD, DELEGATION_ENABLED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String email;

    private final String name;

    private final String status;

    private final String joinedMethod;

    private final Instant joinedTimestamp;

    private final Instant delegationEnabledDate;

    private DelegatedAdministrator(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.email = builder.email;
        this.name = builder.name;
        this.status = builder.status;
        this.joinedMethod = builder.joinedMethod;
        this.joinedTimestamp = builder.joinedTimestamp;
        this.delegationEnabledDate = builder.delegationEnabledDate;
    }

    /**
     * <p>
     * The unique identifier (ID) of the delegated administrator's account.
     * </p>
     * 
     * @return The unique identifier (ID) of the delegated administrator's account.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the delegated administrator's account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the delegated administrator's account.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The email address that is associated with the delegated administrator's Amazon Web Services account.
     * </p>
     * 
     * @return The email address that is associated with the delegated administrator's Amazon Web Services account.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The friendly name of the delegated administrator's account.
     * </p>
     * 
     * @return The friendly name of the delegated administrator's account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the delegated administrator's account in the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the delegated administrator's account in the organization.
     * @see AccountStatus
     */
    public final AccountStatus status() {
        return AccountStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the delegated administrator's account in the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the delegated administrator's account in the organization.
     * @see AccountStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The method by which the delegated administrator's account joined the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #joinedMethod} will
     * return {@link AccountJoinedMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #joinedMethodAsString}.
     * </p>
     * 
     * @return The method by which the delegated administrator's account joined the organization.
     * @see AccountJoinedMethod
     */
    public final AccountJoinedMethod joinedMethod() {
        return AccountJoinedMethod.fromValue(joinedMethod);
    }

    /**
     * <p>
     * The method by which the delegated administrator's account joined the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #joinedMethod} will
     * return {@link AccountJoinedMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #joinedMethodAsString}.
     * </p>
     * 
     * @return The method by which the delegated administrator's account joined the organization.
     * @see AccountJoinedMethod
     */
    public final String joinedMethodAsString() {
        return joinedMethod;
    }

    /**
     * <p>
     * The date when the delegated administrator's account became a part of the organization.
     * </p>
     * 
     * @return The date when the delegated administrator's account became a part of the organization.
     */
    public final Instant joinedTimestamp() {
        return joinedTimestamp;
    }

    /**
     * <p>
     * The date when the account was made a delegated administrator.
     * </p>
     * 
     * @return The date when the account was made a delegated administrator.
     */
    public final Instant delegationEnabledDate() {
        return delegationEnabledDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(joinedMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(joinedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(delegationEnabledDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegatedAdministrator)) {
            return false;
        }
        DelegatedAdministrator other = (DelegatedAdministrator) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(email(), other.email())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(joinedMethodAsString(), other.joinedMethodAsString())
                && Objects.equals(joinedTimestamp(), other.joinedTimestamp())
                && Objects.equals(delegationEnabledDate(), other.delegationEnabledDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DelegatedAdministrator").add("Id", id()).add("Arn", arn())
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("JoinedMethod", joinedMethodAsString()).add("JoinedTimestamp", joinedTimestamp())
                .add("DelegationEnabledDate", delegationEnabledDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "JoinedMethod":
            return Optional.ofNullable(clazz.cast(joinedMethodAsString()));
        case "JoinedTimestamp":
            return Optional.ofNullable(clazz.cast(joinedTimestamp()));
        case "DelegationEnabledDate":
            return Optional.ofNullable(clazz.cast(delegationEnabledDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("JoinedMethod", JOINED_METHOD_FIELD);
        map.put("JoinedTimestamp", JOINED_TIMESTAMP_FIELD);
        map.put("DelegationEnabledDate", DELEGATION_ENABLED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DelegatedAdministrator, T> g) {
        return obj -> g.apply((DelegatedAdministrator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DelegatedAdministrator> {
        /**
         * <p>
         * The unique identifier (ID) of the delegated administrator's account.
         * </p>
         * 
         * @param id
         *        The unique identifier (ID) of the delegated administrator's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the delegated administrator's account.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the delegated administrator's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The email address that is associated with the delegated administrator's Amazon Web Services account.
         * </p>
         * 
         * @param email
         *        The email address that is associated with the delegated administrator's Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The friendly name of the delegated administrator's account.
         * </p>
         * 
         * @param name
         *        The friendly name of the delegated administrator's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the delegated administrator's account in the organization.
         * </p>
         * 
         * @param status
         *        The status of the delegated administrator's account in the organization.
         * @see AccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the delegated administrator's account in the organization.
         * </p>
         * 
         * @param status
         *        The status of the delegated administrator's account in the organization.
         * @see AccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountStatus
         */
        Builder status(AccountStatus status);

        /**
         * <p>
         * The method by which the delegated administrator's account joined the organization.
         * </p>
         * 
         * @param joinedMethod
         *        The method by which the delegated administrator's account joined the organization.
         * @see AccountJoinedMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountJoinedMethod
         */
        Builder joinedMethod(String joinedMethod);

        /**
         * <p>
         * The method by which the delegated administrator's account joined the organization.
         * </p>
         * 
         * @param joinedMethod
         *        The method by which the delegated administrator's account joined the organization.
         * @see AccountJoinedMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountJoinedMethod
         */
        Builder joinedMethod(AccountJoinedMethod joinedMethod);

        /**
         * <p>
         * The date when the delegated administrator's account became a part of the organization.
         * </p>
         * 
         * @param joinedTimestamp
         *        The date when the delegated administrator's account became a part of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinedTimestamp(Instant joinedTimestamp);

        /**
         * <p>
         * The date when the account was made a delegated administrator.
         * </p>
         * 
         * @param delegationEnabledDate
         *        The date when the account was made a delegated administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationEnabledDate(Instant delegationEnabledDate);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String email;

        private String name;

        private String status;

        private String joinedMethod;

        private Instant joinedTimestamp;

        private Instant delegationEnabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegatedAdministrator model) {
            id(model.id);
            arn(model.arn);
            email(model.email);
            name(model.name);
            status(model.status);
            joinedMethod(model.joinedMethod);
            joinedTimestamp(model.joinedTimestamp);
            delegationEnabledDate(model.delegationEnabledDate);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccountStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getJoinedMethod() {
            return joinedMethod;
        }

        public final void setJoinedMethod(String joinedMethod) {
            this.joinedMethod = joinedMethod;
        }

        @Override
        public final Builder joinedMethod(String joinedMethod) {
            this.joinedMethod = joinedMethod;
            return this;
        }

        @Override
        public final Builder joinedMethod(AccountJoinedMethod joinedMethod) {
            this.joinedMethod(joinedMethod == null ? null : joinedMethod.toString());
            return this;
        }

        public final Instant getJoinedTimestamp() {
            return joinedTimestamp;
        }

        public final void setJoinedTimestamp(Instant joinedTimestamp) {
            this.joinedTimestamp = joinedTimestamp;
        }

        @Override
        public final Builder joinedTimestamp(Instant joinedTimestamp) {
            this.joinedTimestamp = joinedTimestamp;
            return this;
        }

        public final Instant getDelegationEnabledDate() {
            return delegationEnabledDate;
        }

        public final void setDelegationEnabledDate(Instant delegationEnabledDate) {
            this.delegationEnabledDate = delegationEnabledDate;
        }

        @Override
        public final Builder delegationEnabledDate(Instant delegationEnabledDate) {
            this.delegationEnabledDate = delegationEnabledDate;
            return this;
        }

        @Override
        public DelegatedAdministrator build() {
            return new DelegatedAdministrator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
