/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ConstraintViolationExceptionReason {
    ACCOUNT_NUMBER_LIMIT_EXCEEDED("ACCOUNT_NUMBER_LIMIT_EXCEEDED"),

    HANDSHAKE_RATE_LIMIT_EXCEEDED("HANDSHAKE_RATE_LIMIT_EXCEEDED"),

    OU_NUMBER_LIMIT_EXCEEDED("OU_NUMBER_LIMIT_EXCEEDED"),

    OU_DEPTH_LIMIT_EXCEEDED("OU_DEPTH_LIMIT_EXCEEDED"),

    POLICY_NUMBER_LIMIT_EXCEEDED("POLICY_NUMBER_LIMIT_EXCEEDED"),

    POLICY_CONTENT_LIMIT_EXCEEDED("POLICY_CONTENT_LIMIT_EXCEEDED"),

    MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED("MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED"),

    MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED("MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED"),

    ACCOUNT_CANNOT_LEAVE_ORGANIZATION("ACCOUNT_CANNOT_LEAVE_ORGANIZATION"),

    ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA("ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA"),

    ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION("ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION"),

    MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED("MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED"),

    MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED("MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED"),

    ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED("ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED"),

    MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE("MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE"),

    MASTER_ACCOUNT_MISSING_CONTACT_INFO("MASTER_ACCOUNT_MISSING_CONTACT_INFO"),

    MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED("MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED"),

    ORGANIZATION_NOT_IN_ALL_FEATURES_MODE("ORGANIZATION_NOT_IN_ALL_FEATURES_MODE"),

    CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION("CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION"),

    EMAIL_VERIFICATION_CODE_EXPIRED("EMAIL_VERIFICATION_CODE_EXPIRED"),

    WAIT_PERIOD_ACTIVE("WAIT_PERIOD_ACTIVE"),

    MAX_TAG_LIMIT_EXCEEDED("MAX_TAG_LIMIT_EXCEEDED"),

    TAG_POLICY_VIOLATION("TAG_POLICY_VIOLATION"),

    MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED("MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED"),

    CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR("CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR"),

    CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG("CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG"),

    DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE("DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE"),

    MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE("MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE"),

    CANNOT_CLOSE_MANAGEMENT_ACCOUNT("CANNOT_CLOSE_MANAGEMENT_ACCOUNT"),

    CLOSE_ACCOUNT_QUOTA_EXCEEDED("CLOSE_ACCOUNT_QUOTA_EXCEEDED"),

    CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED("CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED"),

    SERVICE_ACCESS_NOT_ENABLED("SERVICE_ACCESS_NOT_ENABLED"),

    INVALID_PAYMENT_INSTRUMENT("INVALID_PAYMENT_INSTRUMENT"),

    ACCOUNT_CREATION_NOT_COMPLETE("ACCOUNT_CREATION_NOT_COMPLETE"),

    CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR("CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR"),

    ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED("ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConstraintViolationExceptionReason> VALUE_MAP = EnumUtils.uniqueIndex(
            ConstraintViolationExceptionReason.class, ConstraintViolationExceptionReason::toString);

    private final String value;

    private ConstraintViolationExceptionReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ConstraintViolationExceptionReason corresponding to the value
     */
    public static ConstraintViolationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ConstraintViolationExceptionReason}s
     */
    public static Set<ConstraintViolationExceptionReason> knownValues() {
        Set<ConstraintViolationExceptionReason> knownValues = EnumSet.allOf(ConstraintViolationExceptionReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
