/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnablePolicyTypeResponse extends OrganizationsResponse implements
        ToCopyableBuilder<EnablePolicyTypeResponse.Builder, EnablePolicyTypeResponse> {
    private static final SdkField<Root> ROOT_FIELD = SdkField.<Root> builder(MarshallingType.SDK_POJO).memberName("Root")
            .getter(getter(EnablePolicyTypeResponse::root)).setter(setter(Builder::root)).constructor(Root::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Root").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Root root;

    private EnablePolicyTypeResponse(BuilderImpl builder) {
        super(builder);
        this.root = builder.root;
    }

    /**
     * <p>
     * A structure that shows the root with the updated list of enabled policy types.
     * </p>
     * 
     * @return A structure that shows the root with the updated list of enabled policy types.
     */
    public final Root root() {
        return root;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(root());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnablePolicyTypeResponse)) {
            return false;
        }
        EnablePolicyTypeResponse other = (EnablePolicyTypeResponse) obj;
        return Objects.equals(root(), other.root());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnablePolicyTypeResponse").add("Root", root()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Root":
            return Optional.ofNullable(clazz.cast(root()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Root", ROOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnablePolicyTypeResponse, T> g) {
        return obj -> g.apply((EnablePolicyTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo, CopyableBuilder<Builder, EnablePolicyTypeResponse> {
        /**
         * <p>
         * A structure that shows the root with the updated list of enabled policy types.
         * </p>
         * 
         * @param root
         *        A structure that shows the root with the updated list of enabled policy types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder root(Root root);

        /**
         * <p>
         * A structure that shows the root with the updated list of enabled policy types.
         * </p>
         * This is a convenience method that creates an instance of the {@link Root.Builder} avoiding the need to create
         * one manually via {@link Root#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Root.Builder#build()} is called immediately and its result is
         * passed to {@link #root(Root)}.
         * 
         * @param root
         *        a consumer that will call methods on {@link Root.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #root(Root)
         */
        default Builder root(Consumer<Root.Builder> root) {
            return root(Root.builder().applyMutation(root).build());
        }
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private Root root;

        private BuilderImpl() {
        }

        private BuilderImpl(EnablePolicyTypeResponse model) {
            super(model);
            root(model.root);
        }

        public final Root.Builder getRoot() {
            return root != null ? root.toBuilder() : null;
        }

        public final void setRoot(Root.BuilderImpl root) {
            this.root = root != null ? root.build() : null;
        }

        @Override
        public final Builder root(Root root) {
            this.root = root;
            return this;
        }

        @Override
        public EnablePolicyTypeResponse build() {
            return new EnablePolicyTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
