/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HandshakePartyType {
    ACCOUNT("ACCOUNT"),
    ORGANIZATION("ORGANIZATION"),
    EMAIL("EMAIL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HandshakePartyType> VALUE_MAP;
    private final String value;

    private HandshakePartyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandshakePartyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandshakePartyType> knownValues() {
        EnumSet<HandshakePartyType> knownValues = EnumSet.allOf(HandshakePartyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HandshakePartyType.class, HandshakePartyType::toString);
    }
}

