/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;

public class ListPoliciesForTargetIterable
implements SdkIterable<ListPoliciesForTargetResponse> {
    private final OrganizationsClient client;
    private final ListPoliciesForTargetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPoliciesForTargetIterable(OrganizationsClient client, ListPoliciesForTargetRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPoliciesForTargetResponseFetcher();
    }

    public Iterator<ListPoliciesForTargetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPoliciesForTargetResponseFetcher
    implements SyncPageFetcher<ListPoliciesForTargetResponse> {
        private ListPoliciesForTargetResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesForTargetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPoliciesForTargetResponse nextPage(ListPoliciesForTargetResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesForTargetIterable.this.client.listPoliciesForTarget(ListPoliciesForTargetIterable.this.firstRequest);
            }
            return ListPoliciesForTargetIterable.this.client.listPoliciesForTarget((ListPoliciesForTargetRequest)((Object)ListPoliciesForTargetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

