/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPoliciesForTargetRequest extends OrganizationsRequest implements
        ToCopyableBuilder<ListPoliciesForTargetRequest.Builder, ListPoliciesForTargetRequest> {
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(ListPoliciesForTargetRequest::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Filter")
            .getter(getter(ListPoliciesForTargetRequest::filterAsString)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPoliciesForTargetRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPoliciesForTargetRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ID_FIELD, FILTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetId;

    private final String filter;

    private final String nextToken;

    private final Integer maxResults;

    private ListPoliciesForTargetRequest(BuilderImpl builder) {
        super(builder);
        this.targetId = builder.targetId;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The unique identifier (ID) of the root, organizational unit, or account whose policies you want to list.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> - A string that consists of exactly 12 digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or
     * digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32
     * additional lowercase letters or digits.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The unique identifier (ID) of the root, organizational unit, or account whose policies you want to
     *         list.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of
     *         the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Account</b> - A string that consists of exactly 12 digits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase
     *         letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash
     *         and from 8 to 32 additional lowercase letters or digits.
     *         </p>
     *         </li>
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The type of policy that you want to include in the returned list. You must specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     * SERVICE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     * RESOURCE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filter} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterAsString}.
     * </p>
     * 
     * @return The type of policy that you want to include in the returned list. You must specify one of the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     *         SERVICE_CONTROL_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     *         RESOURCE_CONTROL_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
     *         >DECLARATIVE_POLICY_EC2</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     *         BACKUP_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
     *         >TAG_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     *         CHATBOT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     *         AISERVICES_OPT_OUT_POLICY</a>
     *         </p>
     *         </li>
     * @see PolicyType
     */
    public final PolicyType filter() {
        return PolicyType.fromValue(filter);
    }

    /**
     * <p>
     * The type of policy that you want to include in the returned list. You must specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     * SERVICE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     * RESOURCE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filter} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterAsString}.
     * </p>
     * 
     * @return The type of policy that you want to include in the returned list. You must specify one of the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     *         SERVICE_CONTROL_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     *         RESOURCE_CONTROL_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
     *         >DECLARATIVE_POLICY_EC2</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     *         BACKUP_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
     *         >TAG_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     *         CHATBOT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     *         AISERVICES_OPT_OUT_POLICY</a>
     *         </p>
     *         </li>
     * @see PolicyType
     */
    public final String filterAsString() {
        return filter;
    }

    /**
     * <p>
     * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
     * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
     * value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.
     * </p>
     * 
     * @return The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
     *         previous request. A <code>NextToken</code> response indicates that more output is available. Set this
     *         parameter to the value of the previous call's <code>NextToken</code> response to indicate where the
     *         output should continue from.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of results that you want included on each page of the response. If you do not include this
     * parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum
     * you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that
     * value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of
     * the results. Note that Organizations might return fewer results than the maximum even when there are more results
     * available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the
     * results.
     * </p>
     * 
     * @return The total number of results that you want included on each page of the response. If you do not include
     *         this parameter, it defaults to a value that is specific to the operation. If additional items exist
     *         beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value
     *         (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the
     *         operation to get the next part of the results. Note that Organizations might return fewer results than
     *         the maximum even when there are more results available. You should check <code>NextToken</code> after
     *         every operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(filterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesForTargetRequest)) {
            return false;
        }
        ListPoliciesForTargetRequest other = (ListPoliciesForTargetRequest) obj;
        return Objects.equals(targetId(), other.targetId()) && Objects.equals(filterAsString(), other.filterAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPoliciesForTargetRequest").add("TargetId", targetId()).add("Filter", filterAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filterAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesForTargetRequest, T> g) {
        return obj -> g.apply((ListPoliciesForTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPoliciesForTargetRequest> {
        /**
         * <p>
         * The unique identifier (ID) of the root, organizational unit, or account whose policies you want to list.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Account</b> - A string that consists of exactly 12 digits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters
         * or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to
         * 32 additional lowercase letters or digits.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetId
         *        The unique identifier (ID) of the root, organizational unit, or account whose policies you want to
         *        list.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of
         *        the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Account</b> - A string that consists of exactly 12 digits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase
         *        letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash
         *        and from 8 to 32 additional lowercase letters or digits.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The type of policy that you want to include in the returned list. You must specify one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
         * SERVICE_CONTROL_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
         * RESOURCE_CONTROL_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
         * DECLARATIVE_POLICY_EC2</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         * BACKUP_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
         * TAG_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         * CHATBOT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
         * AISERVICES_OPT_OUT_POLICY</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        The type of policy that you want to include in the returned list. You must specify one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
         *        SERVICE_CONTROL_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
         *        RESOURCE_CONTROL_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
         *        >DECLARATIVE_POLICY_EC2</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         *        BACKUP_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
         *        >TAG_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         *        CHATBOT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html"
         *        >AISERVICES_OPT_OUT_POLICY</a>
         *        </p>
         *        </li>
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder filter(String filter);

        /**
         * <p>
         * The type of policy that you want to include in the returned list. You must specify one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
         * SERVICE_CONTROL_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
         * RESOURCE_CONTROL_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
         * DECLARATIVE_POLICY_EC2</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         * BACKUP_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
         * TAG_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         * CHATBOT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
         * AISERVICES_OPT_OUT_POLICY</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        The type of policy that you want to include in the returned list. You must specify one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
         *        SERVICE_CONTROL_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
         *        RESOURCE_CONTROL_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
         *        >DECLARATIVE_POLICY_EC2</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         *        BACKUP_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
         *        >TAG_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         *        CHATBOT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html"
         *        >AISERVICES_OPT_OUT_POLICY</a>
         *        </p>
         *        </li>
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder filter(PolicyType filter);

        /**
         * <p>
         * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
         * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
         * value of the previous call's <code>NextToken</code> response to indicate where the output should continue
         * from.
         * </p>
         * 
         * @param nextToken
         *        The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
         *        previous request. A <code>NextToken</code> response indicates that more output is available. Set this
         *        parameter to the value of the previous call's <code>NextToken</code> response to indicate where the
         *        output should continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of results that you want included on each page of the response. If you do not include this
         * parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the
         * maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null).
         * Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get
         * the next part of the results. Note that Organizations might return fewer results than the maximum even when
         * there are more results available. You should check <code>NextToken</code> after every operation to ensure
         * that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        The total number of results that you want included on each page of the response. If you do not include
         *        this parameter, it defaults to a value that is specific to the operation. If additional items exist
         *        beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value
         *        (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to
         *        the operation to get the next part of the results. Note that Organizations might return fewer results
         *        than the maximum even when there are more results available. You should check <code>NextToken</code>
         *        after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String targetId;

        private String filter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesForTargetRequest model) {
            super(model);
            targetId(model.targetId);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getFilter() {
            return filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public final Builder filter(PolicyType filter) {
            this.filter(filter == null ? null : filter.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPoliciesForTargetRequest build() {
            return new ListPoliciesForTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
