/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.EffectivePolicyValidationError;
import software.amazon.awssdk.services.organizations.model.ListEffectivePolicyValidationErrorsRequest;
import software.amazon.awssdk.services.organizations.model.ListEffectivePolicyValidationErrorsResponse;

public class ListEffectivePolicyValidationErrorsIterable
implements SdkIterable<ListEffectivePolicyValidationErrorsResponse> {
    private final OrganizationsClient client;
    private final ListEffectivePolicyValidationErrorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEffectivePolicyValidationErrorsIterable(OrganizationsClient client, ListEffectivePolicyValidationErrorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEffectivePolicyValidationErrorsResponseFetcher();
    }

    public Iterator<ListEffectivePolicyValidationErrorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EffectivePolicyValidationError> effectivePolicyValidationErrors() {
        Function<ListEffectivePolicyValidationErrorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.effectivePolicyValidationErrors() != null) {
                return response.effectivePolicyValidationErrors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEffectivePolicyValidationErrorsResponseFetcher
    implements SyncPageFetcher<ListEffectivePolicyValidationErrorsResponse> {
        private ListEffectivePolicyValidationErrorsResponseFetcher() {
        }

        public boolean hasNextPage(ListEffectivePolicyValidationErrorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEffectivePolicyValidationErrorsResponse nextPage(ListEffectivePolicyValidationErrorsResponse previousPage) {
            if (previousPage == null) {
                return ListEffectivePolicyValidationErrorsIterable.this.client.listEffectivePolicyValidationErrors(ListEffectivePolicyValidationErrorsIterable.this.firstRequest);
            }
            return ListEffectivePolicyValidationErrorsIterable.this.client.listEffectivePolicyValidationErrors((ListEffectivePolicyValidationErrorsRequest)((Object)ListEffectivePolicyValidationErrorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

