/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.AttachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.AttachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.CloseAccountRequest;
import software.amazon.awssdk.services.organizations.model.CloseAccountResponse;
import software.amazon.awssdk.services.organizations.model.CreateAccountRequest;
import software.amazon.awssdk.services.organizations.model.CreateAccountResponse;
import software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest;
import software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountResponse;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.CreatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.CreatePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DeletePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DeletePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest;
import software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorResponse;
import software.amazon.awssdk.services.organizations.model.DescribeAccountRequest;
import software.amazon.awssdk.services.organizations.model.DescribeAccountResponse;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DescribePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DescribePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DetachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.DetachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest;
import software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessResponse;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesRequest;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesResponse;
import software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest;
import software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessResponse;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsWithInvalidEffectivePolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsWithInvalidEffectivePolicyResponse;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest;
import software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse;
import software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse;
import software.amazon.awssdk.services.organizations.model.ListEffectivePolicyValidationErrorsRequest;
import software.amazon.awssdk.services.organizations.model.ListEffectivePolicyValidationErrorsResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListParentsRequest;
import software.amazon.awssdk.services.organizations.model.ListParentsResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesResponse;
import software.amazon.awssdk.services.organizations.model.ListRootsRequest;
import software.amazon.awssdk.services.organizations.model.ListRootsResponse;
import software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.organizations.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.organizations.model.MoveAccountRequest;
import software.amazon.awssdk.services.organizations.model.MoveAccountResponse;
import software.amazon.awssdk.services.organizations.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.organizations.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorRequest;
import software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorResponse;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.TagResourceRequest;
import software.amazon.awssdk.services.organizations.model.TagResourceResponse;
import software.amazon.awssdk.services.organizations.model.UntagResourceRequest;
import software.amazon.awssdk.services.organizations.model.UntagResourceResponse;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse;
import software.amazon.awssdk.services.organizations.paginators.ListAWSServiceAccessForOrganizationPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListAccountsForParentPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListAccountsPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListAccountsWithInvalidEffectivePolicyPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListChildrenPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListCreateAccountStatusPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListDelegatedAdministratorsPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListDelegatedServicesForAccountPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListEffectivePolicyValidationErrorsPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListHandshakesForAccountPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListHandshakesForOrganizationPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListOrganizationalUnitsForParentPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListParentsPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListPoliciesForTargetPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListPoliciesPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListRootsPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.organizations.paginators.ListTargetsForPolicyPublisher;

/**
 * Service client for accessing Organizations asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Organizations is a web service that enables you to consolidate your multiple Amazon Web Services accounts into an
 * <i>organization</i> and centrally manage your accounts and their resources.
 * </p>
 * <p>
 * This guide provides descriptions of the Organizations operations. For more information about using this service, see
 * the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">Organizations User
 * Guide</a>.
 * </p>
 * <p>
 * <b>Support and feedback for Organizations</b>
 * </p>
 * <p>
 * We welcome your feedback. You can post your feedback and questions in the <a
 * href="https://forums.aws.amazon.com/forum.jspa?forumID=219">Organizations support forum</a>. For more information
 * about the Amazon Web Services Support forums, see <a href="https://forums.aws.amazon.com/help.jspa">Forums Help</a>.
 * </p>
 * <p>
 * <b>Endpoint to call When using the CLI or the Amazon Web Services SDK</b>
 * </p>
 * <p>
 * For the current release of Organizations, specify the <code>us-east-1</code> region for all Amazon Web Services API
 * and CLI calls made from the commercial Amazon Web Services Regions outside of China. If calling from one of the
 * Amazon Web Services Regions in China, then specify <code>cn-northwest-1</code>. You can do this in the CLI by using
 * these parameters and commands:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Use the following parameter with each command to specify both the endpoint and its region:
 * </p>
 * <p>
 * <code>--endpoint-url https://organizations.us-east-1.amazonaws.com</code> <i>(from commercial Amazon Web Services
 * Regions outside of China)</i>
 * </p>
 * <p>
 * or
 * </p>
 * <p>
 * <code>--endpoint-url https://organizations.cn-northwest-1.amazonaws.com.cn</code> <i>(from Amazon Web Services
 * Regions in China)</i>
 * </p>
 * </li>
 * <li>
 * <p>
 * Use the default endpoint, but configure your default region with this command:
 * </p>
 * <p>
 * <code>aws configure set default.region us-east-1</code> <i>(from commercial Amazon Web Services Regions outside of
 * China)</i>
 * </p>
 * <p>
 * or
 * </p>
 * <p>
 * <code>aws configure set default.region cn-northwest-1</code> <i>(from Amazon Web Services Regions in China)</i>
 * </p>
 * </li>
 * <li>
 * <p>
 * Use the following parameter with each command to specify the endpoint:
 * </p>
 * <p>
 * <code>--region us-east-1</code> <i>(from commercial Amazon Web Services Regions outside of China)</i>
 * </p>
 * <p>
 * or
 * </p>
 * <p>
 * <code>--region cn-northwest-1</code> <i>(from Amazon Web Services Regions in China)</i>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Recording API Requests</b>
 * </p>
 * <p>
 * Organizations supports CloudTrail, a service that records Amazon Web Services API calls for your Amazon Web Services
 * account and delivers log files to an Amazon S3 bucket. By using information collected by CloudTrail, you can
 * determine which requests the Organizations service received, who made the request and when, and so on. For more about
 * Organizations and its support for CloudTrail, see <a href=
 * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_incident-response.html#orgs_cloudtrail-integration"
 * >Logging Organizations API calls with CloudTrail</a> in the <i>Organizations User Guide</i>. To learn more about
 * CloudTrail, including how to turn it on and find your log files, see the <a
 * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">CloudTrail User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OrganizationsAsyncClient extends AwsClient {
    String SERVICE_NAME = "organizations";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "organizations";

    /**
     * <p>
     * Sends a response to the originator of a handshake agreeing to the action proposed by the handshake request.
     * </p>
     * <p>
     * You can only call this operation by the following principals when they also have the relevant IAM permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Invitation to join</b> or <b>Approve all features request</b> handshakes: only a principal from the member
     * account.
     * </p>
     * <p>
     * The user who calls the API for an invitation to join must have the <code>organizations:AcceptHandshake</code>
     * permission. If you enabled all features in the organization, the user must also have the
     * <code>iam:CreateServiceLinkedRole</code> permission so that Organizations can create the required service-linked
     * role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integration_services.html#orgs_integrate_services-using_slrs"
     * >Organizations and service-linked roles</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Enable all features final confirmation</b> handshake: only a principal from the management account.
     * </p>
     * <p>
     * For more information about invitations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_invites.html">Inviting an
     * Amazon Web Services account to join your organization</a> in the <i>Organizations User Guide</i>. For more
     * information about requests to enable all features in the organization, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     * >Enabling all features in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you accept a handshake, it continues to appear in the results of relevant APIs for only 30 days. After
     * that, it's deleted.
     * </p>
     *
     * @param acceptHandshakeRequest
     * @return A Java Future containing the result of the AcceptHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>HandshakeConstraintViolationException The requested operation would violate the constraint identified
     *         in the reason code.</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation:
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. Note that deleted and closed accounts still count toward your limit.
     *         </p>
     *         <important>
     *         <p>
     *         If you get this exception immediately after creating the organization, wait one hour and try again. If
     *         after an hour it continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a
     *         member of an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations to join an organization while
     *         it's in the process of enabling all features. You can resume inviting accounts after you finalize the
     *         process when all accounts have agreed to the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has
     *         already enabled all features.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake request is invalid because the
     *         organization has already started the process to enable all features.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different
     *         marketplace than the accounts in the organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account
     *         too quickly after its previous change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an account that doesn't have a payment
     *         instrument, such as a credit card, associated with it.
     *         </p>
     *         </li></li>
     *         <li>HandshakeNotFoundException We can't find a handshake with the <code>HandshakeId</code> that you
     *         specified.</li>
     *         <li>InvalidHandshakeTransitionException You can't perform the operation on the handshake in its current
     *         state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was
     *         already declined.</li>
     *         <li>HandshakeAlreadyInStateException The specified handshake is already in the requested state. For
     *         example, you can't accept a handshake that was already accepted.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>AccessDeniedForDependencyException The operation that you attempted requires you to have the
     *         <code>iam:CreateServiceLinkedRole</code> for <code>organizations.amazonaws.com</code> permission so that
     *         Organizations can create the required service-linked role. You don't have that permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.AcceptHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AcceptHandshake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptHandshakeResponse> acceptHandshake(AcceptHandshakeRequest acceptHandshakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a response to the originator of a handshake agreeing to the action proposed by the handshake request.
     * </p>
     * <p>
     * You can only call this operation by the following principals when they also have the relevant IAM permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Invitation to join</b> or <b>Approve all features request</b> handshakes: only a principal from the member
     * account.
     * </p>
     * <p>
     * The user who calls the API for an invitation to join must have the <code>organizations:AcceptHandshake</code>
     * permission. If you enabled all features in the organization, the user must also have the
     * <code>iam:CreateServiceLinkedRole</code> permission so that Organizations can create the required service-linked
     * role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integration_services.html#orgs_integrate_services-using_slrs"
     * >Organizations and service-linked roles</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Enable all features final confirmation</b> handshake: only a principal from the management account.
     * </p>
     * <p>
     * For more information about invitations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_invites.html">Inviting an
     * Amazon Web Services account to join your organization</a> in the <i>Organizations User Guide</i>. For more
     * information about requests to enable all features in the organization, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     * >Enabling all features in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you accept a handshake, it continues to appear in the results of relevant APIs for only 30 days. After
     * that, it's deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptHandshakeRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptHandshakeRequest#builder()}
     * </p>
     *
     * @param acceptHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AcceptHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>HandshakeConstraintViolationException The requested operation would violate the constraint identified
     *         in the reason code.</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation:
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. Note that deleted and closed accounts still count toward your limit.
     *         </p>
     *         <important>
     *         <p>
     *         If you get this exception immediately after creating the organization, wait one hour and try again. If
     *         after an hour it continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a
     *         member of an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations to join an organization while
     *         it's in the process of enabling all features. You can resume inviting accounts after you finalize the
     *         process when all accounts have agreed to the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has
     *         already enabled all features.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake request is invalid because the
     *         organization has already started the process to enable all features.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different
     *         marketplace than the accounts in the organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account
     *         too quickly after its previous change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an account that doesn't have a payment
     *         instrument, such as a credit card, associated with it.
     *         </p>
     *         </li></li>
     *         <li>HandshakeNotFoundException We can't find a handshake with the <code>HandshakeId</code> that you
     *         specified.</li>
     *         <li>InvalidHandshakeTransitionException You can't perform the operation on the handshake in its current
     *         state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was
     *         already declined.</li>
     *         <li>HandshakeAlreadyInStateException The specified handshake is already in the requested state. For
     *         example, you can't accept a handshake that was already accepted.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>AccessDeniedForDependencyException The operation that you attempted requires you to have the
     *         <code>iam:CreateServiceLinkedRole</code> for <code>organizations.amazonaws.com</code> permission so that
     *         Organizations can create the required service-linked role. You don't have that permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.AcceptHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AcceptHandshake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptHandshakeResponse> acceptHandshake(
            Consumer<AcceptHandshakeRequest.Builder> acceptHandshakeRequest) {
        return acceptHandshake(AcceptHandshakeRequest.builder().applyMutation(acceptHandshakeRequest).build());
    }

    /**
     * <p>
     * Attaches a policy to a root, an organizational unit (OU), or an individual account. How the policy affects
     * accounts depends on the type of policy. Refer to the <i>Organizations User Guide</i> for information about each
     * policy type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     * SERVICE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     * RESOURCE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
     * SECURITYHUB_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     *
     * @param attachPolicyRequest
     * @return A Java Future containing the result of the AttachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>DuplicatePolicyAttachmentException The selected policy is already attached to the specified target.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyNotFoundException We can't find a policy with the <code>PolicyId</code> that you specified.</li>
     *         <li>PolicyTypeNotEnabledException The specified policy type isn't currently enabled in this root. You
     *         can't attach policies of the specified type to entities in a root until you enable that type in the root.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     *         >Enabling all features in your organization</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TargetNotFoundException We can't find a root, OU, account, or policy with the <code>TargetId</code>
     *         that you specified.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>PolicyChangesInProgressException Changes to the effective policy are in progress, and its contents
     *         can't be returned. Try the operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.AttachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AttachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachPolicyResponse> attachPolicy(AttachPolicyRequest attachPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a policy to a root, an organizational unit (OU), or an individual account. How the policy affects
     * accounts depends on the type of policy. Refer to the <i>Organizations User Guide</i> for information about each
     * policy type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     * SERVICE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     * RESOURCE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
     * SECURITYHUB_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link AttachPolicyRequest#builder()}
     * </p>
     *
     * @param attachPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.AttachPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AttachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>DuplicatePolicyAttachmentException The selected policy is already attached to the specified target.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyNotFoundException We can't find a policy with the <code>PolicyId</code> that you specified.</li>
     *         <li>PolicyTypeNotEnabledException The specified policy type isn't currently enabled in this root. You
     *         can't attach policies of the specified type to entities in a root until you enable that type in the root.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     *         >Enabling all features in your organization</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TargetNotFoundException We can't find a root, OU, account, or policy with the <code>TargetId</code>
     *         that you specified.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>PolicyChangesInProgressException Changes to the effective policy are in progress, and its contents
     *         can't be returned. Try the operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.AttachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AttachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachPolicyResponse> attachPolicy(Consumer<AttachPolicyRequest.Builder> attachPolicyRequest) {
        return attachPolicy(AttachPolicyRequest.builder().applyMutation(attachPolicyRequest).build());
    }

    /**
     * <p>
     * Cancels a handshake. Canceling a handshake sets the handshake state to <code>CANCELED</code>.
     * </p>
     * <p>
     * This operation can be called only from the account that originated the handshake. The recipient of the handshake
     * can't cancel it, but can use <a>DeclineHandshake</a> instead. After a handshake is canceled, the recipient can no
     * longer respond to that handshake.
     * </p>
     * <p>
     * After you cancel a handshake, it continues to appear in the results of relevant APIs for only 30 days. After
     * that, it's deleted.
     * </p>
     *
     * @param cancelHandshakeRequest
     * @return A Java Future containing the result of the CancelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>HandshakeNotFoundException We can't find a handshake with the <code>HandshakeId</code> that you
     *         specified.</li>
     *         <li>InvalidHandshakeTransitionException You can't perform the operation on the handshake in its current
     *         state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was
     *         already declined.</li>
     *         <li>HandshakeAlreadyInStateException The specified handshake is already in the requested state. For
     *         example, you can't accept a handshake that was already accepted.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CancelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CancelHandshake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelHandshakeResponse> cancelHandshake(CancelHandshakeRequest cancelHandshakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a handshake. Canceling a handshake sets the handshake state to <code>CANCELED</code>.
     * </p>
     * <p>
     * This operation can be called only from the account that originated the handshake. The recipient of the handshake
     * can't cancel it, but can use <a>DeclineHandshake</a> instead. After a handshake is canceled, the recipient can no
     * longer respond to that handshake.
     * </p>
     * <p>
     * After you cancel a handshake, it continues to appear in the results of relevant APIs for only 30 days. After
     * that, it's deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelHandshakeRequest.Builder} avoiding the need
     * to create one manually via {@link CancelHandshakeRequest#builder()}
     * </p>
     *
     * @param cancelHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>HandshakeNotFoundException We can't find a handshake with the <code>HandshakeId</code> that you
     *         specified.</li>
     *         <li>InvalidHandshakeTransitionException You can't perform the operation on the handshake in its current
     *         state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was
     *         already declined.</li>
     *         <li>HandshakeAlreadyInStateException The specified handshake is already in the requested state. For
     *         example, you can't accept a handshake that was already accepted.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CancelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CancelHandshake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelHandshakeResponse> cancelHandshake(
            Consumer<CancelHandshakeRequest.Builder> cancelHandshakeRequest) {
        return cancelHandshake(CancelHandshakeRequest.builder().applyMutation(cancelHandshakeRequest).build());
    }

    /**
     * <p>
     * Closes an Amazon Web Services member account within an organization. You can close an account when <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all
     * features are enabled </a>. You can't close the management account with this API. This is an asynchronous request
     * that Amazon Web Services performs in the background. Because <code>CloseAccount</code> operates asynchronously,
     * it can return a successful completion message even though account closure might still be in progress. You need to
     * wait a few minutes before the account is fully closed. To check the status of the request, do one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>AccountId</code> that you sent in the <code>CloseAccount</code> request to provide as a parameter
     * to the <a>DescribeAccount</a> operation.
     * </p>
     * <p>
     * While the close account request is in progress, Account status will indicate PENDING_CLOSURE. When the close
     * account request completes, the status will change to SUSPENDED.
     * </p>
     * </li>
     * <li>
     * <p>
     * Check the CloudTrail log for the <code>CloseAccountResult</code> event that gets published after the account
     * closes successfully. For information on using CloudTrail with Organizations, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration"
     * >Logging and monitoring in Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You can close only 10% of member accounts, between 10 and 1000, within a rolling 30 day period. This quota is not
     * bound by a calendar month, but starts when you close an account. After you reach this limit, you can't close
     * additional accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing a
     * member account in your organization</a> and <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     * Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To reinstate a closed account, contact Amazon Web Services Support within the 90-day grace period while the
     * account is in SUSPENDED status.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the Amazon Web Services account you attempt to close is linked to an Amazon Web Services GovCloud (US)
     * account, the <code>CloseAccount</code> request will close both accounts. To learn important pre-closure details,
     * see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/Closing-govcloud-account.html"> Closing an
     * Amazon Web Services GovCloud (US) account</a> in the <i> Amazon Web Services GovCloud User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param closeAccountRequest
     * @return A Java Future containing the result of the CloseAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AccountAlreadyClosedException You attempted to close an account that is already closed.</li>
     *         <li>AccountNotFoundException We can't find an Amazon Web Services account with the <code>AccountId</code>
     *         that you specified, or the account whose credentials you used to make this request isn't a member of an
     *         organization.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CloseAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CloseAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CloseAccountResponse> closeAccount(CloseAccountRequest closeAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Closes an Amazon Web Services member account within an organization. You can close an account when <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all
     * features are enabled </a>. You can't close the management account with this API. This is an asynchronous request
     * that Amazon Web Services performs in the background. Because <code>CloseAccount</code> operates asynchronously,
     * it can return a successful completion message even though account closure might still be in progress. You need to
     * wait a few minutes before the account is fully closed. To check the status of the request, do one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>AccountId</code> that you sent in the <code>CloseAccount</code> request to provide as a parameter
     * to the <a>DescribeAccount</a> operation.
     * </p>
     * <p>
     * While the close account request is in progress, Account status will indicate PENDING_CLOSURE. When the close
     * account request completes, the status will change to SUSPENDED.
     * </p>
     * </li>
     * <li>
     * <p>
     * Check the CloudTrail log for the <code>CloseAccountResult</code> event that gets published after the account
     * closes successfully. For information on using CloudTrail with Organizations, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration"
     * >Logging and monitoring in Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You can close only 10% of member accounts, between 10 and 1000, within a rolling 30 day period. This quota is not
     * bound by a calendar month, but starts when you close an account. After you reach this limit, you can't close
     * additional accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing a
     * member account in your organization</a> and <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     * Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To reinstate a closed account, contact Amazon Web Services Support within the 90-day grace period while the
     * account is in SUSPENDED status.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the Amazon Web Services account you attempt to close is linked to an Amazon Web Services GovCloud (US)
     * account, the <code>CloseAccount</code> request will close both accounts. To learn important pre-closure details,
     * see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/Closing-govcloud-account.html"> Closing an
     * Amazon Web Services GovCloud (US) account</a> in the <i> Amazon Web Services GovCloud User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloseAccountRequest.Builder} avoiding the need to
     * create one manually via {@link CloseAccountRequest#builder()}
     * </p>
     *
     * @param closeAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.CloseAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CloseAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AccountAlreadyClosedException You attempted to close an account that is already closed.</li>
     *         <li>AccountNotFoundException We can't find an Amazon Web Services account with the <code>AccountId</code>
     *         that you specified, or the account whose credentials you used to make this request isn't a member of an
     *         organization.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CloseAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CloseAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CloseAccountResponse> closeAccount(Consumer<CloseAccountRequest.Builder> closeAccountRequest) {
        return closeAccount(CloseAccountRequest.builder().applyMutation(closeAccountRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services account that is automatically a member of the organization whose credentials made
     * the request. This is an asynchronous request that Amazon Web Services performs in the background. Because
     * <code>CreateAccount</code> operates asynchronously, it can return a successful completion message even though
     * account initialization might still be in progress. You might need to wait a few minutes before you can
     * successfully access the account. To check the status of the request, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>Id</code> value of the <code>CreateAccountStatus</code> response element from this operation to
     * provide as a parameter to the <a>DescribeCreateAccountStatus</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Check the CloudTrail log for the <code>CreateAccountResult</code> event. For information on using CloudTrail with
     * Organizations, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration"
     * >Logging and monitoring in Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The user who calls the API to create an account must have the <code>organizations:CreateAccount</code>
     * permission. If you enabled all features in the organization, Organizations creates the required service-linked
     * role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs"
     * >Organizations and service-linked roles</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.
     * </p>
     * <p>
     * Organizations preconfigures the new member account with a role (named <code>OrganizationAccountAccessRole</code>
     * by default) that grants users in the management account administrator permissions in the new member account.
     * Principals in the management account can assume the role. Organizations clones the company name and address
     * information for the new account from the organization's management account.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     * <p>
     * For more information about creating accounts, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating a
     * member account in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * When you create an account in an organization using the Organizations console, API, or CLI commands, the
     * information required for the account to operate as a standalone account, such as a payment method is <i>not</i>
     * automatically collected. If you must remove an account from your organization later, you can do so only after you
     * provide the missing information. For more information, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     * >Considerations before removing an account from an organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you get an exception that indicates that you exceeded your account limits for the organization, contact <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you get an exception that indicates that the operation failed because your organization is still initializing,
     * wait one hour and then try again. If the error persists, contact <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * It isn't recommended to use <code>CreateAccount</code> to create multiple temporary accounts, and using the
     * <code>CreateAccount</code> API to close accounts is subject to a 30-day usage quota. For information on the
     * requirements and process for closing an account, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing a
     * member account in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </important> <note>
     * <p>
     * When you create a member account with this operation, you can choose whether to create the account with the
     * <b>IAM User and Role Access to Billing Information</b> switch enabled. If you enable it, IAM users and roles that
     * have appropriate permissions can view billing information for the account. If you disable it, only the account
     * root user can access billing information. For information about how to disable this switch for an account, see <a
     * href
     * ="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/control-access-billing.html#grantaccess">Granting
     * access to your billing information and tools</a>.
     * </p>
     * </note>
     *
     * @param createAccountRequest
     * @return A Java Future containing the result of the CreateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>FinalizingOrganizationException Organizations couldn't perform the operation because your
     *         organization hasn't finished initializing. This can take up to an hour. Try again later. If after one
     *         hour you continue to receive this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreateAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAccountResponse> createAccount(CreateAccountRequest createAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services account that is automatically a member of the organization whose credentials made
     * the request. This is an asynchronous request that Amazon Web Services performs in the background. Because
     * <code>CreateAccount</code> operates asynchronously, it can return a successful completion message even though
     * account initialization might still be in progress. You might need to wait a few minutes before you can
     * successfully access the account. To check the status of the request, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>Id</code> value of the <code>CreateAccountStatus</code> response element from this operation to
     * provide as a parameter to the <a>DescribeCreateAccountStatus</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Check the CloudTrail log for the <code>CreateAccountResult</code> event. For information on using CloudTrail with
     * Organizations, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration"
     * >Logging and monitoring in Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The user who calls the API to create an account must have the <code>organizations:CreateAccount</code>
     * permission. If you enabled all features in the organization, Organizations creates the required service-linked
     * role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs"
     * >Organizations and service-linked roles</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.
     * </p>
     * <p>
     * Organizations preconfigures the new member account with a role (named <code>OrganizationAccountAccessRole</code>
     * by default) that grants users in the management account administrator permissions in the new member account.
     * Principals in the management account can assume the role. Organizations clones the company name and address
     * information for the new account from the organization's management account.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     * <p>
     * For more information about creating accounts, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating a
     * member account in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * When you create an account in an organization using the Organizations console, API, or CLI commands, the
     * information required for the account to operate as a standalone account, such as a payment method is <i>not</i>
     * automatically collected. If you must remove an account from your organization later, you can do so only after you
     * provide the missing information. For more information, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     * >Considerations before removing an account from an organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you get an exception that indicates that you exceeded your account limits for the organization, contact <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you get an exception that indicates that the operation failed because your organization is still initializing,
     * wait one hour and then try again. If the error persists, contact <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * It isn't recommended to use <code>CreateAccount</code> to create multiple temporary accounts, and using the
     * <code>CreateAccount</code> API to close accounts is subject to a 30-day usage quota. For information on the
     * requirements and process for closing an account, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing a
     * member account in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </important> <note>
     * <p>
     * When you create a member account with this operation, you can choose whether to create the account with the
     * <b>IAM User and Role Access to Billing Information</b> switch enabled. If you enable it, IAM users and roles that
     * have appropriate permissions can view billing information for the account. If you disable it, only the account
     * root user can access billing information. For information about how to disable this switch for an account, see <a
     * href
     * ="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/control-access-billing.html#grantaccess">Granting
     * access to your billing information and tools</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAccountRequest#builder()}
     * </p>
     *
     * @param createAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.CreateAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>FinalizingOrganizationException Organizations couldn't perform the operation because your
     *         organization hasn't finished initializing. This can take up to an hour. Try again later. If after one
     *         hour you continue to receive this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreateAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAccountResponse> createAccount(Consumer<CreateAccountRequest.Builder> createAccountRequest) {
        return createAccount(CreateAccountRequest.builder().applyMutation(createAccountRequest).build());
    }

    /**
     * <p>
     * This action is available if all of the following are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You're authorized to create accounts in the Amazon Web Services GovCloud (US) Region. For more information on the
     * Amazon Web Services GovCloud (US) Region, see the <a
     * href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/welcome.html"> <i>Amazon Web Services GovCloud
     * User Guide</i>.</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * You already have an account in the Amazon Web Services GovCloud (US) Region that is paired with a management
     * account of an organization in the commercial Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You call this action from the management account of your organization in the commercial Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You have the <code>organizations:CreateGovCloudAccount</code> permission.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Organizations automatically creates the required service-linked role named
     * <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs"
     * >Organizations and service-linked roles</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * Amazon Web Services automatically enables CloudTrail for Amazon Web Services GovCloud (US) accounts, but you
     * should also do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Verify that CloudTrail is enabled to store logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create an Amazon S3 bucket for CloudTrail log storage.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/verifying-cloudtrail.html">Verifying CloudTrail Is
     * Enabled</a> in the <i>Amazon Web Services GovCloud User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.
     * The tags are attached to the commercial account associated with the GovCloud account, rather than the GovCloud
     * account itself. To add tags to the GovCloud account, call the <a>TagResource</a> operation in the GovCloud Region
     * after the new GovCloud account exists.
     * </p>
     * <p>
     * You call this action from the management account of your organization in the commercial Region to create a
     * standalone Amazon Web Services account in the Amazon Web Services GovCloud (US) Region. After the account is
     * created, the management account of an organization in the Amazon Web Services GovCloud (US) Region can invite it
     * to that organization. For more information on inviting standalone accounts in the Amazon Web Services GovCloud
     * (US) to join an organization, see <a
     * href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in
     * the <i>Amazon Web Services GovCloud User Guide</i>.
     * </p>
     * <p>
     * Calling <code>CreateGovCloudAccount</code> is an asynchronous request that Amazon Web Services performs in the
     * background. Because <code>CreateGovCloudAccount</code> operates asynchronously, it can return a successful
     * completion message even though account initialization might still be in progress. You might need to wait a few
     * minutes before you can successfully access the account. To check the status of the request, do one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>OperationId</code> response element from this operation to provide as a parameter to the
     * <a>DescribeCreateAccountStatus</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Check the CloudTrail log for the <code>CreateAccountResult</code> event. For information on using CloudTrail with
     * Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html">Logging
     * and monitoring in Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p/>
     * <p>
     * When you call the <code>CreateGovCloudAccount</code> action, you create two accounts: a standalone account in the
     * Amazon Web Services GovCloud (US) Region and an associated account in the commercial Region for billing and
     * support purposes. The account in the commercial Region is automatically a member of the organization whose
     * credentials made the request. Both accounts are associated with the same email address.
     * </p>
     * <p>
     * A role is created in the new account in the commercial Region that allows the management account in the
     * organization in the commercial Region to assume it. An Amazon Web Services GovCloud (US) account is then created
     * and associated with the commercial account that you just created. A role is also created in the new Amazon Web
     * Services GovCloud (US) account that can be assumed by the Amazon Web Services GovCloud (US) account that is
     * associated with the management account of the commercial organization. For more information and to view a diagram
     * that explains how account access works, see <a
     * href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in
     * the <i>Amazon Web Services GovCloud User Guide</i>.
     * </p>
     * <p>
     * For more information about creating accounts, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating a
     * member account in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * When you create an account in an organization using the Organizations console, API, or CLI commands, the
     * information required for the account to operate as a standalone account is <i>not</i> automatically collected.
     * This includes a payment method and signing the end user license agreement (EULA). If you must remove an account
     * from your organization later, you can do so only after you provide the missing information. For more information,
     * see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html">
     * Considerations before removing an account from an organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you get an exception that indicates that you exceeded your account limits for the organization, contact <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you get an exception that indicates that the operation failed because your organization is still initializing,
     * wait one hour and then try again. If the error persists, contact <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Using <code>CreateGovCloudAccount</code> to create multiple temporary accounts isn't recommended. You can only
     * close an account from the Amazon Web Services Billing and Cost Management console, and you must be signed in as
     * the root user. For information on the requirements and process for closing an account, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing a
     * member account in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </important> <note>
     * <p>
     * When you create a member account with this operation, you can choose whether to create the account with the
     * <b>IAM User and Role Access to Billing Information</b> switch enabled. If you enable it, IAM users and roles that
     * have appropriate permissions can view billing information for the account. If you disable it, only the account
     * root user can access billing information. For information about how to disable this switch for an account, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html">Granting access to your
     * billing information and tools</a>.
     * </p>
     * </note>
     *
     * @param createGovCloudAccountRequest
     * @return A Java Future containing the result of the CreateGovCloudAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>FinalizingOrganizationException Organizations couldn't perform the operation because your
     *         organization hasn't finished initializing. This can take up to an hour. Try again later. If after one
     *         hour you continue to receive this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreateGovCloudAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateGovCloudAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGovCloudAccountResponse> createGovCloudAccount(
            CreateGovCloudAccountRequest createGovCloudAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action is available if all of the following are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You're authorized to create accounts in the Amazon Web Services GovCloud (US) Region. For more information on the
     * Amazon Web Services GovCloud (US) Region, see the <a
     * href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/welcome.html"> <i>Amazon Web Services GovCloud
     * User Guide</i>.</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * You already have an account in the Amazon Web Services GovCloud (US) Region that is paired with a management
     * account of an organization in the commercial Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You call this action from the management account of your organization in the commercial Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You have the <code>organizations:CreateGovCloudAccount</code> permission.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Organizations automatically creates the required service-linked role named
     * <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs"
     * >Organizations and service-linked roles</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * Amazon Web Services automatically enables CloudTrail for Amazon Web Services GovCloud (US) accounts, but you
     * should also do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Verify that CloudTrail is enabled to store logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create an Amazon S3 bucket for CloudTrail log storage.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/verifying-cloudtrail.html">Verifying CloudTrail Is
     * Enabled</a> in the <i>Amazon Web Services GovCloud User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.
     * The tags are attached to the commercial account associated with the GovCloud account, rather than the GovCloud
     * account itself. To add tags to the GovCloud account, call the <a>TagResource</a> operation in the GovCloud Region
     * after the new GovCloud account exists.
     * </p>
     * <p>
     * You call this action from the management account of your organization in the commercial Region to create a
     * standalone Amazon Web Services account in the Amazon Web Services GovCloud (US) Region. After the account is
     * created, the management account of an organization in the Amazon Web Services GovCloud (US) Region can invite it
     * to that organization. For more information on inviting standalone accounts in the Amazon Web Services GovCloud
     * (US) to join an organization, see <a
     * href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in
     * the <i>Amazon Web Services GovCloud User Guide</i>.
     * </p>
     * <p>
     * Calling <code>CreateGovCloudAccount</code> is an asynchronous request that Amazon Web Services performs in the
     * background. Because <code>CreateGovCloudAccount</code> operates asynchronously, it can return a successful
     * completion message even though account initialization might still be in progress. You might need to wait a few
     * minutes before you can successfully access the account. To check the status of the request, do one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>OperationId</code> response element from this operation to provide as a parameter to the
     * <a>DescribeCreateAccountStatus</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Check the CloudTrail log for the <code>CreateAccountResult</code> event. For information on using CloudTrail with
     * Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html">Logging
     * and monitoring in Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p/>
     * <p>
     * When you call the <code>CreateGovCloudAccount</code> action, you create two accounts: a standalone account in the
     * Amazon Web Services GovCloud (US) Region and an associated account in the commercial Region for billing and
     * support purposes. The account in the commercial Region is automatically a member of the organization whose
     * credentials made the request. Both accounts are associated with the same email address.
     * </p>
     * <p>
     * A role is created in the new account in the commercial Region that allows the management account in the
     * organization in the commercial Region to assume it. An Amazon Web Services GovCloud (US) account is then created
     * and associated with the commercial account that you just created. A role is also created in the new Amazon Web
     * Services GovCloud (US) account that can be assumed by the Amazon Web Services GovCloud (US) account that is
     * associated with the management account of the commercial organization. For more information and to view a diagram
     * that explains how account access works, see <a
     * href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in
     * the <i>Amazon Web Services GovCloud User Guide</i>.
     * </p>
     * <p>
     * For more information about creating accounts, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating a
     * member account in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * When you create an account in an organization using the Organizations console, API, or CLI commands, the
     * information required for the account to operate as a standalone account is <i>not</i> automatically collected.
     * This includes a payment method and signing the end user license agreement (EULA). If you must remove an account
     * from your organization later, you can do so only after you provide the missing information. For more information,
     * see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html">
     * Considerations before removing an account from an organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you get an exception that indicates that you exceeded your account limits for the organization, contact <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you get an exception that indicates that the operation failed because your organization is still initializing,
     * wait one hour and then try again. If the error persists, contact <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Using <code>CreateGovCloudAccount</code> to create multiple temporary accounts isn't recommended. You can only
     * close an account from the Amazon Web Services Billing and Cost Management console, and you must be signed in as
     * the root user. For information on the requirements and process for closing an account, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing a
     * member account in your organization</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </important> <note>
     * <p>
     * When you create a member account with this operation, you can choose whether to create the account with the
     * <b>IAM User and Role Access to Billing Information</b> switch enabled. If you enable it, IAM users and roles that
     * have appropriate permissions can view billing information for the account. If you disable it, only the account
     * root user can access billing information. For information about how to disable this switch for an account, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html">Granting access to your
     * billing information and tools</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGovCloudAccountRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGovCloudAccountRequest#builder()}
     * </p>
     *
     * @param createGovCloudAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateGovCloudAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>FinalizingOrganizationException Organizations couldn't perform the operation because your
     *         organization hasn't finished initializing. This can take up to an hour. Try again later. If after one
     *         hour you continue to receive this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreateGovCloudAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateGovCloudAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGovCloudAccountResponse> createGovCloudAccount(
            Consumer<CreateGovCloudAccountRequest.Builder> createGovCloudAccountRequest) {
        return createGovCloudAccount(CreateGovCloudAccountRequest.builder().applyMutation(createGovCloudAccountRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services organization. The account whose user is calling the
     * <code>CreateOrganization</code> operation automatically becomes the <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     * >management account</a> of the new organization.
     * </p>
     * <p>
     * This operation must be called using credentials from the account that is to become the new organization's
     * management account. The principal must also have the relevant IAM permissions.
     * </p>
     * <p>
     * By default (or if you set the <code>FeatureSet</code> parameter to <code>ALL</code>), the new organization is
     * created with all features enabled and service control policies automatically enabled in the root. If you instead
     * choose to create the organization supporting only the consolidated billing features by setting the
     * <code>FeatureSet</code> parameter to <code>CONSOLIDATED_BILLING</code>, no policy types are enabled by default
     * and you can't use organization policies.
     * </p>
     *
     * @param createOrganizationRequest
     * @return A Java Future containing the result of the CreateOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AlreadyInOrganizationException This account is already a member of an organization. An account can
     *         belong to only one organization at a time.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>AccessDeniedForDependencyException The operation that you attempted requires you to have the
     *         <code>iam:CreateServiceLinkedRole</code> for <code>organizations.amazonaws.com</code> permission so that
     *         Organizations can create the required service-linked role. You don't have that permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreateOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOrganizationResponse> createOrganization(CreateOrganizationRequest createOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services organization. The account whose user is calling the
     * <code>CreateOrganization</code> operation automatically becomes the <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     * >management account</a> of the new organization.
     * </p>
     * <p>
     * This operation must be called using credentials from the account that is to become the new organization's
     * management account. The principal must also have the relevant IAM permissions.
     * </p>
     * <p>
     * By default (or if you set the <code>FeatureSet</code> parameter to <code>ALL</code>), the new organization is
     * created with all features enabled and service control policies automatically enabled in the root. If you instead
     * choose to create the organization supporting only the consolidated billing features by setting the
     * <code>FeatureSet</code> parameter to <code>CONSOLIDATED_BILLING</code>, no policy types are enabled by default
     * and you can't use organization policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOrganizationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOrganizationRequest#builder()}
     * </p>
     *
     * @param createOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AlreadyInOrganizationException This account is already a member of an organization. An account can
     *         belong to only one organization at a time.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>AccessDeniedForDependencyException The operation that you attempted requires you to have the
     *         <code>iam:CreateServiceLinkedRole</code> for <code>organizations.amazonaws.com</code> permission so that
     *         Organizations can create the required service-linked role. You don't have that permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreateOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOrganizationResponse> createOrganization(
            Consumer<CreateOrganizationRequest.Builder> createOrganizationRequest) {
        return createOrganization(CreateOrganizationRequest.builder().applyMutation(createOrganizationRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services organization. The account whose user is calling the
     * <code>CreateOrganization</code> operation automatically becomes the <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     * >management account</a> of the new organization.
     * </p>
     * <p>
     * This operation must be called using credentials from the account that is to become the new organization's
     * management account. The principal must also have the relevant IAM permissions.
     * </p>
     * <p>
     * By default (or if you set the <code>FeatureSet</code> parameter to <code>ALL</code>), the new organization is
     * created with all features enabled and service control policies automatically enabled in the root. If you instead
     * choose to create the organization supporting only the consolidated billing features by setting the
     * <code>FeatureSet</code> parameter to <code>CONSOLIDATED_BILLING</code>, no policy types are enabled by default
     * and you can't use organization policies.
     * </p>
     *
     * @return A Java Future containing the result of the CreateOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AlreadyInOrganizationException This account is already a member of an organization. An account can
     *         belong to only one organization at a time.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>AccessDeniedForDependencyException The operation that you attempted requires you to have the
     *         <code>iam:CreateServiceLinkedRole</code> for <code>organizations.amazonaws.com</code> permission so that
     *         Organizations can create the required service-linked role. You don't have that permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreateOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOrganizationResponse> createOrganization() {
        return createOrganization(CreateOrganizationRequest.builder().build());
    }

    /**
     * <p>
     * Creates an organizational unit (OU) within a root or parent OU. An OU is a container for accounts that enables
     * you to organize your accounts to apply policies according to your business requirements. The number of levels
     * deep that you can nest OUs is dependent upon the policy types enabled for that root. For service control
     * policies, the limit is five.
     * </p>
     * <p>
     * For more information about OUs, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing organizational
     * units (OUs)</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     *
     * @param createOrganizationalUnitRequest
     * @return A Java Future containing the result of the CreateOrganizationalUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>DuplicateOrganizationalUnitException An OU with the same name already exists.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ParentNotFoundException We can't find a root or OU with the <code>ParentId</code> that you specified.
     *         </li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreateOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOrganizationalUnitResponse> createOrganizationalUnit(
            CreateOrganizationalUnitRequest createOrganizationalUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an organizational unit (OU) within a root or parent OU. An OU is a container for accounts that enables
     * you to organize your accounts to apply policies according to your business requirements. The number of levels
     * deep that you can nest OUs is dependent upon the policy types enabled for that root. For service control
     * policies, the limit is five.
     * </p>
     * <p>
     * For more information about OUs, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing organizational
     * units (OUs)</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOrganizationalUnitRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOrganizationalUnitRequest#builder()}
     * </p>
     *
     * @param createOrganizationalUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateOrganizationalUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>DuplicateOrganizationalUnitException An OU with the same name already exists.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ParentNotFoundException We can't find a root or OU with the <code>ParentId</code> that you specified.
     *         </li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreateOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOrganizationalUnitResponse> createOrganizationalUnit(
            Consumer<CreateOrganizationalUnitRequest.Builder> createOrganizationalUnitRequest) {
        return createOrganizationalUnit(CreateOrganizationalUnitRequest.builder().applyMutation(createOrganizationalUnitRequest)
                .build());
    }

    /**
     * <p>
     * Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual
     * Amazon Web Services account.
     * </p>
     * <p>
     * For more information about policies and their use, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">Managing
     * Organizations policies</a>.
     * </p>
     * <p>
     * If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     *
     * @param createPolicyRequest
     * @return A Java Future containing the result of the CreatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>DuplicatePolicyException A policy with the same name already exists.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>MalformedPolicyDocumentException The provided policy document doesn't meet the requirements of the
     *         specified policy type. For example, the syntax might be incorrect. For details about service control
     *         policy syntax, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html"
     *         >SCP syntax</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>PolicyTypeNotAvailableForOrganizationException You can't use the specified policy type with the
     *         feature set currently enabled for this organization. For example, you can enable SCPs only after you
     *         enable all features in the organization. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root"
     *         >Managing Organizations policies</a>in the <i>Organizations User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreatePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePolicyResponse> createPolicy(CreatePolicyRequest createPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual
     * Amazon Web Services account.
     * </p>
     * <p>
     * For more information about policies and their use, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">Managing
     * Organizations policies</a>.
     * </p>
     * <p>
     * If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePolicyRequest#builder()}
     * </p>
     *
     * @param createPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.CreatePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>DuplicatePolicyException A policy with the same name already exists.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>MalformedPolicyDocumentException The provided policy document doesn't meet the requirements of the
     *         specified policy type. For example, the syntax might be incorrect. For details about service control
     *         policy syntax, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html"
     *         >SCP syntax</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>PolicyTypeNotAvailableForOrganizationException You can't use the specified policy type with the
     *         feature set currently enabled for this organization. For example, you can enable SCPs only after you
     *         enable all features in the organization. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root"
     *         >Managing Organizations policies</a>in the <i>Organizations User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.CreatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreatePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePolicyResponse> createPolicy(Consumer<CreatePolicyRequest.Builder> createPolicyRequest) {
        return createPolicy(CreatePolicyRequest.builder().applyMutation(createPolicyRequest).build());
    }

    /**
     * <p>
     * Declines a handshake request. This sets the handshake state to <code>DECLINED</code> and effectively deactivates
     * the request.
     * </p>
     * <p>
     * This operation can be called only from the account that received the handshake. The originator of the handshake
     * can use <a>CancelHandshake</a> instead. The originator can't reactivate a declined request, but can reinitiate
     * the process with a new handshake request.
     * </p>
     * <p>
     * After you decline a handshake, it continues to appear in the results of relevant APIs for only 30 days. After
     * that, it's deleted.
     * </p>
     *
     * @param declineHandshakeRequest
     * @return A Java Future containing the result of the DeclineHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>HandshakeNotFoundException We can't find a handshake with the <code>HandshakeId</code> that you
     *         specified.</li>
     *         <li>InvalidHandshakeTransitionException You can't perform the operation on the handshake in its current
     *         state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was
     *         already declined.</li>
     *         <li>HandshakeAlreadyInStateException The specified handshake is already in the requested state. For
     *         example, you can't accept a handshake that was already accepted.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeclineHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeclineHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeclineHandshakeResponse> declineHandshake(DeclineHandshakeRequest declineHandshakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Declines a handshake request. This sets the handshake state to <code>DECLINED</code> and effectively deactivates
     * the request.
     * </p>
     * <p>
     * This operation can be called only from the account that received the handshake. The originator of the handshake
     * can use <a>CancelHandshake</a> instead. The originator can't reactivate a declined request, but can reinitiate
     * the process with a new handshake request.
     * </p>
     * <p>
     * After you decline a handshake, it continues to appear in the results of relevant APIs for only 30 days. After
     * that, it's deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeclineHandshakeRequest.Builder} avoiding the need
     * to create one manually via {@link DeclineHandshakeRequest#builder()}
     * </p>
     *
     * @param declineHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeclineHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>HandshakeNotFoundException We can't find a handshake with the <code>HandshakeId</code> that you
     *         specified.</li>
     *         <li>InvalidHandshakeTransitionException You can't perform the operation on the handshake in its current
     *         state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was
     *         already declined.</li>
     *         <li>HandshakeAlreadyInStateException The specified handshake is already in the requested state. For
     *         example, you can't accept a handshake that was already accepted.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeclineHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeclineHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeclineHandshakeResponse> declineHandshake(
            Consumer<DeclineHandshakeRequest.Builder> declineHandshakeRequest) {
        return declineHandshake(DeclineHandshakeRequest.builder().applyMutation(declineHandshakeRequest).build());
    }

    /**
     * <p>
     * Deletes the organization. You can delete an organization only by using credentials from the management account.
     * The organization must be empty of member accounts.
     * </p>
     *
     * @param deleteOrganizationRequest
     * @return A Java Future containing the result of the DeleteOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>OrganizationNotEmptyException The organization isn't empty. To delete an organization, you must first
     *         remove all accounts except the management account.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeleteOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationResponse> deleteOrganization(DeleteOrganizationRequest deleteOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the organization. You can delete an organization only by using credentials from the management account.
     * The organization must be empty of member accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOrganizationRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DeleteOrganizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>OrganizationNotEmptyException The organization isn't empty. To delete an organization, you must first
     *         remove all accounts except the management account.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeleteOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationResponse> deleteOrganization(
            Consumer<DeleteOrganizationRequest.Builder> deleteOrganizationRequest) {
        return deleteOrganization(DeleteOrganizationRequest.builder().applyMutation(deleteOrganizationRequest).build());
    }

    /**
     * <p>
     * Deletes the organization. You can delete an organization only by using credentials from the management account.
     * The organization must be empty of member accounts.
     * </p>
     *
     * @return A Java Future containing the result of the DeleteOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>OrganizationNotEmptyException The organization isn't empty. To delete an organization, you must first
     *         remove all accounts except the management account.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeleteOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationResponse> deleteOrganization() {
        return deleteOrganization(DeleteOrganizationRequest.builder().build());
    }

    /**
     * <p>
     * Deletes an organizational unit (OU) from a root or another OU. You must first remove all accounts and child OUs
     * from the OU that you want to delete.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     *
     * @param deleteOrganizationalUnitRequest
     * @return A Java Future containing the result of the DeleteOrganizationalUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>OrganizationalUnitNotEmptyException The specified OU is not empty. Move all accounts to another root
     *         or to other OUs, remove all child OUs, and try the operation again.</li>
     *         <li>OrganizationalUnitNotFoundException We can't find an OU with the <code>OrganizationalUnitId</code>
     *         that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeleteOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationalUnitResponse> deleteOrganizationalUnit(
            DeleteOrganizationalUnitRequest deleteOrganizationalUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an organizational unit (OU) from a root or another OU. You must first remove all accounts and child OUs
     * from the OU that you want to delete.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationalUnitRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOrganizationalUnitRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationalUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteOrganizationalUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>OrganizationalUnitNotEmptyException The specified OU is not empty. Move all accounts to another root
     *         or to other OUs, remove all child OUs, and try the operation again.</li>
     *         <li>OrganizationalUnitNotFoundException We can't find an OU with the <code>OrganizationalUnitId</code>
     *         that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeleteOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationalUnitResponse> deleteOrganizationalUnit(
            Consumer<DeleteOrganizationalUnitRequest.Builder> deleteOrganizationalUnitRequest) {
        return deleteOrganizationalUnit(DeleteOrganizationalUnitRequest.builder().applyMutation(deleteOrganizationalUnitRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified policy from your organization. Before you perform this operation, you must first detach the
     * policy from all organizational units (OUs), roots, and accounts.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     *
     * @param deletePolicyRequest
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyInUseException The policy is attached to one or more entities. You must detach it from all
     *         roots, OUs, and accounts before performing this operation.</li>
     *         <li>PolicyNotFoundException We can't find a policy with the <code>PolicyId</code> that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeletePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified policy from your organization. Before you perform this operation, you must first detach the
     * policy from all organizational units (OUs), roots, and accounts.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DeletePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyInUseException The policy is attached to one or more entities. You must detach it from all
     *         roots, OUs, and accounts before performing this operation.</li>
     *         <li>PolicyNotFoundException We can't find a policy with the <code>PolicyId</code> that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeletePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest) {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the resource policy from your organization.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ResourcePolicyNotFoundException We can't find a resource policy request with the parameter that you
     *         specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource policy from your organization.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DeleteResourcePolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ResourcePolicyNotFoundException We can't find a resource policy request with the parameter that you
     *         specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Removes the specified member Amazon Web Services account as a delegated administrator for the specified Amazon
     * Web Services service.
     * </p>
     * <important>
     * <p>
     * Deregistering a delegated administrator can have unintended impacts on the functionality of the enabled Amazon
     * Web Services service. See the documentation for the enabled service before you deregister a delegated
     * administrator so that you understand any potential impacts.
     * </p>
     * </important>
     * <p>
     * You can run this action only for Amazon Web Services services that support this feature. For a current list of
     * services that support it, see the column <i>Supports Delegated Administrator</i> in the table at <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web
     * Services Services that you can use with Organizations</a> in the <i>Organizations User Guide.</i>
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     *
     * @param deregisterDelegatedAdministratorRequest
     * @return A Java Future containing the result of the DeregisterDelegatedAdministrator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AccountNotFoundException We can't find an Amazon Web Services account with the <code>AccountId</code>
     *         that you specified, or the account whose credentials you used to make this request isn't a member of an
     *         organization.</li>
     *         <li>AccountNotRegisteredException The specified account is not a delegated administrator for this Amazon
     *         Web Services service.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeregisterDelegatedAdministrator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeregisterDelegatedAdministrator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterDelegatedAdministratorResponse> deregisterDelegatedAdministrator(
            DeregisterDelegatedAdministratorRequest deregisterDelegatedAdministratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified member Amazon Web Services account as a delegated administrator for the specified Amazon
     * Web Services service.
     * </p>
     * <important>
     * <p>
     * Deregistering a delegated administrator can have unintended impacts on the functionality of the enabled Amazon
     * Web Services service. See the documentation for the enabled service before you deregister a delegated
     * administrator so that you understand any potential impacts.
     * </p>
     * </important>
     * <p>
     * You can run this action only for Amazon Web Services services that support this feature. For a current list of
     * services that support it, see the column <i>Supports Delegated Administrator</i> in the table at <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web
     * Services Services that you can use with Organizations</a> in the <i>Organizations User Guide.</i>
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterDelegatedAdministratorRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterDelegatedAdministratorRequest#builder()}
     * </p>
     *
     * @param deregisterDelegatedAdministratorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeregisterDelegatedAdministrator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AccountNotFoundException We can't find an Amazon Web Services account with the <code>AccountId</code>
     *         that you specified, or the account whose credentials you used to make this request isn't a member of an
     *         organization.</li>
     *         <li>AccountNotRegisteredException The specified account is not a delegated administrator for this Amazon
     *         Web Services service.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DeregisterDelegatedAdministrator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeregisterDelegatedAdministrator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterDelegatedAdministratorResponse> deregisterDelegatedAdministrator(
            Consumer<DeregisterDelegatedAdministratorRequest.Builder> deregisterDelegatedAdministratorRequest) {
        return deregisterDelegatedAdministrator(DeregisterDelegatedAdministratorRequest.builder()
                .applyMutation(deregisterDelegatedAdministratorRequest).build());
    }

    /**
     * <p>
     * Retrieves Organizations-related information about the specified account.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     *
     * @param describeAccountRequest
     * @return A Java Future containing the result of the DescribeAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AccountNotFoundException We can't find an Amazon Web Services account with the <code>AccountId</code>
     *         that you specified, or the account whose credentials you used to make this request isn't a member of an
     *         organization.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountResponse> describeAccount(DescribeAccountRequest describeAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves Organizations-related information about the specified account.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAccountRequest#builder()}
     * </p>
     *
     * @param describeAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DescribeAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AccountNotFoundException We can't find an Amazon Web Services account with the <code>AccountId</code>
     *         that you specified, or the account whose credentials you used to make this request isn't a member of an
     *         organization.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountResponse> describeAccount(
            Consumer<DescribeAccountRequest.Builder> describeAccountRequest) {
        return describeAccount(DescribeAccountRequest.builder().applyMutation(describeAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves the current status of an asynchronous request to create an account.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     *
     * @param describeCreateAccountStatusRequest
     * @return A Java Future containing the result of the DescribeCreateAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>CreateAccountStatusNotFoundException We can't find an create account request with the
     *         <code>CreateAccountRequestId</code> that you specified.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeCreateAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeCreateAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCreateAccountStatusResponse> describeCreateAccountStatus(
            DescribeCreateAccountStatusRequest describeCreateAccountStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current status of an asynchronous request to create an account.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCreateAccountStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCreateAccountStatusRequest#builder()}
     * </p>
     *
     * @param describeCreateAccountStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCreateAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>CreateAccountStatusNotFoundException We can't find an create account request with the
     *         <code>CreateAccountRequestId</code> that you specified.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeCreateAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeCreateAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCreateAccountStatusResponse> describeCreateAccountStatus(
            Consumer<DescribeCreateAccountStatusRequest.Builder> describeCreateAccountStatusRequest) {
        return describeCreateAccountStatus(DescribeCreateAccountStatusRequest.builder()
                .applyMutation(describeCreateAccountStatusRequest).build());
    }

    /**
     * <p>
     * Returns the contents of the effective policy for specified policy type and account. The effective policy is the
     * aggregation of any policies of the specified type that the account inherits, plus any policy of that type that is
     * directly attached to the account.
     * </p>
     * <p>
     * This operation applies only to management policies. It does not apply to authorization policies: service control
     * policies (SCPs) and resource control policies (RCPs).
     * </p>
     * <p>
     * For more information about policy inheritance, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_inheritance_mgmt.html"
     * >Understanding management policy inheritance</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * This operation can be called from any account in the organization.
     * </p>
     *
     * @param describeEffectivePolicyRequest
     * @return A Java Future containing the result of the DescribeEffectivePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>TargetNotFoundException We can't find a root, OU, account, or policy with the <code>TargetId</code>
     *         that you specified.</li>
     *         <li>EffectivePolicyNotFoundException If you ran this action on the management account, this policy type
     *         is not enabled. If you ran the action on a member account, the account doesn't have an effective policy
     *         of this type. Contact the administrator of your organization about attaching a policy of this type to the
     *         account.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeEffectivePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeEffectivePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectivePolicyResponse> describeEffectivePolicy(
            DescribeEffectivePolicyRequest describeEffectivePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the contents of the effective policy for specified policy type and account. The effective policy is the
     * aggregation of any policies of the specified type that the account inherits, plus any policy of that type that is
     * directly attached to the account.
     * </p>
     * <p>
     * This operation applies only to management policies. It does not apply to authorization policies: service control
     * policies (SCPs) and resource control policies (RCPs).
     * </p>
     * <p>
     * For more information about policy inheritance, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_inheritance_mgmt.html"
     * >Understanding management policy inheritance</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * This operation can be called from any account in the organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEffectivePolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEffectivePolicyRequest#builder()}
     * </p>
     *
     * @param describeEffectivePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEffectivePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>TargetNotFoundException We can't find a root, OU, account, or policy with the <code>TargetId</code>
     *         that you specified.</li>
     *         <li>EffectivePolicyNotFoundException If you ran this action on the management account, this policy type
     *         is not enabled. If you ran the action on a member account, the account doesn't have an effective policy
     *         of this type. Contact the administrator of your organization about attaching a policy of this type to the
     *         account.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeEffectivePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeEffectivePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectivePolicyResponse> describeEffectivePolicy(
            Consumer<DescribeEffectivePolicyRequest.Builder> describeEffectivePolicyRequest) {
        return describeEffectivePolicy(DescribeEffectivePolicyRequest.builder().applyMutation(describeEffectivePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a previously requested handshake. The handshake ID comes from the response to the
     * original <a>InviteAccountToOrganization</a> operation that generated the handshake.
     * </p>
     * <p>
     * You can access handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, or <code>CANCELED</code> for
     * only 30 days after they change to that state. They're then deleted and no longer accessible.
     * </p>
     * <p>
     * This operation can be called from any account in the organization.
     * </p>
     *
     * @param describeHandshakeRequest
     * @return A Java Future containing the result of the DescribeHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>HandshakeNotFoundException We can't find a handshake with the <code>HandshakeId</code> that you
     *         specified.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHandshakeResponse> describeHandshake(DescribeHandshakeRequest describeHandshakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a previously requested handshake. The handshake ID comes from the response to the
     * original <a>InviteAccountToOrganization</a> operation that generated the handshake.
     * </p>
     * <p>
     * You can access handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, or <code>CANCELED</code> for
     * only 30 days after they change to that state. They're then deleted and no longer accessible.
     * </p>
     * <p>
     * This operation can be called from any account in the organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHandshakeRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeHandshakeRequest#builder()}
     * </p>
     *
     * @param describeHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>HandshakeNotFoundException We can't find a handshake with the <code>HandshakeId</code> that you
     *         specified.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHandshakeResponse> describeHandshake(
            Consumer<DescribeHandshakeRequest.Builder> describeHandshakeRequest) {
        return describeHandshake(DescribeHandshakeRequest.builder().applyMutation(describeHandshakeRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the organization that the user's account belongs to.
     * </p>
     * <p>
     * This operation can be called from any account in the organization.
     * </p>
     * <note>
     * <p>
     * Even if a policy type is shown as available in the organization, you can disable it separately at the root level
     * with <a>DisablePolicyType</a>. Use <a>ListRoots</a> to see the status of policy types for a specified root.
     * </p>
     * </note>
     *
     * @param describeOrganizationRequest
     * @return A Java Future containing the result of the DescribeOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationResponse> describeOrganization(
            DescribeOrganizationRequest describeOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the organization that the user's account belongs to.
     * </p>
     * <p>
     * This operation can be called from any account in the organization.
     * </p>
     * <note>
     * <p>
     * Even if a policy type is shown as available in the organization, you can disable it separately at the root level
     * with <a>DisablePolicyType</a>. Use <a>ListRoots</a> to see the status of policy types for a specified root.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOrganizationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DescribeOrganizationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationResponse> describeOrganization(
            Consumer<DescribeOrganizationRequest.Builder> describeOrganizationRequest) {
        return describeOrganization(DescribeOrganizationRequest.builder().applyMutation(describeOrganizationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the organization that the user's account belongs to.
     * </p>
     * <p>
     * This operation can be called from any account in the organization.
     * </p>
     * <note>
     * <p>
     * Even if a policy type is shown as available in the organization, you can disable it separately at the root level
     * with <a>DisablePolicyType</a>. Use <a>ListRoots</a> to see the status of policy types for a specified root.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationResponse> describeOrganization() {
        return describeOrganization(DescribeOrganizationRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information about an organizational unit (OU).
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     *
     * @param describeOrganizationalUnitRequest
     * @return A Java Future containing the result of the DescribeOrganizationalUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>OrganizationalUnitNotFoundException We can't find an OU with the <code>OrganizationalUnitId</code>
     *         that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationalUnitResponse> describeOrganizationalUnit(
            DescribeOrganizationalUnitRequest describeOrganizationalUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an organizational unit (OU).
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationalUnitRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOrganizationalUnitRequest#builder()}
     * </p>
     *
     * @param describeOrganizationalUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrganizationalUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>OrganizationalUnitNotFoundException We can't find an OU with the <code>OrganizationalUnitId</code>
     *         that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationalUnitResponse> describeOrganizationalUnit(
            Consumer<DescribeOrganizationalUnitRequest.Builder> describeOrganizationalUnitRequest) {
        return describeOrganizationalUnit(DescribeOrganizationalUnitRequest.builder()
                .applyMutation(describeOrganizationalUnitRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a policy.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     *
     * @param describePolicyRequest
     * @return A Java Future containing the result of the DescribePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyNotFoundException We can't find a policy with the <code>PolicyId</code> that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePolicyResponse> describePolicy(DescribePolicyRequest describePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a policy.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePolicyRequest#builder()}
     * </p>
     *
     * @param describePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DescribePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyNotFoundException We can't find a policy with the <code>PolicyId</code> that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePolicyResponse> describePolicy(Consumer<DescribePolicyRequest.Builder> describePolicyRequest) {
        return describePolicy(DescribePolicyRequest.builder().applyMutation(describePolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a resource policy.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ResourcePolicyNotFoundException We can't find a resource policy request with the parameter that you
     *         specified.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a resource policy.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourcePolicyRequest#builder()}
     * </p>
     *
     * @param describeResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DescribeResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ResourcePolicyNotFoundException We can't find a resource policy request with the parameter that you
     *         specified.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            Consumer<DescribeResourcePolicyRequest.Builder> describeResourcePolicyRequest) {
        return describeResourcePolicy(DescribeResourcePolicyRequest.builder().applyMutation(describeResourcePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Detaches a policy from a target root, organizational unit (OU), or account.
     * </p>
     * <important>
     * <p>
     * If the policy being detached is a service control policy (SCP), the changes to permissions for Identity and
     * Access Management (IAM) users and roles in affected accounts are immediate.
     * </p>
     * </important>
     * <p>
     * Every root, OU, and account must have at least one SCP attached. If you want to replace the default
     * <code>FullAWSAccess</code> policy with an SCP that limits the permissions that can be delegated, you must attach
     * the replacement SCP before you can remove the default SCP. This is the authorization strategy of an
     * "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_allowlist
     * ">allow list</a>". If you instead attach a second SCP and leave the <code>FullAWSAccess</code> SCP still
     * attached, and specify <code>"Effect": "Deny"</code> in the second SCP to override the
     * <code>"Effect": "Allow"</code> in the <code>FullAWSAccess</code> policy (or any other attached SCP), you're using
     * the authorization strategy of a
     * "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies
     * .html#orgs_policies_denylist">deny list</a>".
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     *
     * @param detachPolicyRequest
     * @return A Java Future containing the result of the DetachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyNotAttachedException The policy isn't attached to the specified target in the specified root.</li>
     *         <li>PolicyNotFoundException We can't find a policy with the <code>PolicyId</code> that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TargetNotFoundException We can't find a root, OU, account, or policy with the <code>TargetId</code>
     *         that you specified.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>PolicyChangesInProgressException Changes to the effective policy are in progress, and its contents
     *         can't be returned. Try the operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DetachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DetachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetachPolicyResponse> detachPolicy(DetachPolicyRequest detachPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a policy from a target root, organizational unit (OU), or account.
     * </p>
     * <important>
     * <p>
     * If the policy being detached is a service control policy (SCP), the changes to permissions for Identity and
     * Access Management (IAM) users and roles in affected accounts are immediate.
     * </p>
     * </important>
     * <p>
     * Every root, OU, and account must have at least one SCP attached. If you want to replace the default
     * <code>FullAWSAccess</code> policy with an SCP that limits the permissions that can be delegated, you must attach
     * the replacement SCP before you can remove the default SCP. This is the authorization strategy of an
     * "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_allowlist
     * ">allow list</a>". If you instead attach a second SCP and leave the <code>FullAWSAccess</code> SCP still
     * attached, and specify <code>"Effect": "Deny"</code> in the second SCP to override the
     * <code>"Effect": "Allow"</code> in the <code>FullAWSAccess</code> policy (or any other attached SCP), you're using
     * the authorization strategy of a
     * "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies
     * .html#orgs_policies_denylist">deny list</a>".
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DetachPolicyRequest#builder()}
     * </p>
     *
     * @param detachPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DetachPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyNotAttachedException The policy isn't attached to the specified target in the specified root.</li>
     *         <li>PolicyNotFoundException We can't find a policy with the <code>PolicyId</code> that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TargetNotFoundException We can't find a root, OU, account, or policy with the <code>TargetId</code>
     *         that you specified.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>PolicyChangesInProgressException Changes to the effective policy are in progress, and its contents
     *         can't be returned. Try the operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DetachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DetachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetachPolicyResponse> detachPolicy(Consumer<DetachPolicyRequest.Builder> detachPolicyRequest) {
        return detachPolicy(DetachPolicyRequest.builder().applyMutation(detachPolicyRequest).build());
    }

    /**
     * <p>
     * Disables the integration of an Amazon Web Services service (the service that is specified by
     * <code>ServicePrincipal</code>) with Organizations. When you disable integration, the specified service no longer
     * can create a <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">service-linked role</a>
     * in <i>new</i> accounts in your organization. This means the service can't perform operations on your behalf on
     * any new accounts in your organization. The service can still perform operations in older accounts until the
     * service completes its clean-up from Organizations.
     * </p>
     * <important>
     * <p>
     * We <b> <i>strongly recommend</i> </b> that you don't use this command to disable integration between
     * Organizations and the specified Amazon Web Services service. Instead, use the console or commands that are
     * provided by the specified service. This lets the trusted service perform any required initialization when
     * enabling trusted access, such as creating any required resources and any required clean up of resources when
     * disabling trusted access.
     * </p>
     * <p>
     * For information about how to disable trusted service access to your organization using the trusted service, see
     * the <b>Learn more</b> link under the <b>Supports Trusted Access</b> column at <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web
     * Services services that you can use with Organizations</a>. on this page.
     * </p>
     * <p>
     * If you disable access by using this command, it causes the following actions to occur:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The service can no longer create a service-linked role in the accounts in your organization. This means that the
     * service can't perform operations on your behalf on any new accounts in your organization. The service can still
     * perform operations in older accounts until the service completes its clean-up from Organizations.
     * </p>
     * </li>
     * <li>
     * <p>
     * The service can no longer perform tasks in the member accounts in the organization, unless those operations are
     * explicitly permitted by the IAM policies that are attached to your roles. This includes any data aggregation from
     * the member accounts to the management account, or to a delegated administrator account, where relevant.
     * </p>
     * </li>
     * <li>
     * <p>
     * Some services detect this and clean up any remaining data or resources related to the integration, while other
     * services stop accessing the organization but leave any historical data and configuration in place to support a
     * possible re-enabling of the integration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Using the other service's console or commands to disable the integration ensures that the other service is aware
     * that it can clean up any resources that are required only for the integration. How the service cleans up its
     * resources in the organization's accounts depends on that service. For more information, see the documentation for
     * the other Amazon Web Services service.
     * </p>
     * </important>
     * <p>
     * After you perform the <code>DisableAWSServiceAccess</code> operation, the specified service can no longer perform
     * operations in your organization's accounts
     * </p>
     * <p>
     * For more information about integrating other services with Organizations, including the list of services that
     * work with Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Using
     * Organizations with other Amazon Web Services services</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     *
     * @param disableAwsServiceAccessRequest
     * @return A Java Future containing the result of the DisableAWSServiceAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DisableAWSServiceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisableAWSServiceAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableAwsServiceAccessResponse> disableAWSServiceAccess(
            DisableAwsServiceAccessRequest disableAwsServiceAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the integration of an Amazon Web Services service (the service that is specified by
     * <code>ServicePrincipal</code>) with Organizations. When you disable integration, the specified service no longer
     * can create a <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">service-linked role</a>
     * in <i>new</i> accounts in your organization. This means the service can't perform operations on your behalf on
     * any new accounts in your organization. The service can still perform operations in older accounts until the
     * service completes its clean-up from Organizations.
     * </p>
     * <important>
     * <p>
     * We <b> <i>strongly recommend</i> </b> that you don't use this command to disable integration between
     * Organizations and the specified Amazon Web Services service. Instead, use the console or commands that are
     * provided by the specified service. This lets the trusted service perform any required initialization when
     * enabling trusted access, such as creating any required resources and any required clean up of resources when
     * disabling trusted access.
     * </p>
     * <p>
     * For information about how to disable trusted service access to your organization using the trusted service, see
     * the <b>Learn more</b> link under the <b>Supports Trusted Access</b> column at <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web
     * Services services that you can use with Organizations</a>. on this page.
     * </p>
     * <p>
     * If you disable access by using this command, it causes the following actions to occur:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The service can no longer create a service-linked role in the accounts in your organization. This means that the
     * service can't perform operations on your behalf on any new accounts in your organization. The service can still
     * perform operations in older accounts until the service completes its clean-up from Organizations.
     * </p>
     * </li>
     * <li>
     * <p>
     * The service can no longer perform tasks in the member accounts in the organization, unless those operations are
     * explicitly permitted by the IAM policies that are attached to your roles. This includes any data aggregation from
     * the member accounts to the management account, or to a delegated administrator account, where relevant.
     * </p>
     * </li>
     * <li>
     * <p>
     * Some services detect this and clean up any remaining data or resources related to the integration, while other
     * services stop accessing the organization but leave any historical data and configuration in place to support a
     * possible re-enabling of the integration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Using the other service's console or commands to disable the integration ensures that the other service is aware
     * that it can clean up any resources that are required only for the integration. How the service cleans up its
     * resources in the organization's accounts depends on that service. For more information, see the documentation for
     * the other Amazon Web Services service.
     * </p>
     * </important>
     * <p>
     * After you perform the <code>DisableAWSServiceAccess</code> operation, the specified service can no longer perform
     * operations in your organization's accounts
     * </p>
     * <p>
     * For more information about integrating other services with Organizations, including the list of services that
     * work with Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Using
     * Organizations with other Amazon Web Services services</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableAwsServiceAccessRequest.Builder} avoiding
     * the need to create one manually via {@link DisableAwsServiceAccessRequest#builder()}
     * </p>
     *
     * @param disableAwsServiceAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableAWSServiceAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DisableAWSServiceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisableAWSServiceAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableAwsServiceAccessResponse> disableAWSServiceAccess(
            Consumer<DisableAwsServiceAccessRequest.Builder> disableAwsServiceAccessRequest) {
        return disableAWSServiceAccess(DisableAwsServiceAccessRequest.builder().applyMutation(disableAwsServiceAccessRequest)
                .build());
    }

    /**
     * <p>
     * Disables an organizational policy type in a root. A policy of a certain type can be attached to entities in a
     * root only if that type is enabled in the root. After you perform this operation, you no longer can attach
     * policies of the specified type to that root or to any organizational unit (OU) or account in that root. You can
     * undo this by using the <a>EnablePolicyType</a> operation.
     * </p>
     * <p>
     * This is an asynchronous request that Amazon Web Services performs in the background. If you disable a policy type
     * for a root, it still appears enabled for the organization if <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all
     * features</a> are enabled for the organization. Amazon Web Services recommends that you first use <a>ListRoots</a>
     * to see the status of policy types for a specified root, and then use this operation.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <p>
     * To view the status of available policy types in the organization, use <a>ListRoots</a>.
     * </p>
     *
     * @param disablePolicyTypeRequest
     * @return A Java Future containing the result of the DisablePolicyType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyTypeNotEnabledException The specified policy type isn't currently enabled in this root. You
     *         can't attach policies of the specified type to entities in a root until you enable that type in the root.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     *         >Enabling all features in your organization</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>RootNotFoundException We can't find a root with the <code>RootId</code> that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>PolicyChangesInProgressException Changes to the effective policy are in progress, and its contents
     *         can't be returned. Try the operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DisablePolicyType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisablePolicyType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisablePolicyTypeResponse> disablePolicyType(DisablePolicyTypeRequest disablePolicyTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables an organizational policy type in a root. A policy of a certain type can be attached to entities in a
     * root only if that type is enabled in the root. After you perform this operation, you no longer can attach
     * policies of the specified type to that root or to any organizational unit (OU) or account in that root. You can
     * undo this by using the <a>EnablePolicyType</a> operation.
     * </p>
     * <p>
     * This is an asynchronous request that Amazon Web Services performs in the background. If you disable a policy type
     * for a root, it still appears enabled for the organization if <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all
     * features</a> are enabled for the organization. Amazon Web Services recommends that you first use <a>ListRoots</a>
     * to see the status of policy types for a specified root, and then use this operation.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account or by a member account that is a
     * delegated administrator.
     * </p>
     * <p>
     * To view the status of available policy types in the organization, use <a>ListRoots</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisablePolicyTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DisablePolicyTypeRequest#builder()}
     * </p>
     *
     * @param disablePolicyTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisablePolicyType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>PolicyTypeNotEnabledException The specified policy type isn't currently enabled in this root. You
     *         can't attach policies of the specified type to entities in a root until you enable that type in the root.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     *         >Enabling all features in your organization</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>RootNotFoundException We can't find a root with the <code>RootId</code> that you specified.</li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't available in the current Amazon Web Services
     *         Region.</li>
     *         <li>PolicyChangesInProgressException Changes to the effective policy are in progress, and its contents
     *         can't be returned. Try the operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OrganizationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OrganizationsAsyncClient.DisablePolicyType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisablePolicyType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisablePolicyTypeResponse> disablePolicyType(
            Consumer<DisablePolicyTypeRequest.Builder> disablePolicyTypeRequest) {
        return disablePolicyType(DisablePolicyTypeRequest.builder().applyMutation(disablePolicyTypeRequest).build());
    }

    /**
     * <p>
     * Provides an Amazon Web Services service (the service that is specified by <code>ServicePrincipal</code>) with
     * permissions to view the structure of an organization, create a <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">service-linked role</a>
     * in all the accounts in the organization, and allow the service to perform operations on behalf of the
     * organization and its accounts. Establishing these permissions can be a first step in enabling the integration of
     * an Amazon Web Services service with Organizations.
     * </p>
     * <important>
     * <p>
     * We recommend that you enable integration between Organizations and the specified Amazon Web Services service by
     * using the console or commands that are provided by the specified service. Doing so ensures that the service is
     * aware that it can create the resources that are required for the integration. How the service creates those
     * resources in the organization's accounts depends on that service. For more information, see the documentation for
     * the other Amazon Web Services service.
     * </p>
     * </important>
     * <p>
     * For more information about enabling services to integrate with Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Using
     * Organizations with other Amazon Web Services services</a> in the <i>Organizations User Guide</i>.
     * </p>
     * <p>
     * This operation can be called only from the organization's management account.
     * </p>
     *
     * @param enableAwsServiceAccessRequest
     * @return A Java Future containing the result of the EnableAWSServiceAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>AwsOrganizationsNotInUseException Your account isn't a member of an organization. To make this
     *         request, you must use the credentials of an account that belongs to an organization.</li>
     *         <li>ConcurrentModificationException The target of the operation is currently being modified by a
     *         different request. Try again later.</li>
     *         <li>ConstraintViolationException Performing this operation violates a minimum or maximum value limit. For
     *         example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or
     *         creating too many accounts to the organization, or attaching too many policies to an account, OU, or
     *         root. This exception includes a reason that contains additional information about the violated limit:</p>
     *         <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization.
     *         You can't remove the management account. Instead, after you remove all member accounts, delete the
     *         organization itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization
     *         that doesn't yet have enough information to exist as a standalone account. This account requires you to
     *         first complete phone verification. Follow the steps at <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master"
     *         >Removing a member account from your organization</a> in the <i>Organizations User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create
     *         in one day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your account isn't fully active. You
     *         must complete the account setup before you create an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an
     *         organization. If you need more accounts, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an
     *         increase in your limit.
     *         </p>
     *         <p>
     *         Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in
     *         your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase
     *         in the number of accounts.
     *         </p>
     *         <note>
     *         <p>
     *         Deleted and closed accounts still count toward your limit.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you get this exception when running a command immediately after creating the organization, wait one
     *         hour and try again. After an hour, if the command continues to fail with this error, contact <a
     *         href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED: Your organization has more than 5000 accounts,
     *         and you can only use the standard migration process for organizations with less than 5000 accounts. Use
     *         the assisted migration process to enable all features mode, or create a support case for assistance if
     *         you are unable to use assisted migration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot register a suspended account as
     *         a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of
     *         the organization as a delegated administrator for an Amazon Web Services service integrated with
     *         Organizations. You can designate only a member account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management
     *         account for the organization, you must first either remove or close all member accounts in the
     *         organization. Follow standard account closure process using root credentials.​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as
     *         a delegated administrator for a service integrated with your organization. To complete this operation,
     *         you must first deregister this account as a delegated administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close
     *         at a time. ​
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified
     *         region, you must enable all features mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account
     *         as a delegated administrator for an Amazon Web Services service that already has a delegated
     *         administrator. To complete this operation, you must first deregister any existing delegated
     *         administrators for this service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time.
     *         You must resubmit the request and generate a new verfication code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one
     *         day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is
     *         associated with the account. Amazon Web Services does not support cards issued by financial institutions
     *         in Russia or Belarus. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your
     *         Amazon Web Services payments</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first
     *         must migrate the organization's management account to the marketplace that corresponds to the management
     *         account's address. All accounts in an organization must be associated with the same marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services Regions in China. To
     *         create an organization, the master must have a valid business license. For more information, contact
     *         customer support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact
     *         address and phone number for the management account. Then try the operation again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an
     *         associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a>
     *         in the <i>Amazon Web Services GovCloud User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated
     *         administrators than allowed for the service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain
     *         type that can be attached to an entity at one time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you
     *         first must associate a valid payment instrument, such as a credit card, with the account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html"
     *         >Considerations before removing an account from an organization</a> in the <i>Organizations User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would
     *         cause the entity to have fewer than the minimum number of policies of a certain type required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the
     *         organization to be configured to support all features. An organization that supports only consolidated
     *         billing features can't perform this operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POLICY_TYPE_ENABLED_FOR_THIS_SERVICE: You attempted to disable service access before you disabled the
     *         policy type (for example, SECURITYHUB_POLICY). To complete this operation, you must first disable the
     *         policy type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_ACCESS_NOT_ENABLED:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to register a delegated administrator before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You attempted to enable a policy type before you enabled service access. Call the
     *         <code>EnableAWSServiceAccess</code> API first.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with
     *         the tag policy requirements for this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, you must wait until at least four
     *         days after the account was created. Invited accounts aren't subject to this waiting period.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The requested operation failed because you provided invalid values for one or
     *         more of the request parameters. This exception includes a reason that contains additional information
     *         about the violated limit:</p> <note>
     *         <p>
     *         Some of the reasons in the following list might not be applicable to this specific API or operation.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INPUT_REQUIRED: You must include a value for all required parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM: You specified an invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a
     *         previous call of the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a
     *         party.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN: You provided a value that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved
     *         prefix <code>AWSServiceRoleFor</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or
     *         delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
     *         </p>
     *         </li></li>
     *         <li>ServiceException Organizations can't complete your request because of an internal service error. Try
     *         again later.</li>
     *         <li>TooManyRequestsException You have sent too many requests in too short a period of time. The quota
     *         helps protect against denial-of-service attacks. Try again later.</p>
     *         <p>
     *         For information about quotas that affect Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for
     *         Organizations</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>UnsupportedApiEndpointException This action isn't ava