/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePolicyRequest extends OrganizationsRequest implements
        ToCopyableBuilder<CreatePolicyRequest.Builder, CreatePolicyRequest> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(CreatePolicyRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreatePolicyRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreatePolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreatePolicyRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreatePolicyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, TYPE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String content;

    private final String description;

    private final String name;

    private final String type;

    private final List<Tag> tags;

    private CreatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.description = builder.description;
        this.name = builder.name;
        this.type = builder.type;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The policy text content to add to the new policy. The text that you supply must adhere to the rules of the policy
     * type you specify in the <code>Type</code> parameter.
     * </p>
     * <p>
     * The maximum size of a policy document depends on the policy's type. For more information, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values"
     * >Maximum and minimum values</a> in the <i>Organizations User Guide</i>.
     * </p>
     * 
     * @return The policy text content to add to the new policy. The text that you supply must adhere to the rules of
     *         the policy type you specify in the <code>Type</code> parameter. </p>
     *         <p>
     *         The maximum size of a policy document depends on the policy's type. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values"
     *         >Maximum and minimum values</a> in the <i>Organizations User Guide</i>.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * An optional description to assign to the policy.
     * </p>
     * 
     * @return An optional description to assign to the policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The friendly name to assign to the policy.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
     * string of any of the characters in the ASCII character range.
     * </p>
     * 
     * @return The friendly name to assign to the policy.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter
     *         is a string of any of the characters in the ASCII character range.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of policy to create. You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     * SERVICE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     * RESOURCE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
     * SECURITYHUB_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of policy to create. You can specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     *         SERVICE_CONTROL_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     *         RESOURCE_CONTROL_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
     *         >DECLARATIVE_POLICY_EC2</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     *         BACKUP_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
     *         >TAG_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     *         CHATBOT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     *         AISERVICES_OPT_OUT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
     *         >SECURITYHUB_POLICY</a>
     *         </p>
     *         </li>
     * @see PolicyType
     */
    public final PolicyType type() {
        return PolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of policy to create. You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     * SERVICE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     * RESOURCE_CONTROL_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
     * SECURITYHUB_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of policy to create. You can specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
     *         SERVICE_CONTROL_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
     *         RESOURCE_CONTROL_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
     *         >DECLARATIVE_POLICY_EC2</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     *         BACKUP_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
     *         >TAG_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     *         CHATBOT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     *         AISERVICES_OPT_OUT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
     *         >SECURITYHUB_POLICY</a>
     *         </p>
     *         </li>
     * @see PolicyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that you want to attach to the newly created policy. For each tag in the list, you must specify
     * both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>.
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     * resources</a> in the Organizations User Guide.
     * </p>
     * <note>
     * <p>
     * If any one of the tags is not valid or if you exceed the allowed number of tags for a policy, then the entire
     * request fails and the policy is not created.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that you want to attach to the newly created policy. For each tag in the list, you must
     *         specify both a tag key and a value. You can set the value to an empty string, but you can't set it to
     *         <code>null</code>. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     *         resources</a> in the Organizations User Guide.</p> <note>
     *         <p>
     *         If any one of the tags is not valid or if you exceed the allowed number of tags for a policy, then the
     *         entire request fails and the policy is not created.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyRequest)) {
            return false;
        }
        CreatePolicyRequest other = (CreatePolicyRequest) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePolicyRequest").add("Content", content()).add("Description", description())
                .add("Name", name()).add("Type", typeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Content", CONTENT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyRequest, T> g) {
        return obj -> g.apply((CreatePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OrganizationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePolicyRequest> {
        /**
         * <p>
         * The policy text content to add to the new policy. The text that you supply must adhere to the rules of the
         * policy type you specify in the <code>Type</code> parameter.
         * </p>
         * <p>
         * The maximum size of a policy document depends on the policy's type. For more information, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values"
         * >Maximum and minimum values</a> in the <i>Organizations User Guide</i>.
         * </p>
         * 
         * @param content
         *        The policy text content to add to the new policy. The text that you supply must adhere to the rules of
         *        the policy type you specify in the <code>Type</code> parameter. </p>
         *        <p>
         *        The maximum size of a policy document depends on the policy's type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values"
         *        >Maximum and minimum values</a> in the <i>Organizations User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * An optional description to assign to the policy.
         * </p>
         * 
         * @param description
         *        An optional description to assign to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The friendly name to assign to the policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
         * string of any of the characters in the ASCII character range.
         * </p>
         * 
         * @param name
         *        The friendly name to assign to the policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this
         *        parameter is a string of any of the characters in the ASCII character range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of policy to create. You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
         * SERVICE_CONTROL_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
         * RESOURCE_CONTROL_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
         * DECLARATIVE_POLICY_EC2</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         * BACKUP_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
         * TAG_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         * CHATBOT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
         * AISERVICES_OPT_OUT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
         * SECURITYHUB_POLICY</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of policy to create. You can specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
         *        SERVICE_CONTROL_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
         *        RESOURCE_CONTROL_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
         *        >DECLARATIVE_POLICY_EC2</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         *        BACKUP_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
         *        >TAG_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         *        CHATBOT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html"
         *        >AISERVICES_OPT_OUT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
         *        >SECURITYHUB_POLICY</a>
         *        </p>
         *        </li>
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of policy to create. You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
         * SERVICE_CONTROL_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
         * RESOURCE_CONTROL_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
         * DECLARATIVE_POLICY_EC2</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         * BACKUP_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
         * TAG_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         * CHATBOT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
         * AISERVICES_OPT_OUT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
         * SECURITYHUB_POLICY</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of policy to create. You can specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">
         *        SERVICE_CONTROL_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html">
         *        RESOURCE_CONTROL_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
         *        >DECLARATIVE_POLICY_EC2</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         *        BACKUP_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
         *        >TAG_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         *        CHATBOT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html"
         *        >AISERVICES_OPT_OUT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
         *        >SECURITYHUB_POLICY</a>
         *        </p>
         *        </li>
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder type(PolicyType type);

        /**
         * <p>
         * A list of tags that you want to attach to the newly created policy. For each tag in the list, you must
         * specify both a tag key and a value. You can set the value to an empty string, but you can't set it to
         * <code>null</code>. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
         * resources</a> in the Organizations User Guide.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is not valid or if you exceed the allowed number of tags for a policy, then the entire
         * request fails and the policy is not created.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the newly created policy. For each tag in the list, you must
         *        specify both a tag key and a value. You can set the value to an empty string, but you can't set it to
         *        <code>null</code>. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging
         *        Organizations resources</a> in the Organizations User Guide.</p> <note>
         *        <p>
         *        If any one of the tags is not valid or if you exceed the allowed number of tags for a policy, then the
         *        entire request fails and the policy is not created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that you want to attach to the newly created policy. For each tag in the list, you must
         * specify both a tag key and a value. You can set the value to an empty string, but you can't set it to
         * <code>null</code>. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
         * resources</a> in the Organizations User Guide.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is not valid or if you exceed the allowed number of tags for a policy, then the entire
         * request fails and the policy is not created.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the newly created policy. For each tag in the list, you must
         *        specify both a tag key and a value. You can set the value to an empty string, but you can't set it to
         *        <code>null</code>. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging
         *        Organizations resources</a> in the Organizations User Guide.</p> <note>
         *        <p>
         *        If any one of the tags is not valid or if you exceed the allowed number of tags for a policy, then the
         *        entire request fails and the policy is not created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that you want to attach to the newly created policy. For each tag in the list, you must
         * specify both a tag key and a value. You can set the value to an empty string, but you can't set it to
         * <code>null</code>. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
         * resources</a> in the Organizations User Guide.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is not valid or if you exceed the allowed number of tags for a policy, then the entire
         * request fails and the policy is not created.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.organizations.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.organizations.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.organizations.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.organizations.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String content;

        private String description;

        private String name;

        private String type;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyRequest model) {
            super(model);
            content(model.content);
            description(model.description);
            name(model.name);
            type(model.type);
            tags(model.tags);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePolicyRequest build() {
            return new CreatePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
