/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterDelegatedAdministratorRequest extends OrganizationsRequest implements
        ToCopyableBuilder<DeregisterDelegatedAdministratorRequest.Builder, DeregisterDelegatedAdministratorRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(DeregisterDelegatedAdministratorRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServicePrincipal").getter(getter(DeregisterDelegatedAdministratorRequest::servicePrincipal))
            .setter(setter(Builder::servicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            SERVICE_PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String servicePrincipal;

    private DeregisterDelegatedAdministratorRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.servicePrincipal = builder.servicePrincipal;
    }

    /**
     * <p>
     * The account ID number of the member account in the organization that you want to deregister as a delegated
     * administrator.
     * </p>
     * 
     * @return The account ID number of the member account in the organization that you want to deregister as a
     *         delegated administrator.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The service principal name of an Amazon Web Services service for which the account is a delegated administrator.
     * </p>
     * <p>
     * Delegated administrator privileges are revoked for only the specified Amazon Web Services service from the member
     * account. If the specified service is the only service for which the member account is a delegated administrator,
     * the operation also revokes Organizations read action permissions.
     * </p>
     * 
     * @return The service principal name of an Amazon Web Services service for which the account is a delegated
     *         administrator.</p>
     *         <p>
     *         Delegated administrator privileges are revoked for only the specified Amazon Web Services service from
     *         the member account. If the specified service is the only service for which the member account is a
     *         delegated administrator, the operation also revokes Organizations read action permissions.
     */
    public final String servicePrincipal() {
        return servicePrincipal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterDelegatedAdministratorRequest)) {
            return false;
        }
        DeregisterDelegatedAdministratorRequest other = (DeregisterDelegatedAdministratorRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(servicePrincipal(), other.servicePrincipal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterDelegatedAdministratorRequest").add("AccountId", accountId())
                .add("ServicePrincipal", servicePrincipal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ServicePrincipal":
            return Optional.ofNullable(clazz.cast(servicePrincipal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ServicePrincipal", SERVICE_PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterDelegatedAdministratorRequest, T> g) {
        return obj -> g.apply((DeregisterDelegatedAdministratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OrganizationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterDelegatedAdministratorRequest> {
        /**
         * <p>
         * The account ID number of the member account in the organization that you want to deregister as a delegated
         * administrator.
         * </p>
         * 
         * @param accountId
         *        The account ID number of the member account in the organization that you want to deregister as a
         *        delegated administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The service principal name of an Amazon Web Services service for which the account is a delegated
         * administrator.
         * </p>
         * <p>
         * Delegated administrator privileges are revoked for only the specified Amazon Web Services service from the
         * member account. If the specified service is the only service for which the member account is a delegated
         * administrator, the operation also revokes Organizations read action permissions.
         * </p>
         * 
         * @param servicePrincipal
         *        The service principal name of an Amazon Web Services service for which the account is a delegated
         *        administrator.</p>
         *        <p>
         *        Delegated administrator privileges are revoked for only the specified Amazon Web Services service from
         *        the member account. If the specified service is the only service for which the member account is a
         *        delegated administrator, the operation also revokes Organizations read action permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(String servicePrincipal);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String accountId;

        private String servicePrincipal;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterDelegatedAdministratorRequest model) {
            super(model);
            accountId(model.accountId);
            servicePrincipal(model.servicePrincipal);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getServicePrincipal() {
            return servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterDelegatedAdministratorRequest build() {
            return new DeregisterDelegatedAdministratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
