/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The requested operation failed because you provided invalid values for one or more of the request parameters. This
 * exception includes a reason that contains additional information about the violated limit:
 * </p>
 * <note>
 * <p>
 * Some of the reasons in the following list might not be applicable to this specific API or operation.
 * </p>
 * </note>
 * <ul>
 * <li>
 * <p>
 * DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
 * </p>
 * </li>
 * <li>
 * <p>
 * IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
 * </p>
 * </li>
 * <li>
 * <p>
 * INPUT_REQUIRED: You must include a value for all required parameters.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_ENUM: You specified an invalid value.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call
 * of the operation.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_PATTERN: You provided a value that doesn't match the required pattern.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_PRINCIPAL: You specified an invalid principal element in the policy.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix
 * <code>AWSServiceRoleFor</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system
 * tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource
 * limit.
 * </p>
 * </li>
 * <li>
 * <p>
 * MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
 * </p>
 * </li>
 * <li>
 * <p>
 * MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
 * </p>
 * </li>
 * <li>
 * <p>
 * MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
 * </p>
 * </li>
 * <li>
 * <p>
 * MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
 * </p>
 * </li>
 * <li>
 * <p>
 * MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
 * </p>
 * </li>
 * <li>
 * <p>
 * MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
 * </p>
 * </li>
 * <li>
 * <p>
 * NON_DETACHABLE_POLICY: You can't detach this Amazon Web Services Managed Policy.
 * </p>
 * </li>
 * <li>
 * <p>
 * TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
 * </p>
 * </li>
 * <li>
 * <p>
 * UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidInputException extends OrganizationsException implements
        ToCopyableBuilder<InvalidInputException.Builder, InvalidInputException> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(InvalidInputException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reason;

    private InvalidInputException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link InvalidInputExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see InvalidInputExceptionReason
     */
    public InvalidInputExceptionReason reason() {
        return InvalidInputExceptionReason.fromValue(reason);
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link InvalidInputExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see InvalidInputExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidInputException, T> g) {
        return obj -> g.apply((InvalidInputException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidInputException>, OrganizationsException.Builder {
        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see InvalidInputExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvalidInputExceptionReason
         */
        Builder reason(String reason);

        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see InvalidInputExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvalidInputExceptionReason
         */
        Builder reason(InvalidInputExceptionReason reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends OrganizationsException.BuilderImpl implements Builder {
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidInputException model) {
            super(model);
            reason(model.reason);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(InvalidInputExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public InvalidInputException build() {
            return new InvalidInputException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
