/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountsWithInvalidEffectivePolicyResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListAccountsWithInvalidEffectivePolicyResponse.Builder, ListAccountsWithInvalidEffectivePolicyResponse> {
    private static final SdkField<List<Account>> ACCOUNTS_FIELD = SdkField
            .<List<Account>> builder(MarshallingType.LIST)
            .memberName("Accounts")
            .getter(getter(ListAccountsWithInvalidEffectivePolicyResponse::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Account> builder(MarshallingType.SDK_POJO)
                                            .constructor(Account::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(ListAccountsWithInvalidEffectivePolicyResponse::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAccountsWithInvalidEffectivePolicyResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD,
            POLICY_TYPE_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Account> accounts;

    private final String policyType;

    private final String nextToken;

    private ListAccountsWithInvalidEffectivePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.accounts = builder.accounts;
        this.policyType = builder.policyType;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The accounts in the organization which have an invalid effective policy for the specified policy type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return The accounts in the organization which have an invalid effective policy for the specified policy type.
     */
    public final List<Account> accounts() {
        return accounts;
    }

    /**
     * <p>
     * The specified policy type. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
     * SECURITYHUB_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link EffectivePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The specified policy type. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
     *         >DECLARATIVE_POLICY_EC2</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     *         BACKUP_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
     *         >TAG_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     *         CHATBOT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     *         AISERVICES_OPT_OUT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
     *         >SECURITYHUB_POLICY</a>
     *         </p>
     *         </li>
     * @see EffectivePolicyType
     */
    public final EffectivePolicyType policyType() {
        return EffectivePolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The specified policy type. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
     * SECURITYHUB_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link EffectivePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The specified policy type. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
     *         >DECLARATIVE_POLICY_EC2</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     *         BACKUP_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
     *         >TAG_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     *         CHATBOT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     *         AISERVICES_OPT_OUT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
     *         >SECURITYHUB_POLICY</a>
     *         </p>
     *         </li>
     * @see EffectivePolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsWithInvalidEffectivePolicyResponse)) {
            return false;
        }
        ListAccountsWithInvalidEffectivePolicyResponse other = (ListAccountsWithInvalidEffectivePolicyResponse) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccountsWithInvalidEffectivePolicyResponse")
                .add("Accounts", hasAccounts() ? accounts() : null).add("PolicyType", policyTypeAsString())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Accounts", ACCOUNTS_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountsWithInvalidEffectivePolicyResponse, T> g) {
        return obj -> g.apply((ListAccountsWithInvalidEffectivePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccountsWithInvalidEffectivePolicyResponse> {
        /**
         * <p>
         * The accounts in the organization which have an invalid effective policy for the specified policy type.
         * </p>
         * 
         * @param accounts
         *        The accounts in the organization which have an invalid effective policy for the specified policy type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<Account> accounts);

        /**
         * <p>
         * The accounts in the organization which have an invalid effective policy for the specified policy type.
         * </p>
         * 
         * @param accounts
         *        The accounts in the organization which have an invalid effective policy for the specified policy type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Account... accounts);

        /**
         * <p>
         * The accounts in the organization which have an invalid effective policy for the specified policy type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.organizations.model.Account.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.organizations.model.Account#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.organizations.model.Account.Builder#build()} is called immediately and
         * its result is passed to {@link #accounts(List<Account>)}.
         * 
         * @param accounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.organizations.model.Account.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accounts(java.util.Collection<Account>)
         */
        Builder accounts(Consumer<Account.Builder>... accounts);

        /**
         * <p>
         * The specified policy type. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
         * DECLARATIVE_POLICY_EC2</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         * BACKUP_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
         * TAG_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         * CHATBOT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
         * AISERVICES_OPT_OUT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
         * SECURITYHUB_POLICY</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyType
         *        The specified policy type. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
         *        >DECLARATIVE_POLICY_EC2</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         *        BACKUP_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
         *        >TAG_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         *        CHATBOT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html"
         *        >AISERVICES_OPT_OUT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
         *        >SECURITYHUB_POLICY</a>
         *        </p>
         *        </li>
         * @see EffectivePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The specified policy type. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
         * DECLARATIVE_POLICY_EC2</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         * BACKUP_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
         * TAG_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         * CHATBOT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
         * AISERVICES_OPT_OUT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
         * SECURITYHUB_POLICY</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyType
         *        The specified policy type. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
         *        >DECLARATIVE_POLICY_EC2</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         *        BACKUP_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
         *        >TAG_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         *        CHATBOT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html"
         *        >AISERVICES_OPT_OUT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
         *        >SECURITYHUB_POLICY</a>
         *        </p>
         *        </li>
         * @see EffectivePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePolicyType
         */
        Builder policyType(EffectivePolicyType policyType);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private List<Account> accounts = DefaultSdkAutoConstructList.getInstance();

        private String policyType;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountsWithInvalidEffectivePolicyResponse model) {
            super(model);
            accounts(model.accounts);
            policyType(model.policyType);
            nextToken(model.nextToken);
        }

        public final List<Account.Builder> getAccounts() {
            List<Account.Builder> result = AccountsCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<Account.BuilderImpl> accounts) {
            this.accounts = AccountsCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<Account> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Account... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<Account.Builder>... accounts) {
            accounts(Stream.of(accounts).map(c -> Account.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(EffectivePolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccountsWithInvalidEffectivePolicyResponse build() {
            return new ListAccountsWithInvalidEffectivePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
