/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDelegatedAdministratorsResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListDelegatedAdministratorsResponse.Builder, ListDelegatedAdministratorsResponse> {
    private static final SdkField<List<DelegatedAdministrator>> DELEGATED_ADMINISTRATORS_FIELD = SdkField
            .<List<DelegatedAdministrator>> builder(MarshallingType.LIST)
            .memberName("DelegatedAdministrators")
            .getter(getter(ListDelegatedAdministratorsResponse::delegatedAdministrators))
            .setter(setter(Builder::delegatedAdministrators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegatedAdministrators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DelegatedAdministrator> builder(MarshallingType.SDK_POJO)
                                            .constructor(DelegatedAdministrator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDelegatedAdministratorsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DELEGATED_ADMINISTRATORS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DelegatedAdministrator> delegatedAdministrators;

    private final String nextToken;

    private ListDelegatedAdministratorsResponse(BuilderImpl builder) {
        super(builder);
        this.delegatedAdministrators = builder.delegatedAdministrators;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DelegatedAdministrators property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDelegatedAdministrators() {
        return delegatedAdministrators != null && !(delegatedAdministrators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of delegated administrators in your organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDelegatedAdministrators} method.
     * </p>
     * 
     * @return The list of delegated administrators in your organization.
     */
    public final List<DelegatedAdministrator> delegatedAdministrators() {
        return delegatedAdministrators;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDelegatedAdministrators() ? delegatedAdministrators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDelegatedAdministratorsResponse)) {
            return false;
        }
        ListDelegatedAdministratorsResponse other = (ListDelegatedAdministratorsResponse) obj;
        return hasDelegatedAdministrators() == other.hasDelegatedAdministrators()
                && Objects.equals(delegatedAdministrators(), other.delegatedAdministrators())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDelegatedAdministratorsResponse")
                .add("DelegatedAdministrators", hasDelegatedAdministrators() ? delegatedAdministrators() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DelegatedAdministrators":
            return Optional.ofNullable(clazz.cast(delegatedAdministrators()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DelegatedAdministrators", DELEGATED_ADMINISTRATORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDelegatedAdministratorsResponse, T> g) {
        return obj -> g.apply((ListDelegatedAdministratorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDelegatedAdministratorsResponse> {
        /**
         * <p>
         * The list of delegated administrators in your organization.
         * </p>
         * 
         * @param delegatedAdministrators
         *        The list of delegated administrators in your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegatedAdministrators(Collection<DelegatedAdministrator> delegatedAdministrators);

        /**
         * <p>
         * The list of delegated administrators in your organization.
         * </p>
         * 
         * @param delegatedAdministrators
         *        The list of delegated administrators in your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegatedAdministrators(DelegatedAdministrator... delegatedAdministrators);

        /**
         * <p>
         * The list of delegated administrators in your organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.organizations.model.DelegatedAdministrator.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.organizations.model.DelegatedAdministrator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.organizations.model.DelegatedAdministrator.Builder#build()} is called
         * immediately and its result is passed to {@link #delegatedAdministrators(List<DelegatedAdministrator>)}.
         * 
         * @param delegatedAdministrators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.organizations.model.DelegatedAdministrator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegatedAdministrators(java.util.Collection<DelegatedAdministrator>)
         */
        Builder delegatedAdministrators(Consumer<DelegatedAdministrator.Builder>... delegatedAdministrators);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private List<DelegatedAdministrator> delegatedAdministrators = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDelegatedAdministratorsResponse model) {
            super(model);
            delegatedAdministrators(model.delegatedAdministrators);
            nextToken(model.nextToken);
        }

        public final List<DelegatedAdministrator.Builder> getDelegatedAdministrators() {
            List<DelegatedAdministrator.Builder> result = DelegatedAdministratorsCopier
                    .copyToBuilder(this.delegatedAdministrators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDelegatedAdministrators(Collection<DelegatedAdministrator.BuilderImpl> delegatedAdministrators) {
            this.delegatedAdministrators = DelegatedAdministratorsCopier.copyFromBuilder(delegatedAdministrators);
        }

        @Override
        public final Builder delegatedAdministrators(Collection<DelegatedAdministrator> delegatedAdministrators) {
            this.delegatedAdministrators = DelegatedAdministratorsCopier.copy(delegatedAdministrators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegatedAdministrators(DelegatedAdministrator... delegatedAdministrators) {
            delegatedAdministrators(Arrays.asList(delegatedAdministrators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegatedAdministrators(Consumer<DelegatedAdministrator.Builder>... delegatedAdministrators) {
            delegatedAdministrators(Stream.of(delegatedAdministrators)
                    .map(c -> DelegatedAdministrator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDelegatedAdministratorsResponse build() {
            return new ListDelegatedAdministratorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
