/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEffectivePolicyValidationErrorsResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListEffectivePolicyValidationErrorsResponse.Builder, ListEffectivePolicyValidationErrorsResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ListEffectivePolicyValidationErrorsResponse::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(ListEffectivePolicyValidationErrorsResponse::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(ListEffectivePolicyValidationErrorsResponse::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<Instant> EVALUATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationTimestamp").getter(getter(ListEffectivePolicyValidationErrorsResponse::evaluationTimestamp))
            .setter(setter(Builder::evaluationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationTimestamp").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEffectivePolicyValidationErrorsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<EffectivePolicyValidationError>> EFFECTIVE_POLICY_VALIDATION_ERRORS_FIELD = SdkField
            .<List<EffectivePolicyValidationError>> builder(MarshallingType.LIST)
            .memberName("EffectivePolicyValidationErrors")
            .getter(getter(ListEffectivePolicyValidationErrorsResponse::effectivePolicyValidationErrors))
            .setter(setter(Builder::effectivePolicyValidationErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectivePolicyValidationErrors")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EffectivePolicyValidationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(EffectivePolicyValidationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCOUNT_ID_FIELD, POLICY_TYPE_FIELD, PATH_FIELD, EVALUATION_TIMESTAMP_FIELD, NEXT_TOKEN_FIELD,
                    EFFECTIVE_POLICY_VALIDATION_ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String policyType;

    private final String path;

    private final Instant evaluationTimestamp;

    private final String nextToken;

    private final List<EffectivePolicyValidationError> effectivePolicyValidationErrors;

    private ListEffectivePolicyValidationErrorsResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.policyType = builder.policyType;
        this.path = builder.path;
        this.evaluationTimestamp = builder.evaluationTimestamp;
        this.nextToken = builder.nextToken;
        this.effectivePolicyValidationErrors = builder.effectivePolicyValidationErrors;
    }

    /**
     * <p>
     * The ID of the specified account.
     * </p>
     * 
     * @return The ID of the specified account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The specified policy type. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
     * SECURITYHUB_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link EffectivePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The specified policy type. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
     *         >DECLARATIVE_POLICY_EC2</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     *         BACKUP_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
     *         >TAG_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     *         CHATBOT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     *         AISERVICES_OPT_OUT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
     *         >SECURITYHUB_POLICY</a>
     *         </p>
     *         </li>
     * @see EffectivePolicyType
     */
    public final EffectivePolicyType policyType() {
        return EffectivePolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The specified policy type. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
     * DECLARATIVE_POLICY_EC2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     * BACKUP_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
     * TAG_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     * CHATBOT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     * AISERVICES_OPT_OUT_POLICY</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
     * SECURITYHUB_POLICY</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link EffectivePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The specified policy type. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
     *         >DECLARATIVE_POLICY_EC2</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
     *         BACKUP_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
     *         >TAG_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
     *         CHATBOT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
     *         AISERVICES_OPT_OUT_POLICY</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
     *         >SECURITYHUB_POLICY</a>
     *         </p>
     *         </li>
     * @see EffectivePolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * The path in the organization where the specified account exists.
     * </p>
     * 
     * @return The path in the organization where the specified account exists.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The time when the latest effective policy was generated for the specified account.
     * </p>
     * 
     * @return The time when the latest effective policy was generated for the specified account.
     */
    public final Instant evaluationTimestamp() {
        return evaluationTimestamp;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EffectivePolicyValidationErrors
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasEffectivePolicyValidationErrors() {
        return effectivePolicyValidationErrors != null && !(effectivePolicyValidationErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>EffectivePolicyValidationError</code> object contains details about the validation errors that occurred
     * when generating or enforcing an effective policy, such as which policies contributed to the error and location of
     * the error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEffectivePolicyValidationErrors}
     * method.
     * </p>
     * 
     * @return The <code>EffectivePolicyValidationError</code> object contains details about the validation errors that
     *         occurred when generating or enforcing an effective policy, such as which policies contributed to the
     *         error and location of the error.
     */
    public final List<EffectivePolicyValidationError> effectivePolicyValidationErrors() {
        return effectivePolicyValidationErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasEffectivePolicyValidationErrors() ? effectivePolicyValidationErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEffectivePolicyValidationErrorsResponse)) {
            return false;
        }
        ListEffectivePolicyValidationErrorsResponse other = (ListEffectivePolicyValidationErrorsResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(path(), other.path()) && Objects.equals(evaluationTimestamp(), other.evaluationTimestamp())
                && Objects.equals(nextToken(), other.nextToken())
                && hasEffectivePolicyValidationErrors() == other.hasEffectivePolicyValidationErrors()
                && Objects.equals(effectivePolicyValidationErrors(), other.effectivePolicyValidationErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListEffectivePolicyValidationErrorsResponse")
                .add("AccountId", accountId())
                .add("PolicyType", policyTypeAsString())
                .add("Path", path())
                .add("EvaluationTimestamp", evaluationTimestamp())
                .add("NextToken", nextToken())
                .add("EffectivePolicyValidationErrors",
                        hasEffectivePolicyValidationErrors() ? effectivePolicyValidationErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "EvaluationTimestamp":
            return Optional.ofNullable(clazz.cast(evaluationTimestamp()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "EffectivePolicyValidationErrors":
            return Optional.ofNullable(clazz.cast(effectivePolicyValidationErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("EvaluationTimestamp", EVALUATION_TIMESTAMP_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("EffectivePolicyValidationErrors", EFFECTIVE_POLICY_VALIDATION_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEffectivePolicyValidationErrorsResponse, T> g) {
        return obj -> g.apply((ListEffectivePolicyValidationErrorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEffectivePolicyValidationErrorsResponse> {
        /**
         * <p>
         * The ID of the specified account.
         * </p>
         * 
         * @param accountId
         *        The ID of the specified account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The specified policy type. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
         * DECLARATIVE_POLICY_EC2</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         * BACKUP_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
         * TAG_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         * CHATBOT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
         * AISERVICES_OPT_OUT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
         * SECURITYHUB_POLICY</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyType
         *        The specified policy type. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
         *        >DECLARATIVE_POLICY_EC2</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         *        BACKUP_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
         *        >TAG_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         *        CHATBOT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html"
         *        >AISERVICES_OPT_OUT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
         *        >SECURITYHUB_POLICY</a>
         *        </p>
         *        </li>
         * @see EffectivePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The specified policy type. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html">
         * DECLARATIVE_POLICY_EC2</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         * BACKUP_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">
         * TAG_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         * CHATBOT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">
         * AISERVICES_OPT_OUT_POLICY</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html">
         * SECURITYHUB_POLICY</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyType
         *        The specified policy type. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html"
         *        >DECLARATIVE_POLICY_EC2</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">
         *        BACKUP_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html"
         *        >TAG_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html">
         *        CHATBOT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html"
         *        >AISERVICES_OPT_OUT_POLICY</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html"
         *        >SECURITYHUB_POLICY</a>
         *        </p>
         *        </li>
         * @see EffectivePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePolicyType
         */
        Builder policyType(EffectivePolicyType policyType);

        /**
         * <p>
         * The path in the organization where the specified account exists.
         * </p>
         * 
         * @param path
         *        The path in the organization where the specified account exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The time when the latest effective policy was generated for the specified account.
         * </p>
         * 
         * @param evaluationTimestamp
         *        The time when the latest effective policy was generated for the specified account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationTimestamp(Instant evaluationTimestamp);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The <code>EffectivePolicyValidationError</code> object contains details about the validation errors that
         * occurred when generating or enforcing an effective policy, such as which policies contributed to the error
         * and location of the error.
         * </p>
         * 
         * @param effectivePolicyValidationErrors
         *        The <code>EffectivePolicyValidationError</code> object contains details about the validation errors
         *        that occurred when generating or enforcing an effective policy, such as which policies contributed to
         *        the error and location of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectivePolicyValidationErrors(Collection<EffectivePolicyValidationError> effectivePolicyValidationErrors);

        /**
         * <p>
         * The <code>EffectivePolicyValidationError</code> object contains details about the validation errors that
         * occurred when generating or enforcing an effective policy, such as which policies contributed to the error
         * and location of the error.
         * </p>
         * 
         * @param effectivePolicyValidationErrors
         *        The <code>EffectivePolicyValidationError</code> object contains details about the validation errors
         *        that occurred when generating or enforcing an effective policy, such as which policies contributed to
         *        the error and location of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectivePolicyValidationErrors(EffectivePolicyValidationError... effectivePolicyValidationErrors);

        /**
         * <p>
         * The <code>EffectivePolicyValidationError</code> object contains details about the validation errors that
         * occurred when generating or enforcing an effective policy, such as which policies contributed to the error
         * and location of the error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.organizations.model.EffectivePolicyValidationError.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.organizations.model.EffectivePolicyValidationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.organizations.model.EffectivePolicyValidationError.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #effectivePolicyValidationErrors(List<EffectivePolicyValidationError>)}.
         * 
         * @param effectivePolicyValidationErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.organizations.model.EffectivePolicyValidationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #effectivePolicyValidationErrors(java.util.Collection<EffectivePolicyValidationError>)
         */
        Builder effectivePolicyValidationErrors(
                Consumer<EffectivePolicyValidationError.Builder>... effectivePolicyValidationErrors);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private String accountId;

        private String policyType;

        private String path;

        private Instant evaluationTimestamp;

        private String nextToken;

        private List<EffectivePolicyValidationError> effectivePolicyValidationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEffectivePolicyValidationErrorsResponse model) {
            super(model);
            accountId(model.accountId);
            policyType(model.policyType);
            path(model.path);
            evaluationTimestamp(model.evaluationTimestamp);
            nextToken(model.nextToken);
            effectivePolicyValidationErrors(model.effectivePolicyValidationErrors);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(EffectivePolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Instant getEvaluationTimestamp() {
            return evaluationTimestamp;
        }

        public final void setEvaluationTimestamp(Instant evaluationTimestamp) {
            this.evaluationTimestamp = evaluationTimestamp;
        }

        @Override
        public final Builder evaluationTimestamp(Instant evaluationTimestamp) {
            this.evaluationTimestamp = evaluationTimestamp;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EffectivePolicyValidationError.Builder> getEffectivePolicyValidationErrors() {
            List<EffectivePolicyValidationError.Builder> result = EffectivePolicyValidationErrorsCopier
                    .copyToBuilder(this.effectivePolicyValidationErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectivePolicyValidationErrors(
                Collection<EffectivePolicyValidationError.BuilderImpl> effectivePolicyValidationErrors) {
            this.effectivePolicyValidationErrors = EffectivePolicyValidationErrorsCopier
                    .copyFromBuilder(effectivePolicyValidationErrors);
        }

        @Override
        public final Builder effectivePolicyValidationErrors(
                Collection<EffectivePolicyValidationError> effectivePolicyValidationErrors) {
            this.effectivePolicyValidationErrors = EffectivePolicyValidationErrorsCopier.copy(effectivePolicyValidationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePolicyValidationErrors(EffectivePolicyValidationError... effectivePolicyValidationErrors) {
            effectivePolicyValidationErrors(Arrays.asList(effectivePolicyValidationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePolicyValidationErrors(
                Consumer<EffectivePolicyValidationError.Builder>... effectivePolicyValidationErrors) {
            effectivePolicyValidationErrors(Stream.of(effectivePolicyValidationErrors)
                    .map(c -> EffectivePolicyValidationError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEffectivePolicyValidationErrorsResponse build() {
            return new ListEffectivePolicyValidationErrorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
