/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRootsResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListRootsResponse.Builder, ListRootsResponse> {
    private static final SdkField<List<Root>> ROOTS_FIELD = SdkField
            .<List<Root>> builder(MarshallingType.LIST)
            .memberName("Roots")
            .getter(getter(ListRootsResponse::roots))
            .setter(setter(Builder::roots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Root> builder(MarshallingType.SDK_POJO)
                                            .constructor(Root::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRootsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ROOTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Root> roots;

    private final String nextToken;

    private ListRootsResponse(BuilderImpl builder) {
        super(builder);
        this.roots = builder.roots;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Roots property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRoots() {
        return roots != null && !(roots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of roots that are defined in an organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoots} method.
     * </p>
     * 
     * @return A list of roots that are defined in an organization.
     */
    public final List<Root> roots() {
        return roots;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRoots() ? roots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRootsResponse)) {
            return false;
        }
        ListRootsResponse other = (ListRootsResponse) obj;
        return hasRoots() == other.hasRoots() && Objects.equals(roots(), other.roots())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRootsResponse").add("Roots", hasRoots() ? roots() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Roots":
            return Optional.ofNullable(clazz.cast(roots()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Roots", ROOTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRootsResponse, T> g) {
        return obj -> g.apply((ListRootsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OrganizationsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRootsResponse> {
        /**
         * <p>
         * A list of roots that are defined in an organization.
         * </p>
         * 
         * @param roots
         *        A list of roots that are defined in an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roots(Collection<Root> roots);

        /**
         * <p>
         * A list of roots that are defined in an organization.
         * </p>
         * 
         * @param roots
         *        A list of roots that are defined in an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roots(Root... roots);

        /**
         * <p>
         * A list of roots that are defined in an organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.organizations.model.Root.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.organizations.model.Root#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.organizations.model.Root.Builder#build()} is called immediately and
         * its result is passed to {@link #roots(List<Root>)}.
         * 
         * @param roots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.organizations.model.Root.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roots(java.util.Collection<Root>)
         */
        Builder roots(Consumer<Root.Builder>... roots);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private List<Root> roots = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRootsResponse model) {
            super(model);
            roots(model.roots);
            nextToken(model.nextToken);
        }

        public final List<Root.Builder> getRoots() {
            List<Root.Builder> result = RootsCopier.copyToBuilder(this.roots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoots(Collection<Root.BuilderImpl> roots) {
            this.roots = RootsCopier.copyFromBuilder(roots);
        }

        @Override
        public final Builder roots(Collection<Root> roots) {
            this.roots = RootsCopier.copy(roots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roots(Root... roots) {
            roots(Arrays.asList(roots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roots(Consumer<Root.Builder>... roots) {
            roots(Stream.of(roots).map(c -> Root.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRootsResponse build() {
            return new ListRootsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
