/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains details about a resource policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePolicy implements SdkPojo, Serializable, ToCopyableBuilder<ResourcePolicy.Builder, ResourcePolicy> {
    private static final SdkField<ResourcePolicySummary> RESOURCE_POLICY_SUMMARY_FIELD = SdkField
            .<ResourcePolicySummary> builder(MarshallingType.SDK_POJO).memberName("ResourcePolicySummary")
            .getter(getter(ResourcePolicy::resourcePolicySummary)).setter(setter(Builder::resourcePolicySummary))
            .constructor(ResourcePolicySummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicySummary").build())
            .build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(ResourcePolicy::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_POLICY_SUMMARY_FIELD,
            CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResourcePolicySummary resourcePolicySummary;

    private final String content;

    private ResourcePolicy(BuilderImpl builder) {
        this.resourcePolicySummary = builder.resourcePolicySummary;
        this.content = builder.content;
    }

    /**
     * <p>
     * A structure that contains resource policy ID and Amazon Resource Name (ARN).
     * </p>
     * 
     * @return A structure that contains resource policy ID and Amazon Resource Name (ARN).
     */
    public final ResourcePolicySummary resourcePolicySummary() {
        return resourcePolicySummary;
    }

    /**
     * <p>
     * The policy text of the resource policy.
     * </p>
     * 
     * @return The policy text of the resource policy.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicySummary());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePolicy)) {
            return false;
        }
        ResourcePolicy other = (ResourcePolicy) obj;
        return Objects.equals(resourcePolicySummary(), other.resourcePolicySummary())
                && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcePolicy").add("ResourcePolicySummary", resourcePolicySummary()).add("Content", content())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourcePolicySummary":
            return Optional.ofNullable(clazz.cast(resourcePolicySummary()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourcePolicySummary", RESOURCE_POLICY_SUMMARY_FIELD);
        map.put("Content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcePolicy, T> g) {
        return obj -> g.apply((ResourcePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePolicy> {
        /**
         * <p>
         * A structure that contains resource policy ID and Amazon Resource Name (ARN).
         * </p>
         * 
         * @param resourcePolicySummary
         *        A structure that contains resource policy ID and Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicySummary(ResourcePolicySummary resourcePolicySummary);

        /**
         * <p>
         * A structure that contains resource policy ID and Amazon Resource Name (ARN).
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourcePolicySummary.Builder} avoiding
         * the need to create one manually via {@link ResourcePolicySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourcePolicySummary.Builder#build()} is called immediately and
         * its result is passed to {@link #resourcePolicySummary(ResourcePolicySummary)}.
         * 
         * @param resourcePolicySummary
         *        a consumer that will call methods on {@link ResourcePolicySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcePolicySummary(ResourcePolicySummary)
         */
        default Builder resourcePolicySummary(Consumer<ResourcePolicySummary.Builder> resourcePolicySummary) {
            return resourcePolicySummary(ResourcePolicySummary.builder().applyMutation(resourcePolicySummary).build());
        }

        /**
         * <p>
         * The policy text of the resource policy.
         * </p>
         * 
         * @param content
         *        The policy text of the resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);
    }

    static final class BuilderImpl implements Builder {
        private ResourcePolicySummary resourcePolicySummary;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePolicy model) {
            resourcePolicySummary(model.resourcePolicySummary);
            content(model.content);
        }

        public final ResourcePolicySummary.Builder getResourcePolicySummary() {
            return resourcePolicySummary != null ? resourcePolicySummary.toBuilder() : null;
        }

        public final void setResourcePolicySummary(ResourcePolicySummary.BuilderImpl resourcePolicySummary) {
            this.resourcePolicySummary = resourcePolicySummary != null ? resourcePolicySummary.build() : null;
        }

        @Override
        public final Builder resourcePolicySummary(ResourcePolicySummary resourcePolicySummary) {
            this.resourcePolicySummary = resourcePolicySummary;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public ResourcePolicy build() {
            return new ResourcePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
