/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.osis.OsisClient;
import software.amazon.awssdk.services.osis.OsisServiceClientConfiguration;
import software.amazon.awssdk.services.osis.model.AccessDeniedException;
import software.amazon.awssdk.services.osis.model.ConflictException;
import software.amazon.awssdk.services.osis.model.CreatePipelineRequest;
import software.amazon.awssdk.services.osis.model.CreatePipelineResponse;
import software.amazon.awssdk.services.osis.model.DeletePipelineRequest;
import software.amazon.awssdk.services.osis.model.DeletePipelineResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineResponse;
import software.amazon.awssdk.services.osis.model.InternalException;
import software.amazon.awssdk.services.osis.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.osis.model.LimitExceededException;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse;
import software.amazon.awssdk.services.osis.model.ListPipelinesRequest;
import software.amazon.awssdk.services.osis.model.ListPipelinesResponse;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.osis.model.OsisException;
import software.amazon.awssdk.services.osis.model.OsisRequest;
import software.amazon.awssdk.services.osis.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.osis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.osis.model.StartPipelineRequest;
import software.amazon.awssdk.services.osis.model.StartPipelineResponse;
import software.amazon.awssdk.services.osis.model.StopPipelineRequest;
import software.amazon.awssdk.services.osis.model.StopPipelineResponse;
import software.amazon.awssdk.services.osis.model.TagResourceRequest;
import software.amazon.awssdk.services.osis.model.TagResourceResponse;
import software.amazon.awssdk.services.osis.model.UntagResourceRequest;
import software.amazon.awssdk.services.osis.model.UntagResourceResponse;
import software.amazon.awssdk.services.osis.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.osis.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.osis.model.ValidatePipelineRequest;
import software.amazon.awssdk.services.osis.model.ValidatePipelineResponse;
import software.amazon.awssdk.services.osis.model.ValidationException;
import software.amazon.awssdk.services.osis.paginators.ListPipelinesIterable;
import software.amazon.awssdk.services.osis.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.GetPipelineBlueprintRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.GetPipelineChangeProgressRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.GetPipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ListPipelineBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.StartPipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.StopPipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ValidatePipelineRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultOsisClient
implements OsisClient {
    private static final Logger log = Logger.loggerFor(DefaultOsisClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final OsisServiceClientConfiguration serviceClientConfiguration;

    protected DefaultOsisClient(OsisServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, createPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePipeline");
            CreatePipelineResponse createPipelineResponse = (CreatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$createPipeline$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, deletePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePipeline");
            DeletePipelineResponse deletePipelineResponse = (DeletePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$deletePipeline$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineResponse getPipeline(GetPipelineRequest getPipelineRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, getPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipeline");
            GetPipelineResponse getPipelineResponse = (GetPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$getPipeline$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineBlueprintResponse getPipelineBlueprint(GetPipelineBlueprintRequest getPipelineBlueprintRequest) throws AccessDeniedException, InternalException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineBlueprintResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, getPipelineBlueprintRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineBlueprint");
            GetPipelineBlueprintResponse getPipelineBlueprintResponse = (GetPipelineBlueprintResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineBlueprint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPipelineBlueprintRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineBlueprintRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineBlueprintResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$getPipelineBlueprint$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineChangeProgressResponse getPipelineChangeProgress(GetPipelineChangeProgressRequest getPipelineChangeProgressRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineChangeProgressResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, getPipelineChangeProgressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineChangeProgress");
            GetPipelineChangeProgressResponse getPipelineChangeProgressResponse = (GetPipelineChangeProgressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineChangeProgress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPipelineChangeProgressRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineChangeProgressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineChangeProgressResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$getPipelineChangeProgress$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelineBlueprintsResponse listPipelineBlueprints(ListPipelineBlueprintsRequest listPipelineBlueprintsRequest) throws ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelineBlueprintsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, listPipelineBlueprintsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelineBlueprints");
            ListPipelineBlueprintsResponse listPipelineBlueprintsResponse = (ListPipelineBlueprintsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelineBlueprints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPipelineBlueprintsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelineBlueprintsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelineBlueprintsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$listPipelineBlueprints$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, listPipelinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelines");
            ListPipelinesResponse listPipelinesResponse = (ListPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPipelinesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelinesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$listPipelines$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPipelinesIterable listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) throws ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        return new ListPipelinesIterable(this, this.applyPaginatorUserAgent(listPipelinesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$listTagsForResource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPipelineResponse startPipeline(StartPipelineRequest startPipelineRequest) throws AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, startPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPipeline");
            StartPipelineResponse startPipelineResponse = (StartPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$startPipeline$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopPipelineResponse stopPipeline(StopPipelineRequest stopPipelineRequest) throws AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, stopPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPipeline");
            StopPipelineResponse stopPipelineResponse = (StopPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$stopPipeline$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$tagResource$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$untagResource$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, updatePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePipeline");
            UpdatePipelineResponse updatePipelineResponse = (UpdatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$updatePipeline$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidatePipelineResponse validatePipeline(ValidatePipelineRequest validatePipelineRequest) throws AccessDeniedException, InternalException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(this.clientConfiguration, validatePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ValidatePipeline");
            ValidatePipelineResponse validatePipelineResponse = (ValidatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validatePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ValidatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return validatePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$validatePipeline$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends OsisRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.74").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((OsisRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "osis";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(OsisException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    @Override
    public final OsisServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$validatePipeline$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePipeline$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPipeline$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPipeline$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelines$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelineBlueprints$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineChangeProgress$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineBlueprint$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipeline$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePipeline$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPipeline$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

